#!/usr/bin/env python3
"""
=======================================================================
Simple utility to combine .note files for spelling checks, etc. [2.3]
Optionally edit batchto, and run this in the image folder with .note
files; assuming $C is set to your source-code unzip folder:

    $ cd imagefolder
    $ python3 $C/thumbspage/docetc/batchnotes.py
    $ open _batchnotes.txt

Splitting the output to .note files, is possible (e.g., at lines that
end in '='s and have a '.note'), but has no use case at this writing.
To count the images, on Unix try [ls *.png *.jpg *.JPG *.gif | wc -l].
=======================================================================
"""

import glob, os

workdir = '.'                    # run in image folder
encoding = 'utf8'                # for .notes and combo
batchto = './_batchnotes.txt'    # edit me?

numfiles = 0
batchfile = open(batchto, mode='w', encoding=encoding)

for filename in sorted(glob.glob(os.path.join(workdir, '*.note'))):
    numfiles += 1
    print(filename)
    file = open(filename, mode='r', encoding=encoding)
    text = file.read()
    file.close()
    batchfile.write(filename.ljust(80, '=') + '\n\n')
    batchfile.write(text.rstrip() + '\n\n')

batchfile.close()
print('Batched %d .note files: see %s.' % (numfiles, batchto))


"""
=======================================================================
Example run (output at learning-python.com/trnpix/_batchnotes.txt):

~/.../trnpix$ python3 $C/thumbspage/docetc/batchnotes.py
./1996-first-pybook.png.note
./1998-puertorico-1.jpg.note
./1998-pyref1e-book.jpg.note
...etc...
./2021-android12.png.note
./2021-note20-fold3.jpg.note
./you-are-here.png.note
Batched 83 .note files: see ./_batchnotes.txt.
=======================================================================
"""
