#===================================================================
# Automatically build+publish this folder's content, only.
# This gallery has 116 images and 85 notes at last count (apr22).
#
# Launch this script from Terminal in its own folder, with:
#     cd $W/Posts/Current/Complete/trnpix
#     bash _publish.sh
#
# Also run by $W/_admin/BUILD-THUMBSPAGE-CLIENTS/_PUBLISH.sh, to 
# update all thumbspage (tp) external clients in a single step.
#
# See also: batchnotes.py to collect .note files for spellchecks;
# it's now auto-run here, as it's referenced as a demo in tp docs.
#
# New: thumbspage 2.3 allows console inputs to be provided with 
# command args, instead of <<-EOF; see the build command below.
#
# New: 2.3 allows popups' colors to deviate from the viewer-page
# defaults; e.g., popupFgColor=\'#ddddd\' selects muted-white text.
#
# New: the thumbspage build command is now split off to subscript
# _generate.sh, for both local testing and tp's examples/trnpix.
#
# New: now publishes 2 alternative index pages with crosslinks:
# fixed+dynamic.  See the _generate.sh subscript for the builds.
#===================================================================

# get common defs
source ~/MY-STUFF/Websites/_admin/BUILD-THUMBSPAGE-CLIENTS/common.sh

# save zip to $C/thumbspage/_private?
SaveInTP=y

# run note batcher in '.': it's a thumbspage 2.3 demo
py3 $C/thumbspage/docetc/batchnotes.py


#-----------------------------------------------------------------
# GALLERY: build gallery, add analytics, build website image
#-----------------------------------------------------------------

# see this folder's _generate.sh for the current build command(s)

# run the new-style command above, now in a subscript
bash _generate.sh

# already has in HEADER used by both, but may change
py3 $M/insert-analytics.py index.html
py3 $M/insert-analytics.py index-dynamic.html

# copy for nicer views of subfolder directly (mar22)
cp -p _htaccess _thumbspage/.htaccess

# local website image
cd $W
py3 _PUBLISH.py | tail -n 20


#-----------------------------------------------------------------
# UPLOAD: zip by ziptools, upload zip by scp, unzip at site by ssh
#-----------------------------------------------------------------

cd UNION
py3 $Z/zip-create.py trnpix.zip trnpix -skipcruft | tail -n 20

SCP trnpix.zip htdocs

SSH <<-EOF
	cd htdocs
	rm -rf trnpix
	unzip -d . trnpix.zip
	rm trnpix.zip
	exit 
	EOF

if [ $SaveInTP == 'y' ]
then
    mv trnpix.zip $C/thumbspage/_private/trnpix--$stamp.zip
else
    rm trnpix.zip
fi
