#===================================================================
# Generate trnpix galleries, but do not upload them.
# Run this script in its own folder, with 'bash _generate.sh'.
#
# This is also run as a subscript from this folder's _publish.py 
# prior to automatic uploads.  
#
# thumbspage's examples/trnpix runs this too, to ensure that trnpix
# results copied are current (but examples/dynamiclayout does not).
#
#=====================================================================
# [2.3] UPDATE: this now also builds a second index page for the 
# gallery, with thumbspage dynamic-index layout for less horizontal
# scrolling on typical mobile devices (i.e., candy-bar phones).  Open 
# its index-dynamic.html to view the alternative index page.  A link
# to the other index page is inserted into both indexes automatically.
#
# Details: as coded, the dynamic-alternative build creates a second 
# index page, but also remakes both thumbnails and viewer pages in a 
# second folder.  It's possible to instead reuse a single and shared 
# thumbs+viewers folder and skip thumbnail rebuilds (by simply using 
# the default folder name in the second build below).  But a second 
# folder allows thumbs size to vary if desired (e.g., smaller for 
# mobile), and also ensures that each variant's viewer pages return
# to its own index page on Index button taps.  This also replaces a
# _HEADER.html tag to make HEADER.html twice, for preamble links.
#
# Discussion: 2.3's new .5 'em' dynamic-layout scheme packs labels 
# tighter, so the new dynamic variant now renders as more than one 
# column on larger phones.  It's still not the index.html default,
# because it can leave some extra empty space on the right for some 
# window sizes on desktop, and this website's traffic is 71% desktop 
# over the last year (and probably higher, given analytics disabling).  
#
# Moreover, fixed layout may be preferred for the 26% mobile-browser 
# audience too.  Fixed requires minor horizontal scrolling in portrait
# on mobile, but not once a user is inside the gallery.  And smaller 
# phones may still display just one column of thumbnails in dynamic
# layout, which makes for a lot more vertical scrolling in this > 100 
# image gallery; dynamic largely trades hscrolls for vscrolls.
#
# OTOH, most full-size photos are larger in portrait, so rotating 
# to landscape to reduce hscrolls isn't a good workaround for mobile. 
# The real issue here is that most mobiles' form factors make them 
# inherently subpar for viewing nontrivial content; see foldables!
#=====================================================================

source ~/MY-STUFF/Websites/_admin/BUILD-THUMBSPAGE-CLIENTS/common.sh


#---------------------------------------------------------------------
# 1) Default index page: fixed layout
# make thumbs, viewer pages, and default index.html
#---------------------------------------------------------------------


# replace header tag
note='<A HREF="index-dynamic.html">dynamic-layout</A> alternative \
      resizes to fill space and avoids horizontal scrolls on mobile'

py3 -c \
    "open('HEADER.html',  'w', encoding='utf8').write( \
     open('_HEADER.html', 'r', encoding='utf8').read().replace('\$ALTPAGE\$', '$note'))"

        
# build gallery
py3 $C/thumbspage/thumbspage.py . \
           INDEX=\'index\' \
           useDynamicIndexLayout=False \
           inputCleanThumbsFolder=True inputThumbsPerRow=4 \
           inputThumbMaxSize=100 inputUseViewerPages=True \
           popupFgColor=\'tan\' \
           popupOpacity=0.45 \
           omitIndexPageLabels=False


#---------------------------------------------------------------------
# 2) Alternative index page: dynamic layout
# make new thumbs and viewer pages, and index-dynamic.html
#---------------------------------------------------------------------


# replace header tag
note='<A HREF="index.html">fixed-layout</A> alternative \
      expands to fill space and requires horizontal scrolls on mobile'

py3 -c \
    "open('HEADER.html',  'w', encoding='utf8').write( \
     open('_HEADER.html', 'r', encoding='utf8').read().replace('\$ALTPAGE\$', '$note'))"


# build gallery
py3 $C/thumbspage/thumbspage.py . \
           INDEX=\'index-dynamic\' \
           THUMBS=\'_thumbspage-dynamic\' \
           useDynamicIndexLayout=True \
           dynamicLayoutPaddingH=\'6px\' \
           dynamicLayoutPaddingV=\'6px\' \
           inputCleanThumbsFolder=True \
           inputThumbMaxSize=100 inputUseViewerPages=True \
           popupFgColor=\'tan\' \
           popupOpacity=0.45 \
           omitIndexPageLabels=False


#---------------------------------------------------------------------
# Prior build-command form (doc only)
#---------------------------------------------------------------------


## old style: use bash here document for console inputs
## use all defaults except muted white popup text (#dddddd == #ddd)
##
## py3 $C/thumbspage/thumbspage.py . popupFgColor=\'#dddddd\' <<-EOF
##	
##	
##	
##	
##	EOF
