#!/usr/bin/env python3
r"""
=========================================================================
Generate all thumbspage "examples/" galleries in a single step [2.1].
Part of the thumbspage program (learning-python.com/thumbspage.html).

--Supersedes the older Bash equivalent, generate-examples.sh--

USAGE
-----
Run me anywhere with no command-line arguments: automatically cds 
to target folders along the way.  Some component scripts use sed to
auto-edit the user-configs file, but the original file is saved and 
restored and its modtime is not changed.  By default, this script 
pauses before each folder, to allow a control-c abandon if desired.

DETAILS
-------
This script runs a _generate.sh gallery-builder script in each 
examples/ subfolder which has one.  The subfolders' scripts in 
turn use Bash 'here documents' to automate console inputs:

# in _generate.sh
python3 ../../thumbspage.py . <<-EOF

	3
	128, 128

	EOF

These subfolder scripts can also be run individually to build just 
their own folders, and some do much more work (e.g., dynamiclayout/ 
edits the user-configs file with sed, and runs a script to rename 
images).  This script is now also run by the top-level _PUBLISH.sh
script, to implement full thumbspage releases.  Hence, you can:

- Run an examples/ folder's _generate.sh, to generate just that gallery
- Run this script, to generate all thumbspage examples' galleries
- Run _PUBLISH.sh to both generate all galleries and publish thumbspage

For _PUBLISH.sh, a Bash release script runs this Python script; which 
runs per-folder Bash generate scripts;, which run thumbspage with Python.
This spans from Bash to Python to Bash to Python, but it just works.

Running this script also serves as a self-test for thumbspage, and 
running it from _PUBLISH.sh verifies before uploading the system.

NOTES
-----
Bash is optional in this system, but was used initially for both its 
'here documents' input paradigm, and its support for running many shell
commands easily.  This script was recoded in Python when it morphed 
from the latter to program logic, for which Bash seems less suited.
Python can also automate inputs, but Bash scripts were coded first.

Fine point: input prompts cannot be suppressed with '2> /dev/null' 
stderr redirects here, because Python's input() prints prompts to 
stdout (well, often; see https://bugs.python.org/issue25692).  This 
redirect works in tagpix only because it uses its own custom input().
It's also dicey - it may suppress messages for uncaught errors too.

[3.0]: Skip "_viewable" folder with "_generate.sh" - now used to 
publsh entire folder for 3.0 demo gallery sans an index.html.
=========================================================================
"""

import os, sys

Pause = True   # stop for enter or ctrl-c between examples?

code = os.environ['HOME'] + '/MY-STUFF/Code'    # edit me
os.chdir(code + '/thumbspage/examples')

def announce(example): 
    print('\n' + example)
    if Pause: 
        try:
            input('Press enter/return to continue')
        except KeyboardInterrupt:
            print('\nAborted')
            sys.exit()

def generate(example):
    wrkdir = os.getcwd()
    os.chdir(example)
    os.system('bash _generate.sh')
    os.chdir(wrkdir)

""" 
[2.2] added nested and separately built subfolders
examples = []
for name in os.listdir('.'):                        # one-level only
    if os.path.exists('%s/_generate.sh' % name):    # was a list comp
        examples.append(name)
"""

examples = []
for (dir, subs, files) in os.walk('.'):             # walk all subfolders [2.2]
    if ('_generate.sh' in files and                 # all folders with gen script
        os.path.split(dir)[1] != '_viewable'):      # but not viewable copies [3.0]
        examples.append(dir.lstrip('.' + os.sep))
    
for folder in sorted(examples):
    announce(folder)
    generate(folder)

print('Bye')
