#!/bin/bash

# --DEFUNCT: Superseded by its Python equivalent, generate-examples.py--

echo 'No longer used or maintained: run generate-examples.py instead.'
exit


#=========================================================================
# Generate all thumbspage examples/ galleries in a single step [2.1].
# Part of the thumbspage program (learning-python.com/thumbspage.html).
#
# This gallery build system uses Bash 'here documents' to provide console
# replies immediately following a command line (canned files and stdin 
# redirection or pipes would work too, but files are extra artifacts to 
# manage).  The effect automates galleries' _HOW-MADE.txt instructions.
#
# Run me anywhere: automatically cds to target folders along the way.
# Uses sed to auto-edit the user-configs file for some folders, but 
# saves and restores the original file and doesn't change its modtime.
# Pauses before each folder, to allow a control-c abandon if desired.
#
# UPDATE: to allow individual galleries to be built on demand, gallery
# build code has now been moved to _generate.sh files in each example's 
# folder.  This script now simply runs each of those files automatically. 
# For example, file ./1.7-upgrades/_generate.sh looks like this:
#
# python3 ../thumbspage.py . <<-EOF
#
#	3
#
#
#	EOF
#
# This file can be run by itself in its own folder, but it's also 
# run here by commands like this (with notable Bash obfuscation):
#
# cd 1.7-upgrades
# bash _generate.sh
# cd ..
#
# This is done for each folder with a _generate.py, some of which are
# substantially more complex (e.g., see dynamiclayout/_generate.py).
# This avoids switches or inputs here, as well as redundant code copies.
#
# See also "The Bash Rant" in ./_PUBLISH.sh for more on Bash syntax here;
# in its final form, this script might have been better coded in Python.
#
# UPDATE: and now it is - see script generate-examples.py in this 
# folder for a Python equivalent to this Bash script, which is now 
# used by the main bundle script.  In the end, Python feels much more 
# like a 'real' programming language even for admin scripts, but YMMV.
#=========================================================================


cd ~/MY-STUFF/Code/thumbspage/examples

Pause=Y   # stop for enter or ctrl-c between examples (Y or not)?

function announce() { 
    echo
    echo $1
    if [ $Pause == 'Y' ]; then 
        read -p 'Press enter/return to continue'
    fi
}

function generate() {
    cd $1
    bash _generate.sh
    cd ..
}

declare -a examples  # array
for name in $(ls)
do 
    if [ -e $name/_generate.sh ]; then examples+=($name); fi 
done

for folder in ${examples[@]}
do
    announce $folder
    generate $folder
done

echo 'bye'