/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson.server;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.activation.UnsupportedDataTypeException;
import zuo.biao.apijson.JSON;
import zuo.biao.apijson.JSONObject;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.RequestMethod;
import zuo.biao.apijson.RequestRole;
import zuo.biao.apijson.StringUtil;
import zuo.biao.apijson.server.Join;
import zuo.biao.apijson.server.NotNull;
import zuo.biao.apijson.server.ObjectParser;
import zuo.biao.apijson.server.Pair;
import zuo.biao.apijson.server.Parser;
import zuo.biao.apijson.server.SQLConfig;
import zuo.biao.apijson.server.SQLExecutor;
import zuo.biao.apijson.server.Verifier;
import zuo.biao.apijson.server.Visitor;
import zuo.biao.apijson.server.exception.ConditionErrorException;
import zuo.biao.apijson.server.exception.ConflictException;
import zuo.biao.apijson.server.exception.NotExistException;
import zuo.biao.apijson.server.exception.NotLoggedInException;
import zuo.biao.apijson.server.exception.OutOfRangeException;

public abstract class AbstractParser
implements Parser {
    protected static final String TAG = "AbstractParser";
    @NotNull
    protected Visitor visitor;
    protected RequestMethod requestMethod;
    protected com.alibaba.fastjson.JSONObject requestObject;
    protected Verifier verifier;
    protected RequestRole globleRole;
    protected String globleDatabase;
    protected boolean noVerifyLogin;
    protected boolean noVerifyRole;
    protected boolean noVerifyContent;
    protected SQLExecutor sqlExecutor;
    protected Map<String, Object> queryResultMap;
    private static final List<String> JOIN_COPY_KEY_LIST = new ArrayList<String>();

    public AbstractParser() {
        this(null);
    }

    public AbstractParser(RequestMethod method) {
        this(method, false);
    }

    public AbstractParser(RequestMethod method, boolean noVerify) {
        this.setMethod(method);
        this.setNoVerify(noVerify);
    }

    @Override
    @NotNull
    public Visitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new Visitor(){

                @Override
                public Long getId() {
                    return 0L;
                }

                @Override
                public List<Long> getContactIdList() {
                    return null;
                }
            };
        }
        return this.visitor;
    }

    @Override
    public AbstractParser setVisitor(@NotNull Visitor visitor) {
        this.visitor = visitor;
        return this;
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        return this.requestMethod;
    }

    @Override
    @NotNull
    public AbstractParser setMethod(RequestMethod method) {
        this.requestMethod = method == null ? RequestMethod.GET : method;
        return this;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getRequest() {
        return this.requestObject;
    }

    @Override
    public AbstractParser setRequest(com.alibaba.fastjson.JSONObject request) {
        this.requestObject = request;
        return this;
    }

    public AbstractParser setGlobleRole(RequestRole globleRole) {
        this.globleRole = globleRole;
        return this;
    }

    public AbstractParser setGlobleDatabase(String globleDatabase) {
        this.globleDatabase = globleDatabase;
        return this;
    }

    @Override
    public boolean isNoVerify() {
        return this.noVerifyLogin && this.noVerifyRole && this.noVerifyContent;
    }

    @Override
    public AbstractParser setNoVerify(boolean noVerify) {
        this.setNoVerifyLogin(noVerify);
        this.setNoVerifyRole(noVerify);
        this.setNoVerifyContent(noVerify);
        return this;
    }

    @Override
    public boolean isNoVerifyLogin() {
        return this.noVerifyLogin;
    }

    @Override
    public AbstractParser setNoVerifyLogin(boolean noVerifyLogin) {
        this.noVerifyLogin = noVerifyLogin;
        return this;
    }

    @Override
    public boolean isNoVerifyRole() {
        return this.noVerifyRole;
    }

    @Override
    public AbstractParser setNoVerifyRole(boolean noVerifyRole) {
        this.noVerifyRole = noVerifyRole;
        return this;
    }

    @Override
    public boolean isNoVerifyContent() {
        return this.noVerifyContent;
    }

    @Override
    public AbstractParser setNoVerifyContent(boolean noVerifyContent) {
        this.noVerifyContent = noVerifyContent;
        return this;
    }

    @Override
    public String parse(String request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public String parse(com.alibaba.fastjson.JSONObject request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(String request) {
        Log.d(TAG, "\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" + (Object)((Object)this.requestMethod) + "/parseResponse  request = \n" + request + "\n\n");
        try {
            this.requestObject = AbstractParser.parseRequest(request);
        }
        catch (Exception e) {
            return AbstractParser.newErrorResult(e);
        }
        return this.parseResponse(this.requestObject);
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(com.alibaba.fastjson.JSONObject request) {
        long startTime = System.currentTimeMillis();
        Log.d(TAG, "parseResponse  startTime = " + startTime + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\n\n ");
        this.requestObject = request;
        this.verifier = this.createVerifier().setVisitor(this.getVisitor());
        if (!RequestMethod.isPublicMethod(this.requestMethod)) {
            try {
                if (!this.noVerifyLogin) {
                    this.onVerifyLogin();
                }
                if (!this.noVerifyContent) {
                    this.onVerifyContent();
                }
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e);
            }
        }
        if (!this.noVerifyRole && this.globleRole == null) {
            try {
                this.setGlobleRole(RequestRole.get(this.requestObject.getString("@role")));
                this.requestObject.remove((Object)"@role");
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e);
            }
        }
        try {
            this.setGlobleDatabase(this.requestObject.getString("@database"));
            this.requestObject.remove((Object)"@database");
        }
        catch (Exception e) {
            return AbstractParser.extendErrorResult(this.requestObject, e);
        }
        String requestString = JSON.toJSONString(request);
        this.queryResultMap = new HashMap<String, Object>();
        Exception error = null;
        this.sqlExecutor = this.createSQLExecutor();
        try {
            this.requestObject = this.onObjectParse(request, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = e;
        }
        this.sqlExecutor.close();
        this.sqlExecutor = null;
        this.requestObject = this.verifier.removeAccessInfo(this.requestObject);
        this.requestObject = error == null ? AbstractParser.extendSuccessResult(this.requestObject) : AbstractParser.extendErrorResult(this.requestObject, error);
        this.queryResultMap.clear();
        Log.d(TAG, "\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n " + (Object)((Object)this.requestMethod) + "/parseResponse  request = \n" + requestString + "\n\n");
        Log.d(TAG, "parse  return response = \n" + JSON.toJSONString(this.requestObject) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n\n");
        long endTime = System.currentTimeMillis();
        Log.d(TAG, "parseResponse  endTime = " + endTime + ";  duration = " + (endTime - startTime) + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n\n");
        return this.requestObject;
    }

    protected void onVerifyLogin() throws Exception {
        this.verifier.verifyLogin();
    }

    protected void onVerifyContent() throws Exception {
        this.requestObject = this.parseCorrectRequest();
    }

    @NotNull
    public static com.alibaba.fastjson.JSONObject parseRequest(String request) throws Exception {
        com.alibaba.fastjson.JSONObject obj = JSON.parseObject(request);
        if (obj == null) {
            throw new UnsupportedEncodingException("JSON\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        return obj;
    }

    public static com.alibaba.fastjson.JSONObject newResult(int code, String msg) {
        return AbstractParser.extendResult(null, code, msg);
    }

    public static com.alibaba.fastjson.JSONObject extendResult(com.alibaba.fastjson.JSONObject object, int code, String msg) {
        String m;
        if (object == null) {
            object = new com.alibaba.fastjson.JSONObject(true);
        }
        if (!object.containsKey((Object)"code")) {
            object.put("code", (Object)code);
        }
        if (!(m = StringUtil.getString(object.getString("msg"))).isEmpty()) {
            msg = m + " ;\n " + StringUtil.getString(msg);
        }
        object.put("msg", (Object)msg);
        return object;
    }

    public static com.alibaba.fastjson.JSONObject extendSuccessResult(com.alibaba.fastjson.JSONObject object) {
        return AbstractParser.extendResult(object, 200, "success");
    }

    public static com.alibaba.fastjson.JSONObject newSuccessResult() {
        return AbstractParser.newResult(200, "success");
    }

    public static com.alibaba.fastjson.JSONObject extendErrorResult(com.alibaba.fastjson.JSONObject object, Exception e) {
        com.alibaba.fastjson.JSONObject error = AbstractParser.newErrorResult(e);
        return AbstractParser.extendResult(object, error.getIntValue("code"), error.getString("msg"));
    }

    public static com.alibaba.fastjson.JSONObject newErrorResult(Exception e) {
        if (e != null) {
            e.printStackTrace();
            int code = e instanceof UnsupportedEncodingException ? 400 : (e instanceof IllegalAccessException ? 401 : (e instanceof UnsupportedOperationException ? 403 : (e instanceof NotExistException ? 404 : (e instanceof IllegalArgumentException ? 406 : (e instanceof NotLoggedInException ? 407 : (e instanceof TimeoutException ? 408 : (e instanceof ConflictException ? 409 : (e instanceof ConditionErrorException ? 412 : (e instanceof UnsupportedDataTypeException ? 415 : (e instanceof OutOfRangeException ? 416 : (e instanceof NullPointerException ? 417 : 500)))))))))));
            return AbstractParser.newResult(code, e.getMessage());
        }
        return AbstractParser.newResult(500, "Internal Server Error!");
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectRequest() throws Exception {
        if (RequestMethod.isPublicMethod(this.requestMethod)) {
            return this.requestObject;
        }
        String tag = this.requestObject.getString("tag");
        if (!StringUtil.isNotEmpty(tag, true)) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6etag\uff01\u4e00\u822c\u662fTable\u540d");
        }
        int version = this.requestObject.getIntValue("version");
        com.alibaba.fastjson.JSONObject object = null;
        String error = "";
        try {
            object = this.getStructure("Request", "tag", tag, version);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (object == null) {
            throw new UnsupportedOperationException("\u975e\u5f00\u653e\u8bf7\u6c42\u5fc5\u987b\u662fRequest\u8868\u4e2d\u6821\u9a8c\u89c4\u5219\u5141\u8bb8\u7684\u64cd\u4f5c\uff01\n " + error);
        }
        com.alibaba.fastjson.JSONObject target = null;
        if (JSONObject.isTableKey(tag) && !object.containsKey((Object)tag)) {
            target = new com.alibaba.fastjson.JSONObject(true);
            target.put(tag, (Object)object);
        } else {
            target = object;
        }
        this.requestObject.remove((Object)"tag");
        this.requestObject.remove((Object)"version");
        return this.parseCorrectRequest((com.alibaba.fastjson.JSONObject)target.clone());
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectResponse(String table, com.alibaba.fastjson.JSONObject response) throws Exception {
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.alibaba.fastjson.JSONObject getStructure(@NotNull String table, String key, String value, int version) throws Exception {
        SQLConfig config = this.createSQLConfig().setMethod(RequestMethod.GET).setTable(table);
        config.setPrepared(false);
        config.setColumn("structure");
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("method", this.requestMethod.name());
        if (key != null) {
            where.put(key, value);
        }
        if (version > 0) {
            where.put("version{}", ">=" + version);
        }
        config.setWhere(where);
        config.setOrder("version" + (version > 0 ? "+" : "-"));
        config.setCount(1);
        try (SQLExecutor executor = this.createSQLExecutor();){
            com.alibaba.fastjson.JSONObject result = executor.execute(config.setCacheStatic(true));
            com.alibaba.fastjson.JSONObject jSONObject = AbstractParser.getJSONObject(result, "structure");
            return jSONObject;
        }
    }

    @Override
    public com.alibaba.fastjson.JSONObject onObjectParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name, SQLConfig arrayConfig) throws Exception {
        Log.i(TAG, "\ngetObject:  parentPath = " + parentPath + ";\n name = " + name + "; request = " + JSON.toJSONString(request));
        if (request == null) {
            return null;
        }
        int type = arrayConfig == null ? 0 : arrayConfig.getType();
        ObjectParser op = this.createObjectParser(request, parentPath, name, arrayConfig).parse();
        Object response = null;
        if (op != null) {
            if (arrayConfig == null) {
                response = op.executeSQL().response();
            } else {
                int query = arrayConfig.getQuery();
                if (type == 2 && query != 0 && arrayConfig.getPosition() == 0) {
                    int index;
                    com.alibaba.fastjson.JSONObject rp = op.setMethod(RequestMethod.HEAD).executeSQL().getSqlReponse();
                    if (rp != null && (index = parentPath.lastIndexOf("]/")) >= 0) {
                        int total = rp.getIntValue("count");
                        this.putQueryResult(parentPath.substring(0, index) + "]/" + "total", total);
                        if (total <= arrayConfig.getCount() * arrayConfig.getPage()) {
                            query = 1;
                        }
                    }
                    op.setMethod(this.requestMethod);
                }
                response = query == 1 ? null : op.executeSQL(arrayConfig.getCount(), arrayConfig.getPage(), arrayConfig.getPosition()).response();
            }
            op.recycle();
            op = null;
        }
        return response;
    }

    @Override
    public JSONArray onArrayParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name) throws Exception {
        Object fo;
        com.alibaba.fastjson.JSONObject parent;
        Log.i(TAG, "\n\n\n getArray parentPath = " + parentPath + "; name = " + name + "; request = " + JSON.toJSONString(request));
        if (!RequestMethod.isGetMethod(this.requestMethod, false)) {
            throw new UnsupportedOperationException("key[]:{}\u53ea\u652f\u6301GET\u65b9\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20 " + name + ":{} \uff01");
        }
        if (request == null || request.isEmpty()) {
            return null;
        }
        String path = AbstractParser.getAbsPath(parentPath, name);
        int query = request.getIntValue("query");
        int count = request.getIntValue("count");
        int page = request.getIntValue("page");
        String join = request.getString("join");
        request.remove((Object)"query");
        request.remove((Object)"count");
        request.remove((Object)"page");
        request.remove((Object)"join");
        Log.d(TAG, "getArray  query = " + query + "; count = " + count + "; page = " + page + "; join = " + join);
        if (request.isEmpty()) {
            Log.e(TAG, "getArray  request.isEmpty() >> return null;");
            return null;
        }
        int size = count <= 0 || count > 100 ? 100 : count;
        Log.d(TAG, "getArray  size = " + size + "; page = " + page);
        int index = name == null ? -1 : name.lastIndexOf("[]");
        String childPath = index <= 0 ? null : Pair.parseEntry(name.substring(0, index), true).getKey();
        String[] childKeys = StringUtil.split(childPath, "-", false);
        if (childKeys == null || childKeys.length <= 0 || !request.containsKey((Object)childKeys[0])) {
            childKeys = null;
        }
        JSONArray response = new JSONArray();
        SQLConfig config = this.createSQLConfig().setMethod(this.requestMethod).setCount(size).setPage(page).setQuery(query).setJoinList(this.onJoinParse(join, request));
        for (int i = 0; i < size && (parent = this.onObjectParse(request, path, "" + i, config.setType(1).setPosition(i))) != null && !parent.isEmpty(); ++i) {
            response.add(AbstractParser.getValue(parent, childKeys));
        }
        Object object = fo = childKeys == null || response.isEmpty() ? null : response.get(0);
        if (fo instanceof Boolean || fo instanceof Number || fo instanceof String) {
            this.putQueryResult(path, response);
        }
        request.put("query", (Object)query);
        request.put("count", (Object)count);
        request.put("page", (Object)page);
        request.put("join", (Object)join);
        Log.i(TAG, "getArray  return response = \n" + JSON.toJSONString(response) + "\n>>>>>>>>>>>>>>>\n\n\n");
        return response;
    }

    private List<Join> onJoinParse(String join, com.alibaba.fastjson.JSONObject request) throws Exception {
        String[] sArr;
        String[] stringArray = sArr = request == null || request.isEmpty() ? null : StringUtil.split(join);
        if (sArr == null || sArr.length <= 0) {
            Log.e(TAG, "doJoin  sArr == null || sArr.length <= 0 >> return request;");
            return null;
        }
        ArrayList<Join> joinList = new ArrayList<Join>();
        for (int i = 0; i < sArr.length; ++i) {
            String targetKey;
            String targetPath;
            String key;
            String path = "" + sArr[i];
            int index = path.indexOf("/");
            if (index < 0) {
                throw new IllegalArgumentException("join:value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1/key1,... \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            String joinType = path.substring(0, index);
            String table = (index = (path = path.substring(index + 1)).indexOf("/")) < 0 ? null : path.substring(0, index);
            String string = key = StringUtil.isEmpty(table, true) ? null : path.substring(index + 1);
            if (StringUtil.isEmpty(key, true)) {
                throw new IllegalArgumentException("join:value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1/key1,... \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            com.alibaba.fastjson.JSONObject tableObj = request.getJSONObject(table);
            String string2 = targetPath = tableObj == null ? null : tableObj.getString(key);
            if (StringUtil.isEmpty(targetPath, true)) {
                throw new IllegalArgumentException(table + "." + key + ":value \u4e2dvalue\u5fc5\u987b\u4e3a\u5f15\u7528\u8d4b\u503c\u7684\u8def\u5f84 '/targetTable/targetKey' \uff01");
            }
            index = targetPath.lastIndexOf("/");
            String string3 = targetKey = index < 0 ? null : targetPath.substring(index + 1);
            if (StringUtil.isEmpty(targetKey, true)) {
                throw new IllegalArgumentException(table + "." + key + ":'/targetTable/targetKey' \u4e2dtargetKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String targetTable = (index = (targetPath = targetPath.substring(0, index)).lastIndexOf("/")) < 0 ? targetPath : targetPath.substring(index + 1);
            com.alibaba.fastjson.JSONObject targetObj = request.getJSONObject(targetTable);
            if (targetObj == null) {
                throw new IllegalArgumentException(targetTable + "." + targetKey + ":'/targetTable/targetKey' \u4e2d\u8def\u5f84\u5bf9\u5e94\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
            }
            tableObj.put(key, tableObj.remove((Object)key));
            Join j = new Join();
            j.setJoinType(joinType);
            j.setName(table);
            j.setTargetName(targetTable);
            j.setTargetKey(targetKey);
            j.setKeyAndType(key);
            j.setTable(this.getJoinObject(table, tableObj, key));
            joinList.add(j);
        }
        return joinList;
    }

    private com.alibaba.fastjson.JSONObject getJoinObject(String table, com.alibaba.fastjson.JSONObject obj, String key) {
        if (obj == null || obj.isEmpty()) {
            Log.e(TAG, "getIdList  obj == null || obj.isEmpty() >> return null;");
            return null;
        }
        if (StringUtil.isEmpty(key, true)) {
            Log.e(TAG, "getIdList  StringUtil.isEmpty(key, true) >> return null;");
            return null;
        }
        if (StringUtil.isEmpty(obj.getString("@column"), true)) {
            throw new IllegalArgumentException("join\u7684\u526f\u8868 " + table + " \u5fc5\u987b\u6709\u975e\u7a7a\u7684 " + "@column" + " ! \u5426\u5219JOIN\u7684\u6027\u80fd\u4f18\u5316\u65e0\u6548\uff0c\u53cd\u800c\u591a\u8017\u6027\u80fd\uff01");
        }
        com.alibaba.fastjson.JSONObject requestObj = new com.alibaba.fastjson.JSONObject(true);
        LinkedHashSet set = new LinkedHashSet(obj.keySet());
        for (String k : set) {
            if (StringUtil.isEmpty(k, true)) continue;
            if (k.startsWith("@")) {
                if (!JOIN_COPY_KEY_LIST.contains(k)) continue;
                requestObj.put(k, obj.get((Object)k));
                continue;
            }
            if (k.endsWith("@")) {
                if (k.equals(key)) continue;
                throw new UnsupportedOperationException(table + "." + k + " \u4e0d\u5408\u6cd5\uff01" + "join" + " \u5173\u8054\u7684Table\u4e2d\u53ea\u80fd\u67091\u4e2a key@:value \uff01");
            }
            if (k.contains("()")) continue;
            requestObj.put(k, obj.get((Object)k));
        }
        return requestObj;
    }

    protected static Object getValue(com.alibaba.fastjson.JSONObject parent, String[] pathKeys) {
        if (parent == null || pathKeys == null || pathKeys.length <= 0) {
            Log.w(TAG, "getChild  parent == null || pathKeys == null || pathKeys.length <= 0 >> return parent;");
            return parent;
        }
        int last = pathKeys.length - 1;
        for (int i = 0; i < last && parent != null; ++i) {
            parent = AbstractParser.getJSONObject(parent, pathKeys[i]);
        }
        return parent == null ? null : parent.get((Object)pathKeys[last]);
    }

    public static String getValuePath(String parentPath, String valuePath) {
        valuePath = valuePath.startsWith("/") ? AbstractParser.getAbsPath(parentPath, valuePath) : AbstractParser.replaceArrayChildPath(parentPath, valuePath);
        return valuePath;
    }

    public static String getAbsPath(String path, String name) {
        Log.i(TAG, "getPath  path = " + path + "; name = " + name + " <<<<<<<<<<<<<");
        path = StringUtil.getString(path);
        name = StringUtil.getString(name);
        if (StringUtil.isNotEmpty(path, false)) {
            if (StringUtil.isNotEmpty(name, false)) {
                path = path + (name.startsWith("/") ? "" : "/") + name;
            }
        } else {
            path = name;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Log.i(TAG, "getPath  return " + path + " >>>>>>>>>>>>>>>>");
        return path;
    }

    public static String replaceArrayChildPath(String parentPath, String valuePath) {
        Object[] vs;
        String[] ps = StringUtil.split(parentPath, "]/");
        if (ps != null && ps.length > 1 && (vs = StringUtil.split(valuePath, "]/")) != null && vs.length > 0) {
            for (int i = 0; i < ps.length - 1 && ps[i] != null && ps[i].equals(vs[i]); ++i) {
                String pos;
                String string = pos = !ps[i + 1].contains("/") ? ps[i + 1] : ps[i + 1].substring(0, ps[i + 1].indexOf("/"));
                if (((String)vs[i + 1]).startsWith(pos + "/")) continue;
                vs[i + 1] = pos + "/" + (String)vs[i + 1];
            }
            return StringUtil.getString(vs, "]/");
        }
        return valuePath;
    }

    @Override
    public synchronized void putQueryResult(String path, Object result) {
        Log.i(TAG, "\n putQueryResult  valuePath = " + path + "; result = " + result + "\n <<<<<<<<<<<<<<<<<<<<<<<");
        Log.d(TAG, "putQueryResult  queryResultMap.containsKey(valuePath) >> queryResultMap.put(path, result);");
        this.queryResultMap.put(path, result);
    }

    @Override
    public Object getValueByPath(String valuePath) {
        Log.i(TAG, "<<<<<<<<<<<<<<< \n getValueByPath  valuePath = " + valuePath + "\n <<<<<<<<<<<<<<<<<<");
        if (StringUtil.isEmpty(valuePath, true)) {
            Log.e(TAG, "getValueByPath  StringUtil.isNotEmpty(valuePath, true) == false >> return null;");
            return null;
        }
        Object target = this.queryResultMap.get(valuePath);
        if (target != null) {
            return target;
        }
        Set<String> set = this.queryResultMap.keySet();
        com.alibaba.fastjson.JSONObject parent = null;
        String[] keys = null;
        for (String path : set) {
            if (!valuePath.startsWith(path + "/")) continue;
            try {
                parent = (com.alibaba.fastjson.JSONObject)this.queryResultMap.get(path);
            }
            catch (Exception e) {
                Log.e(TAG, "getValueByPath  try { parent = (JSONObject) queryResultMap.get(path); } catch { \n parent not instanceof JSONObject!");
                parent = null;
            }
            if (parent == null) break;
            keys = StringUtil.splitPath(valuePath.substring(path.length()));
            break;
        }
        if (keys != null && keys.length > 1) {
            for (int i = 0; i < keys.length - 1 && parent != null; ++i) {
                parent = AbstractParser.getJSONObject(parent, (String)keys[i]);
            }
        }
        if (parent != null) {
            Log.i(TAG, "getValueByPath >> get from queryResultMap >> return  parent.get(keys[keys.length - 1]);");
            target = parent.get((Object)keys[keys.length - 1]);
            if (target != null) {
                Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
                return target;
            }
        }
        if ((target = AbstractParser.getValue(this.requestObject, StringUtil.splitPath(valuePath))) != null) {
            Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
            return target;
        }
        Log.i(TAG, "getValueByPath  return valuePath;");
        return valuePath;
    }

    public static com.alibaba.fastjson.JSONObject getJSONObject(com.alibaba.fastjson.JSONObject object, String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            Log.i(TAG, "getJSONObject  try { return object.getJSONObject(key); } catch (Exception e) { \n" + e.getMessage());
            return null;
        }
    }

    @Override
    public synchronized com.alibaba.fastjson.JSONObject executeSQL(SQLConfig config) throws Exception {
        Log.i(TAG, "executeSQL  config = " + JSON.toJSONString(config));
        if (!this.noVerifyRole) {
            if (config.getRole() == null) {
                if (this.globleRole != null) {
                    config.setRole(this.globleRole);
                } else {
                    config.setRole(this.getVisitor().getId() <= 0L ? RequestRole.UNKNOWN : RequestRole.LOGIN);
                }
            }
            this.verifier.verify(config);
        }
        if (config.getDatabase() == null && this.globleDatabase != null) {
            config.setDatabase(this.globleDatabase);
        }
        return this.parseCorrectResponse(config.getTable(), this.sqlExecutor.execute(config));
    }

    static {
        JOIN_COPY_KEY_LIST.add("@schema");
        JOIN_COPY_KEY_LIST.add("@column");
        JOIN_COPY_KEY_LIST.add("@order");
        JOIN_COPY_KEY_LIST.add("@combine");
        JOIN_COPY_KEY_LIST.add("@having");
        JOIN_COPY_KEY_LIST.add("@group");
    }
}

