/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContentResolverCompatJellybean;
import android.support.v4.os.CancellationSignal;

public class ContentResolverCompat {
    private static final ContentResolverCompatImpl IMPL;

    private ContentResolverCompat() {
    }

    public static Cursor query(ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return IMPL.query(resolver, uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 16 ? new ContentResolverCompatImplJB() : new ContentResolverCompatImplBase();
    }

    static class ContentResolverCompatImplJB
    extends ContentResolverCompatImplBase {
        ContentResolverCompatImplJB() {
        }

        @Override
        public Cursor query(ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
            return ContentResolverCompatJellybean.query(resolver, uri, projection, selection, selectionArgs, sortOrder, cancellationSignal != null ? cancellationSignal.getCancellationSignalObject() : null);
        }
    }

    static class ContentResolverCompatImplBase
    implements ContentResolverCompatImpl {
        ContentResolverCompatImplBase() {
        }

        @Override
        public Cursor query(ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
            }
            return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
        }
    }

    static interface ContentResolverCompatImpl {
        public Cursor query(ContentResolver var1, Uri var2, String[] var3, String var4, String[] var5, String var6, CancellationSignal var7);
    }
}

