/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String warning) {
        System.out.println(warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public URI toUriLenient(URL url) throws URISyntaxException {
        return url.toURI();
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    private static Platform findPlatform() {
        try {
            Class<?> openSslSocketClass;
            try {
                openSslSocketClass = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException ignored) {
                openSslSocketClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            Method setUseSessionTickets = openSslSocketClass.getMethod("setUseSessionTickets", Boolean.TYPE);
            Method setHostname = openSslSocketClass.getMethod("setHostname", String.class);
            Method trafficStatsTagSocket = null;
            Method trafficStatsUntagSocket = null;
            try {
                Class<?> trafficStats = Class.forName("android.net.TrafficStats");
                trafficStatsTagSocket = trafficStats.getMethod("tagSocket", Socket.class);
                trafficStatsUntagSocket = trafficStats.getMethod("untagSocket", Socket.class);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            Method setNpnProtocols = null;
            Method getNpnSelectedProtocol = null;
            try {
                setNpnProtocols = openSslSocketClass.getMethod("setNpnProtocols", byte[].class);
                getNpnSelectedProtocol = openSslSocketClass.getMethod("getNpnSelectedProtocol", new Class[0]);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            return new Android(openSslSocketClass, setUseSessionTickets, setHostname, trafficStatsTagSocket, trafficStatsUntagSocket, setNpnProtocols, getNpnSelectedProtocol);
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        try {
            Class<?> negoClass;
            String negoClassName = "org.eclipse.jetty.alpn.ALPN";
            try {
                negoClass = Class.forName(negoClassName);
            }
            catch (ClassNotFoundException ignored) {
                negoClassName = "org.eclipse.jetty.npn.NextProtoNego";
                negoClass = Class.forName(negoClassName);
            }
            Class<?> providerClass = Class.forName(negoClassName + "$Provider");
            Class<?> clientProviderClass = Class.forName(negoClassName + "$ClientProvider");
            Class<?> serverProviderClass = Class.forName(negoClassName + "$ServerProvider");
            Method putMethod = negoClass.getMethod("put", SSLSocket.class, providerClass);
            Method getMethod = negoClass.getMethod("get", SSLSocket.class);
            return new JdkWithJettyBootPlatform(putMethod, getMethod, clientProviderClass, serverProviderClass);
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result.writeByte(protocol.toString().length());
            result.writeUtf8(protocol.toString());
        }
        return result.readByteArray();
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNegoProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (methodName.equals("supports") && Boolean.TYPE == returnType) {
                return true;
            }
            if (methodName.equals("unsupported") && Void.TYPE == returnType) {
                this.unsupported = true;
                return null;
            }
            if (methodName.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if ((methodName.equals("selectProtocol") || methodName.equals("select")) && String.class == returnType && args.length == 1 && args[0] instanceof List) {
                List peerProtocols = (List)args[0];
                int size = peerProtocols.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.protocols.contains(peerProtocols.get(i))) continue;
                    this.selected = (String)peerProtocols.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((methodName.equals("protocolSelected") || methodName.equals("selected")) && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }

    private static class JdkWithJettyBootPlatform
    extends Platform {
        private final Method getMethod;
        private final Method putMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Method putMethod, Method getMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
            this.putMethod = putMethod;
            this.getMethod = getMethod;
            this.clientProviderClass = clientProviderClass;
            this.serverProviderClass = serverProviderClass;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            ArrayList<String> names = new ArrayList<String>(protocols.size());
            int size = protocols.size();
            for (int i = 0; i < size; ++i) {
                Protocol protocol = protocols.get(i);
                if (protocol == Protocol.HTTP_1_0) continue;
                names.add(protocol.toString());
            }
            try {
                Object provider = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(names));
                this.putMethod.invoke(null, sslSocket, provider);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            try {
                JettyNegoProvider provider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
                if (!provider.unsupported && provider.selected == null) {
                    Internal.logger.log(Level.INFO, "NPN/ALPN callback dropped: SPDY and HTTP/2 are disabled. Is npn-boot or alpn-boot on the boot class path?");
                    return null;
                }
                return provider.unsupported ? null : provider.selected;
            }
            catch (InvocationTargetException e) {
                throw new AssertionError();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }

    private static class Android
    extends Platform {
        protected final Class<?> openSslSocketClass;
        private final Method setUseSessionTickets;
        private final Method setHostname;
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;
        private final Method setNpnProtocols;
        private final Method getNpnSelectedProtocol;

        private Android(Class<?> openSslSocketClass, Method setUseSessionTickets, Method setHostname, Method trafficStatsTagSocket, Method trafficStatsUntagSocket, Method setNpnProtocols, Method getNpnSelectedProtocol) {
            this.openSslSocketClass = openSslSocketClass;
            this.setUseSessionTickets = setUseSessionTickets;
            this.setHostname = setHostname;
            this.trafficStatsTagSocket = trafficStatsTagSocket;
            this.trafficStatsUntagSocket = trafficStatsUntagSocket;
            this.setNpnProtocols = setNpnProtocols;
            this.getNpnSelectedProtocol = getNpnSelectedProtocol;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
            try {
                socket.connect(address, connectTimeout);
            }
            catch (SecurityException se) {
                IOException ioException = new IOException("Exception in connect");
                ioException.initCause(se);
                throw ioException;
            }
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            if (!this.openSslSocketClass.isInstance(sslSocket)) {
                return;
            }
            if (hostname != null) {
                try {
                    this.setUseSessionTickets.invoke((Object)sslSocket, true);
                    this.setHostname.invoke((Object)sslSocket, hostname);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (this.setNpnProtocols != null) {
                try {
                    Object[] parameters = new Object[]{Android.concatLengthPrefixed(protocols)};
                    this.setNpnProtocols.invoke((Object)sslSocket, parameters);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (this.getNpnSelectedProtocol == null) {
                return null;
            }
            if (!this.openSslSocketClass.isInstance(socket)) {
                return null;
            }
            try {
                byte[] npnResult = (byte[])this.getNpnSelectedProtocol.invoke((Object)socket, new Object[0]);
                if (npnResult == null) {
                    return null;
                }
                return new String(npnResult, Util.UTF_8);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

