-- MySQL dump 10.13  Distrib 5.7.17, for macos10.12 (x86_64)
--
-- Host: localhost    Database: sys
-- ------------------------------------------------------
-- Server version	5.7.17

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Document`
--

DROP TABLE IF EXISTS `Document`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Document` (
  `id` bigint(15) NOT NULL COMMENT '唯一标识',
  `userId` bigint(15) NOT NULL COMMENT '用户id\n应该用adminId，只有当登录账户是管理员时才能操作文档。\n需要先建Admin表，新增登录等相关接口。',
  `version` tinyint(4) NOT NULL DEFAULT '2' COMMENT '接口版本号\n<=0 - 不限制版本，任意版本都可用这个接口\n>0 - 在这个版本添加的接口',
  `name` varchar(100) NOT NULL COMMENT '接口名称',
  `url` varchar(250) NOT NULL COMMENT '请求地址',
  `request` text NOT NULL COMMENT '请求\n用json格式会导致强制排序，而请求中引用赋值只能引用上面的字段，必须有序。',
  `response` text COMMENT '标准返回结果JSON\n用json格式会导致强制排序，而请求中引用赋值只能引用上面的字段，必须有序。',
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='测试用例文档\n后端开发者在测试好后，把选好的测试用例上传，这样就能共享给前端/客户端开发者';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Document`
--

LOCK TABLES `Document` WRITE;
/*!40000 ALTER TABLE `Document` DISABLE KEYS */;
INSERT INTO `Document` VALUES (1,0,1,'登录','/login','{\"type\": 0, \"phone\": \"13000082001\", \"version\": 1, \"password\": \"123456\"}',NULL,'2017-11-26 07:35:19'),(2,0,1,'注册(先获取验证码type:1)','/register','{\n    \"Privacy\": {\n        \"phone\": \"13000083333\",\n        \"_password\": \"123456\"\n    },\n    \"User\": {\n        \"name\": \"APIJSONUser\"\n    },\n    \"verify\": \"6840\"\n}','{\"code\":412,\"msg\":\"手机号或验证码错误！\"}','2017-11-26 06:56:10'),(3,0,1,'退出登录','/logout','{}',NULL,'2017-11-26 09:36:10'),(1511689914599,0,1,'获取用户隐私信息','/gets','{\"tag\": \"Privacy\", \"Privacy\": {\"id\": 82001}}','{\"Privacy\":{\"id\":82001,\"more\":true,\"certified\":1,\"phone\":13000082001,\"balance\":9835.11},\"code\":200,\"msg\":\"success\"}','2017-11-26 09:51:54'),(1511796155277,0,1,'获取验证码','/post/verify','{\"type\": 0, \"phone\": \"13000082001\"}','{\"Verify\":{\"id\":1533396718012,\"type\":0,\"phone\":13000082001,\"verify\":4995,\"date\":\"2018-08-04 23:31:58.0\"},\"tag\":\"Verify\",\"code\":200,\"msg\":\"success\"}','2017-11-27 15:22:35'),(1511796208670,0,1,'检查验证码是否存在','/heads/verify','{\"type\": 0, \"phone\": \"13000082001\"}','{\"Verify\":{\"code\":200,\"msg\":\"success\",\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-27 15:23:28'),(1511796589079,0,1,'修改登录密码(先获取验证码type:2)-手机号+验证码','/put/password','{\"verify\": \"10322\", \"Privacy\": {\"phone\": \"13000082001\", \"_password\": \"666666\"}}','{\"code\":412,\"msg\":\"手机号或验证码错误！\"}','2017-11-27 15:29:49'),(1511796882184,0,1,'充值(需要支付密码)/提现','/put/balance','{\"tag\": \"Privacy\", \"Privacy\": {\"id\": 82001, \"balance+\": 100.15, \"_payPassword\": \"123456\"}}','{\"Privacy\":{\"code\":200,\"msg\":\"success\",\"id\":82001,\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-27 15:34:42'),(1511963330795,0,2,'获取文档列表(即在线解析网页上的共享)-API调用方式','/get','{\n    \"Document[]\": {\n        \"Document\": {\n            \"@role\": \"login\",\n            \"@order\": \"version-,date-\"\n        }\n    }\n}',NULL,'2017-11-29 13:48:50'),(1511963677325,0,1,'获取用户','/get','{\"User\": {\"id\": 82001}}','{\"User\":{\"id\":82001,\"sex\":0,\"name\":\"测试改名\",\"tag\":\"APIJSON User\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\",\"contactIdList\":[82025,82024,82003,93793,70793],\"pictureList\":[\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2017-11-29 13:54:37'),(1511963722970,0,1,'获取用户列表(\"id{}\":contactIdList)-朋友页','/get','{\n    \"User[]\": {\n        \"count\": 10,\n        \"page\": 0,\n        \"User\": {\n            \"@column\": \"id,sex,name,tag,head\",\n            \"@order\": \"name+\",\n            \"id{}\": [\n                82002,\n                82004,\n                70793\n            ]\n        }\n    }\n}','{\"User[]\":[{\"id\":82002,\"sex\":1,\"name\":\"Happy~\",\"tag\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},{\"id\":82004,\"sex\":0,\"name\":\"Tommy\",\"tag\":\"fasef\",\"head\":\"http://static.oschina.net/uploads/user/1200/2400261_50.png?t=1439638750000\"}],\"code\":200,\"msg\":\"success\"}','2017-11-29 13:55:22'),(1511963990072,0,1,'获取动态Moment+User+praiseUserList','/get','{\n    \"Moment\": {\n        \"id\": 15\n    },\n    \"User\": {\n        \"id@\": \"Moment/userId\",\n        \"@column\": \"id,name,head\"\n    },\n    \"User[]\": {\n        \"count\": 10,\n        \"User\": {\n            \"id{}@\": \"Moment/praiseUserIdList\",\n            \"@column\": \"id,name\"\n        }\n    }\n}','{\"Moment\":{\"id\":15,\"userId\":70793,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON is a JSON Transmission Structure Protocol…\",\"praiseUserIdList\":[82055,82002,38710],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"User[]\":[{\"id\":38710,\"name\":\"TommyLemon\"},{\"id\":82002,\"name\":\"Happy~\"},{\"id\":82055,\"name\":\"Solid\"}],\"code\":200,\"msg\":\"success\"}','2017-11-29 13:59:50'),(1511964176689,0,1,'获取评论列表-动态详情页Comment+User','/get','{\n    \"[]\": {\n        \"count\": 20,\n        \"page\": 0,\n        \"Comment\": {\n            \"@order\": \"date+\",\n            \"momentId\": 15\n        },\n        \"User\": {\n            \"id@\": \"/Comment/userId\",\n            \"@column\": \"id,name,head\"\n        }\n    }\n}','{\"[]\":[{\"Comment\":{\"id\":176,\"toId\":166,\"userId\":38710,\"momentId\":15,\"date\":\"2017-03-25 20:28:03.0\",\"content\":\"thank you\"},\"User\":{\"id\":38710,\"name\":\"TommyLemon\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"}},{\"Comment\":{\"id\":1490863469638,\"toId\":0,\"userId\":82002,\"momentId\":15,\"date\":\"2017-03-30 16:44:29.0\",\"content\":\"Just do it\"},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"}},{\"Comment\":{\"id\":1490875660259,\"toId\":1490863469638,\"userId\":82055,\"momentId\":15,\"date\":\"2017-03-30 20:07:40.0\",\"content\":\"I prove wht you said(??????)\"},\"User\":{\"id\":82055,\"name\":\"Solid\",\"head\":\"http://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1508227456407,\"toId\":0,\"userId\":82001,\"momentId\":15,\"date\":\"2017-10-17 16:04:16.0\",\"content\":\"hsh\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1509346606036,\"toId\":0,\"userId\":82001,\"momentId\":15,\"date\":\"2017-10-30 14:56:46.0\",\"content\":\"测\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1525933255901,\"userId\":82001,\"momentId\":15,\"date\":\"2018-05-10 14:20:55.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1527949266037,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-02 22:21:06.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1528339777338,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-07 10:49:37.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1528366915282,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-07 18:21:55.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1528366931410,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-07 18:22:11.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1528392773597,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-08 01:32:53.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529034360708,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-15 11:46:00.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529078537044,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-16 00:02:17.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529401004622,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-19 17:36:44.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529401505690,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-19 17:45:05.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529468113356,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-20 12:15:13.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529724026842,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-23 11:20:26.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1529909214303,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-25 14:46:54.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1530276831779,\"userId\":82001,\"momentId\":15,\"date\":\"2018-06-29 20:53:51.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}},{\"Comment\":{\"id\":1531365764793,\"userId\":82001,\"momentId\":15,\"date\":\"2018-07-12 11:22:44.0\",\"content\":\"测试新增评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\"}}],\"code\":200,\"msg\":\"success\"}','2017-11-29 14:02:56'),(1511967853340,0,1,'获取动态列表Moment+User+User:parise[]+Comment[]','/get','{     \"[]\": {         \"count\": 5,         \"page\": 0,         \"Moment\": {             \"@order\": \"date+\"         },         \"User\": {             \"id@\": \"/Moment/userId\",             \"@column\": \"id,name,head\"         },         \"User[]\": {             \"count\": 10,             \"User\": {                 \"id{}@\": \"[]/Moment/praiseUserIdList\",                 \"@column\": \"id,name\"             }         },         \"[]\": {             \"count\": 6,             \"Comment\": {                 \"@order\": \"date+\",                 \"momentId@\": \"[]/Moment/id\"             },             \"User\": {                 \"id@\": \"/Comment/userId\",                 \"@column\": \"id,name\"             }         }     } }','{\"[]\":[{\"Moment\":{\"id\":301,\"userId\":93793,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-301\",\"praiseUserIdList\":[38710,93793,82003,82005,82040,82055,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":93793,\"name\":\"Mike\",\"head\":\"http://static.oschina.net/uploads/user/48/96331_50.jpg\"},\"User[]\":[{\"id\":38710,\"name\":\"TommyLemon\"},{\"id\":82001,\"name\":\"测试改名\"},{\"id\":82002,\"name\":\"Happy~\"},{\"id\":82003,\"name\":\"Wechat\"},{\"id\":82005,\"name\":\"Jan\"},{\"id\":82040,\"name\":\"Dream\"},{\"id\":82055,\"name\":\"Solid\"},{\"id\":93793,\"name\":\"Mike\"}],\"[]\":[{\"Comment\":{\"id\":45,\"toId\":0,\"userId\":93793,\"momentId\":301,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-45\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":51,\"toId\":45,\"userId\":82003,\"momentId\":301,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-51\"},\"User\":{\"id\":82003,\"name\":\"Wechat\"}},{\"Comment\":{\"id\":76,\"toId\":45,\"userId\":93793,\"momentId\":301,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-76\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":120,\"toId\":0,\"userId\":93793,\"momentId\":301,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-110\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":124,\"toId\":0,\"userId\":82001,\"momentId\":301,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-114\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":1490781009548,\"toId\":51,\"userId\":82001,\"momentId\":301,\"date\":\"2017-03-29 17:50:09.0\",\"content\":\"3\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}}]},{\"Moment\":{\"id\":58,\"userId\":90814,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-435\",\"praiseUserIdList\":[38710,82003,82005,93793,82006,82044,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\"]},\"User\":{\"id\":90814,\"name\":\"007\",\"head\":\"http://static.oschina.net/uploads/user/51/102723_50.jpg?t=1449212504000\"},\"User[]\":[{\"id\":38710,\"name\":\"TommyLemon\"},{\"id\":82001,\"name\":\"测试改名\"},{\"id\":82003,\"name\":\"Wechat\"},{\"id\":82005,\"name\":\"Jan\"},{\"id\":82006,\"name\":\"Meria\"},{\"id\":82044,\"name\":\"Love\"},{\"id\":93793,\"name\":\"Mike\"}],\"[]\":[{\"Comment\":{\"id\":13,\"toId\":0,\"userId\":82005,\"momentId\":58,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-13\"},\"User\":{\"id\":82005,\"name\":\"Jan\"}},{\"Comment\":{\"id\":77,\"toId\":13,\"userId\":93793,\"momentId\":58,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-77\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":97,\"toId\":13,\"userId\":82006,\"momentId\":58,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-97\"},\"User\":{\"id\":82006,\"name\":\"Meria\"}},{\"Comment\":{\"id\":167,\"userId\":82001,\"momentId\":58,\"date\":\"2017-03-25 19:48:41.0\",\"content\":\"Nice!\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":173,\"userId\":38710,\"momentId\":58,\"date\":\"2017-03-25 20:25:13.0\",\"content\":\"Good\"},\"User\":{\"id\":38710,\"name\":\"TommyLemon\"}},{\"Comment\":{\"id\":188,\"toId\":97,\"userId\":82001,\"momentId\":58,\"date\":\"2017-03-26 15:21:32.0\",\"content\":\"1646\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}}]},{\"Moment\":{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},\"User[]\":[{\"id\":82001,\"name\":\"测试改名\"},{\"id\":82002,\"name\":\"Happy~\"},{\"id\":82003,\"name\":\"Wechat\"},{\"id\":82005,\"name\":\"Jan\"},{\"id\":82006,\"name\":\"Meria\"},{\"id\":82040,\"name\":\"Dream\"},{\"id\":90814,\"name\":\"007\"},{\"id\":93793,\"name\":\"Mike\"}],\"[]\":[{\"Comment\":{\"id\":68,\"toId\":0,\"userId\":82005,\"momentId\":371,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-68\"},\"User\":{\"id\":82005,\"name\":\"Jan\"}},{\"Comment\":{\"id\":157,\"userId\":93793,\"momentId\":371,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-157\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":110,\"toId\":0,\"userId\":93793,\"momentId\":371,\"date\":\"2017-02-01 19:23:24.0\",\"content\":\"This is a Content...-110\"},\"User\":{\"id\":93793,\"name\":\"Mike\"}},{\"Comment\":{\"id\":114,\"toId\":0,\"userId\":82001,\"momentId\":371,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-114\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":115,\"toId\":0,\"userId\":38710,\"momentId\":371,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-115\"},\"User\":{\"id\":38710,\"name\":\"TommyLemon\"}},{\"Comment\":{\"id\":116,\"toId\":0,\"userId\":70793,\"momentId\":371,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-116\"},\"User\":{\"id\":70793,\"name\":\"Strong\"}}]},{\"Moment\":{\"id\":170,\"userId\":70793,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-73\",\"praiseUserIdList\":[82044,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"User[]\":[{\"id\":82001,\"name\":\"测试改名\"},{\"id\":82002,\"name\":\"Happy~\"},{\"id\":82044,\"name\":\"Love\"}],\"[]\":[{\"Comment\":{\"id\":44,\"toId\":0,\"userId\":82003,\"momentId\":170,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-44\"},\"User\":{\"id\":82003,\"name\":\"Wechat\"}},{\"Comment\":{\"id\":54,\"toId\":0,\"userId\":82004,\"momentId\":170,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-54\"},\"User\":{\"id\":82004,\"name\":\"Tommy\"}},{\"Comment\":{\"id\":99,\"toId\":44,\"userId\":70793,\"momentId\":170,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-99\"},\"User\":{\"id\":70793,\"name\":\"Strong\"}},{\"Comment\":{\"id\":206,\"toId\":54,\"userId\":82001,\"momentId\":170,\"date\":\"2017-03-29 11:04:23.0\",\"content\":\"ejej\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":1490780759866,\"toId\":99,\"userId\":82001,\"momentId\":170,\"date\":\"2017-03-29 17:45:59.0\",\"content\":\"99\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":1490863661426,\"toId\":1490780759866,\"userId\":70793,\"momentId\":170,\"date\":\"2017-03-30 16:47:41.0\",\"content\":\"66\"},\"User\":{\"id\":70793,\"name\":\"Strong\"}}]},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"User\":{\"id\":38710,\"name\":\"TommyLemon\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"},\"User[]\":[{\"id\":82001,\"name\":\"测试改名\"}],\"[]\":[{\"Comment\":{\"id\":4,\"toId\":0,\"userId\":38710,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-4\"},\"User\":{\"id\":38710,\"name\":\"TommyLemon\"}},{\"Comment\":{\"id\":22,\"toId\":221,\"userId\":82001,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"测试修改评论\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}},{\"Comment\":{\"id\":47,\"toId\":4,\"userId\":70793,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-47\"},\"User\":{\"id\":70793,\"name\":\"Strong\"}},{\"Comment\":{\"id\":1490863507114,\"toId\":4,\"userId\":82003,\"momentId\":470,\"date\":\"2017-03-30 16:45:07.0\",\"content\":\"yes\"},\"User\":{\"id\":82003,\"name\":\"Wechat\"}},{\"Comment\":{\"id\":1490863903900,\"toId\":0,\"userId\":82006,\"momentId\":470,\"date\":\"2017-03-30 16:51:43.0\",\"content\":\"SOGA\"},\"User\":{\"id\":82006,\"name\":\"Meria\"}},{\"Comment\":{\"id\":1491740899179,\"toId\":0,\"userId\":82001,\"momentId\":470,\"date\":\"2017-04-09 20:28:19.0\",\"content\":\"www\"},\"User\":{\"id\":82001,\"name\":\"测试改名\"}}]}],\"code\":200,\"msg\":\"success\"}','2017-11-29 15:04:13'),(1511969181104,0,1,'添加朋友','/put','{\n    \"User\": {\n        \"id\": 82001,\n        \"contactIdList+\": [93793]\n    },\n    \"tag\": \"User\"\n}','{\"User\":{\"id\":82001,\"contactIdList+\":[93793],\"@role\":\"owner\"},\"code\":409,\"msg\":\"PUT User, contactIdList:93793 已存在！\"}','2017-11-29 15:26:21'),(1511969417633,0,1,'点赞/取消点赞','/put','{\n    \"Moment\": {\n        \"id\": 15,\n        \"praiseUserIdList-\": [\n            82001\n        ]\n    },\n    \"tag\": \"Moment\"\n}','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"id\":15,\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-29 15:30:17'),(1511969630372,0,1,'新增评论','/post','{     \"Comment\": {         \"momentId\": 15,         \"content\": \"测试新增评论\"     },     \"tag\": \"Comment\" }','{\"Comment\":{\"code\":200,\"msg\":\"success\",\"id\":1533140610714,\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-29 15:33:50'),(1511970009072,0,1,'新增动态','/post','{     \"Moment\": {         \"content\": \"测试新增动态\",         \"pictureList\": [\"http://static.oschina.net/uploads/user/48/96331_50.jpg\"         ]     },     \"tag\": \"Moment\" }','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"id\":1533140610716,\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-29 15:40:09'),(1511970224333,0,1,'修改用户信息','/put','{\r     \"User\": {\r         \"id\": 82001,\r         \"name\": \"测试账号\"\r     },\r     \"tag\": \"User\"\r }','{\"User\":{\"code\":200,\"msg\":\"success\",\"id\":82001,\"count\":1},\"code\":200,\"msg\":\"success\"}','2017-11-29 15:43:44'),(1512216131855,0,1,'获取文档列表(即在线解析网页上的文档)-表和字段、请求格式限制','/get','{\n    \"[]\": {\n        \"Table\": {\n            \"TABLE_SCHEMA\": \"sys\",\n            \"TABLE_TYPE\": \"BASE TABLE\",\n            \"TABLE_NAME!$\": [\n                \"\\\\_%\",\n                \"sys\\\\_%\",\n                \"system\\\\_%\"\n            ],\n            \"@order\": \"TABLE_NAME+\",\n            \"@column\": \"TABLE_NAME,TABLE_COMMENT\"\n        },\n        \"Column[]\": {\n            \"Column\": {\n                \"TABLE_NAME@\": \"[]/Table/TABLE_NAME\",\n                \"@column\": \"COLUMN_NAME,COLUMN_TYPE,IS_NULLABLE,COLUMN_COMMENT\"\n            }\n        }\n    },\n    \"Request[]\": {\n        \"Request\": {\n            \"@order\": \"version-,method-\"\n        }\n    }\n}',NULL,'2017-12-02 12:02:11'),(1521901518765,0,2,'功能符(对象关键词): ⑤从pictureList获取第0张图片：','/get','{     \"User\": {         \"id\": 38710,         \"@position\": 0,         \"firstPicture()\": \"getFromArray(pictureList,@position)\"     } }','{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\",\"@position\":0,\"firstPicture\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 14:25:18'),(1521901610784,0,2,'功能符(对象关键词): ④查询 按userId分组、id最大值>=100 的Moment数组','/get','{\"[]\":{\"count\":10,\"Moment\":{\"@column\":\"userId;max(id):maxId\",\"@group\":\"userId\",\"@having\":\"maxId>=100\"}}}','{\"[]\":[{\"Moment\":{\"userId\":38710,\"maxId\":1537025707417}},{\"Moment\":{\"userId\":70793,\"maxId\":551}},{\"Moment\":{\"userId\":82001,\"maxId\":1537025634931}},{\"Moment\":{\"userId\":82002,\"maxId\":1531062713966}},{\"Moment\":{\"userId\":82003,\"maxId\":1536805585275}},{\"Moment\":{\"userId\":82045,\"maxId\":1508073178489}},{\"Moment\":{\"userId\":82056,\"maxId\":1514858533480}},{\"Moment\":{\"userId\":93793,\"maxId\":1516086423441}},{\"Moment\":{\"userId\":1520242280259,\"maxId\":1520242333325}},{\"Moment\":{\"userId\":1523626157302,\"maxId\":1523936332614}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 14:26:50'),(1521901682846,0,2,'功能符(对象关键词): ③查询按userId分组的Moment数组','/get','{\"[]\":{\"count\":10,\"Moment\":{\"@column\":\"userId,id\",\"@group\":\"userId,id\"}}}','{\"[]\":[{\"Moment\":{\"userId\":38710,\"id\":235}},{\"Moment\":{\"userId\":38710,\"id\":470}},{\"Moment\":{\"userId\":38710,\"id\":511}},{\"Moment\":{\"userId\":38710,\"id\":595}},{\"Moment\":{\"userId\":38710,\"id\":704}},{\"Moment\":{\"userId\":38710,\"id\":1491200468898}},{\"Moment\":{\"userId\":38710,\"id\":1493835799335}},{\"Moment\":{\"userId\":38710,\"id\":1512314438990}},{\"Moment\":{\"userId\":38710,\"id\":1513094436910}},{\"Moment\":{\"userId\":38710,\"id\":1537025625613}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 14:28:02'),(1521901746809,0,2,'功能符(对象关键词): ②查询按 name降序、id默认顺序 排序的User数组','/get','{\"[]\":{\"count\":10,\"User\":{\"@column\":\"name,id\",\"@order\":\"name-,id\"}}}','{\"[]\":[{\"User\":{\"name\":\"赵钱孙李\",\"id\":1508072071492}},{\"User\":{\"name\":\"测试改名\",\"id\":82001}},{\"User\":{\"name\":\"梦\",\"id\":1528264711016}},{\"User\":{\"name\":\"宁旭\",\"id\":1532188114543}},{\"User\":{\"name\":\"四五六\",\"id\":1508072160401}},{\"User\":{\"name\":\"哈哈哈\",\"id\":1524042900591}},{\"User\":{\"name\":\"周吴郑王\",\"id\":1508072105320}},{\"User\":{\"name\":\"七八九十\",\"id\":1508072202871}},{\"User\":{\"name\":\"一二三\",\"id\":1499057230629}},{\"User\":{\"name\":\"Yong\",\"id\":82027}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 14:29:06'),(1521901787203,0,2,'功能符(对象关键词): ①只查询id,sex,name这几列并且请求结果也按照这个顺序','/get','{\"User\":{\"@column\":\"id,sex,name\",\"id\":38710}}','{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 14:29:47'),(1521902033332,0,2,'功能符(数组关键词): ③查询User数组和对应的User总数','/get','{\"[]\":{\"query\":2,\"count\":5,\"User\":{}},\"total@\":\"/[]/total\"}','{\"[]\":[{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82001,\"sex\":0,\"name\":\"测试改名\",\"tag\":\"APIJSON User\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\",\"contactIdList\":[82025,82024,82003,93793,82012,82028,82021,82006,82030,82035],\"pictureList\":[\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82002,\"sex\":1,\"name\":\"Happy~\",\"tag\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\",\"contactIdList\":[82005,82001,38710],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82003,\"sex\":1,\"name\":\"Wechat\",\"head\":\"http://common.cnblogs.com/images/wechat.png\",\"contactIdList\":[82001,93793],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}}],\"total\":121,\"code\":200,\"msg\":\"success\"}','2018-03-24 14:33:53'),(1521902069871,0,2,'功能符(数组关键词): ②查询第3页的User数组，每页5个','/get','{\"[]\":{\"count\":5,\"page\":3,\"User\":{}}}','{\"[]\":[{\"User\":{\"id\":82025,\"sex\":1,\"name\":\"Tommy\",\"head\":\"http://static.oschina.net/uploads/user/629/1258821_50.jpg?t=1378063141000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82026,\"sex\":0,\"name\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1200/2400261_50.png?t=1439638750000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82027,\"sex\":0,\"name\":\"Yong\",\"head\":\"http://my.oschina.net/img/portrait.gif?t=1451961935000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82028,\"sex\":1,\"name\":\"gaeg\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82029,\"sex\":0,\"name\":\"GASG\",\"head\":\"http://common.cnblogs.com/images/wechat.png\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 14:34:29'),(1521902110680,0,2,'功能符(数组关键词): ①查询User数组，最多5个','/get','{\"[]\":{\"count\":5,\"User\":{}}}','{\"[]\":[{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82001,\"sex\":0,\"name\":\"测试改名\",\"tag\":\"APIJSON User\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\",\"contactIdList\":[82025,82024,82003,93793,82012,82028,82021,82006,82030,82035],\"pictureList\":[\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82002,\"sex\":1,\"name\":\"Happy~\",\"tag\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\",\"contactIdList\":[82005,82001,38710],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}},{\"User\":{\"id\":82003,\"sex\":1,\"name\":\"Wechat\",\"head\":\"http://common.cnblogs.com/images/wechat.png\",\"contactIdList\":[82001,93793],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 14:35:10'),(1521903761689,0,2,'功能符(逻辑运算): ③ ! 非运算','/head','{\"User\":{\"id!{}\":[82001,38710]}}','{\"User\":{\"code\":200,\"msg\":\"success\",\"count\":119},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:02:41'),(1521903828410,0,2,'功能符(逻辑运算): ② | 或运算','/head','{\"User\":{\"id|{}\":\">90000,<=80000\"}}','{\"User\":{\"code\":200,\"msg\":\"success\",\"count\":72},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:03:48'),(1521903882830,0,2,'功能符(逻辑运算): ① & 与运算','/head','{\"User\":{\"id&{}\":\">80000,<=90000\"}}','{\"User\":{\"code\":200,\"msg\":\"success\",\"count\":49},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:04:42'),(1521904098111,0,2,'功能符: 减少 或 去除','/put/balance','{\n    \n    \"Privacy\": {\n        \"id\": 82001,\n        \"balance+\": -100,\n        \"_payPassword\": \"123456\"\n    },\"tag\": \"Privacy\"\n}','{\"Privacy\":{\"code\":200,\"msg\":\"success\",\"id\":82001,\"count\":1},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:08:18'),(1521904162066,0,2,'功能符: 增加 或 扩展','/put','{\n    \"Moment\": {\n        \"id\": 15,\n        \"praiseUserIdList+\": [\n            82001\n        ]\n    },\n    \"tag\": \"Moment\"\n}','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"id\":15,\"count\":1},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:09:22'),(1521904337054,0,2,'功能符: 新建别名','/get','{\"Comment\":{\"@column\":\"id,toId:parentId\",\"id\":51}}','{\"Comment\":{\"id\":51,\"parentId\":45},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:12:17'),(1521904394042,0,2,'功能符: 正则匹配','/get','{\"User[]\":{\"count\":3,\"User\":{\"name?\":\"^[0-9]+$\"}}}','{\"User[]\":[{\"id\":90814,\"sex\":0,\"name\":\"007\",\"head\":\"http://static.oschina.net/uploads/user/51/102723_50.jpg?t=1449212504000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":1528339692804,\"sex\":1,\"name\":\"568599\",\"head\":\"http://my.oschina.net/img/portrait.gif?t=1451961935000\",\"contactIdList\":[1528250827953,1528264711016],\"date\":\"2018-06-07 10:48:12.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:13:14'),(1521904437584,0,2,'功能符: 模糊搜索','/get','{\"User[]\":{\"count\":3,\"User\":{\"name$\":\"%m%\"}}}','{\"User[]\":[{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82004,\"sex\":0,\"name\":\"Tommy\",\"tag\":\"fasef\",\"head\":\"http://static.oschina.net/uploads/user/1200/2400261_50.png?t=1439638750000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82006,\"sex\":1,\"name\":\"Meria\",\"head\":\"http://static.oschina.net/uploads/user/998/1997902_50.jpg?t=1407806577000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:13:57'),(1521904547992,0,2,'功能符: 引用赋值','/get','{\"Moment\":{\n   \"userId\":38710\n},\n\"User\":{\n   \"id@\":\"/Moment/userId\"\n}}','{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:15:47'),(1521904617127,0,2,'功能符: 远程调用函数','/get','{     \"Moment\": {         \"id\": 301,         \"@column\": \"userId,praiseUserIdList\",         \"isPraised()\": \"isContain(praiseUserIdList,userId)\"     } }','{\"Moment\":{\"userId\":93793,\"praiseUserIdList\":[38710,93793,82003,82005,82040,82055,82002,82001],\"isPraised\":true},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:16:57'),(1521904653622,0,2,'功能符: 包含选项范围','/get','{\"User[]\":{\"count\":3,\"User\":{\"contactIdList<>\":38710}}}','{\"User[]\":[{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82002,\"sex\":1,\"name\":\"Happy~\",\"tag\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\",\"contactIdList\":[82005,82001,38710],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82005,\"sex\":1,\"name\":\"Jan\",\"tag\":\"AG\",\"head\":\"http://my.oschina.net/img/portrait.gif?t=1451961935000\",\"contactIdList\":[82001,38710,1532439021068],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:17:33'),(1521904698935,0,2,'功能符: 匹配条件范围','/get','{\"User[]\":{\"count\":3,\"User\":{\"id{}\":\"<=80000,>90000\"}}}','{\"User[]\":[{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":90814,\"sex\":0,\"name\":\"007\",\"head\":\"http://static.oschina.net/uploads/user/51/102723_50.jpg?t=1449212504000\",\"contactIdList\":[],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:18:18'),(1521904756674,0,2,'功能符: 查询数组','/get','{\"User[]\":{\"count\":3,\"User\":{}}}','{\"User[]\":[{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82001,\"sex\":0,\"name\":\"测试改名\",\"tag\":\"APIJSON User\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\",\"contactIdList\":[82025,82024,82003,93793],\"pictureList\":[\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:19:16'),(1521905263828,0,2,'操作方法(DELETE):  删除数据','/delete','{\n   \"Moment\":{\n     \"id\":120\n   },\n   \"tag\":\"Moment\"\n}','{\"Moment\":{\"code\":404,\"msg\":\"可能对象不存在！\",\"id\":120,\"count\":0},\"Comment\":{\"code\":404,\"msg\":\"可能对象不存在！\",\"count\":0},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:27:43'),(1521905599150,0,2,'操作方法(PUT):  修改数据，只修改所传的字段','/put','{\n   \"Moment\":{\n     \"id\":235,\n     \"content\":\"APIJSON,let interfaces and documents go to hell !\"\n   },\n   \"tag\":\"Moment\"\n}','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"id\":235,\"count\":1},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:33:19'),(1521905680680,0,2,'操作方法(POST):  新增数据','/post','{     \"Moment\": {         \"content\": \"APIJSON,let interfaces and documents go to hell !\"     },     \"tag\": \"Moment\" }','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"id\":1538112282445,\"count\":1},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:34:40'),(1521905787850,0,2,'操作方法(HEADS):  安全/私密获取数量，用于获取银行卡数量等 对安全性要求高的数据总数','/heads','{\n    \"Login\": {\n        \"userId\": 38710,\"type\":1\n    },\n    \"tag\": \"Login\"\n}','{\"Login\":{\"code\":200,\"msg\":\"success\",\"count\":1},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:36:27'),(1521905868719,0,2,'操作方法(GETS):  安全/私密获取数据，用于获取钱包等 对安全性要求高的数据','/gets','{\n    \"Privacy\": {\n        \"id\": 82001\n    },\n    \"tag\": \"Privacy\"\n}','{\"Privacy\":{\"id\":82001,\"certified\":1,\"phone\":13000082001,\"balance\":9832.86},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:37:48'),(1521905895591,0,2,'操作方法(HEAD):  普通获取数量，可用浏览器调试','/head','{\n   \"Moment\":{\n     \"userId\":38710\n   }\n}','{\"Moment\":{\"code\":200,\"msg\":\"success\",\"count\":10},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:38:15'),(1521905913188,0,2,'操作方法(GET):  普通获取数据，可用浏览器调试','/get','{\n   \"Moment\":{\n     \"id\":235\n   }\n}','{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"code\":200,\"msg\":\"success\"}','2018-03-24 15:38:33'),(1521906240332,0,2,'User发布的Moment列表，每个Moment包括 1.发布者User 2.前3条Comment: ③不查已获取的User','/get','{\n   \"[]\":{\n     \"page\":0,\n     \"count\":3, \n     \"Moment\":{\n       \"userId\":38710\n     },\n     \"Comment[]\":{\n       \"count\":3,\n       \"Comment\":{\n         \"momentId@\":\"[]/Moment/id\"\n       }\n     }\n   }\n}','{\"[]\":[{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"Comment[]\":[{\"id\":160,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-160\"},{\"id\":163,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-163\"},{\"id\":168,\"toId\":1490442545077,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-25 19:49:14.0\",\"content\":\"???\"}]},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"Comment[]\":[{\"id\":4,\"toId\":0,\"userId\":38710,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-4\"},{\"id\":22,\"toId\":221,\"userId\":82001,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"测试修改评论\"},{\"id\":47,\"toId\":4,\"userId\":70793,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-47\"}]},{\"Moment\":{\"id\":511,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"praiseUserIdList\":[70793,93793,82001],\"pictureList\":[\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\"]},\"Comment[]\":[{\"id\":178,\"userId\":38710,\"momentId\":511,\"date\":\"2017-03-25 20:30:55.0\",\"content\":\"wbw\"},{\"id\":1490863711703,\"toId\":0,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:31.0\",\"content\":\"I hope I can join\"},{\"id\":1490863717947,\"toId\":178,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:37.0\",\"content\":\"what?\"}]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:44:00'),(1521906265960,0,2,'User发布的Moment列表，每个Moment包括 1.发布者User 2.前3条Comment: ②省去重复的User','/get','{\n   \"User\":{\n     \"id\":38710\n   },\n   \"[]\":{\n     \"page\":0,\n     \"count\":3, \n     \"Moment\":{\n       \"userId\":38710\n     }, \n     \"Comment[]\":{\n       \"count\":3,\n       \"Comment\":{\n         \"momentId@\":\"[]/Moment/id\"\n       }\n     }\n   }\n}','{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"[]\":[{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"Comment[]\":[{\"id\":160,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-160\"},{\"id\":163,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-163\"},{\"id\":168,\"toId\":1490442545077,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-25 19:49:14.0\",\"content\":\"???\"}]},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"Comment[]\":[{\"id\":4,\"toId\":0,\"userId\":38710,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-4\"},{\"id\":22,\"toId\":221,\"userId\":82001,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"测试修改评论\"},{\"id\":47,\"toId\":4,\"userId\":70793,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-47\"}]},{\"Moment\":{\"id\":511,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"praiseUserIdList\":[70793,93793,82001],\"pictureList\":[\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\"]},\"Comment[]\":[{\"id\":178,\"userId\":38710,\"momentId\":511,\"date\":\"2017-03-25 20:30:55.0\",\"content\":\"wbw\"},{\"id\":1490863711703,\"toId\":0,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:31.0\",\"content\":\"I hope I can join\"},{\"id\":1490863717947,\"toId\":178,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:37.0\",\"content\":\"what?\"}]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:44:25'),(1521906517001,0,2,'User发布的Moment列表，每个Moment包括 1.发布者User 2.前3条Comment: ①指定id','/get','{\n    \"[]\": {\n        \"page\": 0,\n        \"count\": 3,\n        \"Moment\":{\"userId\":38710}, \"User\":{\"id\":38710} ,\n        \"Comment[]\": {\n            \"count\": 3,\n            \"Comment\": {\n                \"momentId@\": \"[]/Moment/id\"\n            }\n        }\n    }\n}','{\"[]\":[{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":160,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-160\"},{\"id\":163,\"toId\":0,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-02 13:56:06.0\",\"content\":\"This is a Content...-163\"},{\"id\":168,\"toId\":1490442545077,\"userId\":82001,\"momentId\":235,\"date\":\"2017-03-25 19:49:14.0\",\"content\":\"???\"}]},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":4,\"toId\":0,\"userId\":38710,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-4\"},{\"id\":22,\"toId\":221,\"userId\":82001,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"测试修改评论\"},{\"id\":47,\"toId\":4,\"userId\":70793,\"momentId\":470,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-47\"}]},{\"Moment\":{\"id\":511,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"praiseUserIdList\":[70793,93793,82001],\"pictureList\":[\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\"]},\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":178,\"userId\":38710,\"momentId\":511,\"date\":\"2017-03-25 20:30:55.0\",\"content\":\"wbw\"},{\"id\":1490863711703,\"toId\":0,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:31.0\",\"content\":\"I hope I can join\"},{\"id\":1490863717947,\"toId\":178,\"userId\":70793,\"momentId\":511,\"date\":\"2017-03-30 16:48:37.0\",\"content\":\"what?\"}]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:48:37'),(1521907009308,0,2,'Moment列表，每个Moment包括 1.发布者User 2.前3条Comment','/get','{\n   \"[]\":{\n     \"page\":0, \n     \"count\":3, \n     \"Moment\":{}, \n     \"User\":{\n       \"id@\":\"/Moment/userId\"\n     },\n     \"Comment[]\":{\n       \"count\":3,\n       \"Comment\":{\n         \"momentId@\":\"[]/Moment/id\"\n       }\n     }\n   }\n}','{\"[]\":[{\"Moment\":{\"id\":12,\"userId\":70793,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"1111534034\",\"praiseUserIdList\":[70793,93793,82044,82040,82055,90814,38710,82002,82006,1508072105320,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a4f5aadef3c886f028c79b4808613a/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343932353935372d313732303737333630382e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\"]},\"User\":{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":162,\"toId\":0,\"userId\":93793,\"momentId\":12,\"date\":\"2017-03-06 13:03:45.0\",\"content\":\"This is a Content...-162\"},{\"id\":164,\"toId\":0,\"userId\":93793,\"momentId\":12,\"date\":\"2017-03-06 13:03:45.0\",\"content\":\"This is a Content...-164\"},{\"id\":172,\"toId\":162,\"userId\":82001,\"momentId\":12,\"date\":\"2017-03-25 20:22:58.0\",\"content\":\"OK\"}]},{\"Moment\":{\"id\":15,\"userId\":70793,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON is a JSON Transmission Structure Protocol…\",\"praiseUserIdList\":[82055,82002,38710],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},\"User\":{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":176,\"toId\":166,\"userId\":38710,\"momentId\":15,\"date\":\"2017-03-25 20:28:03.0\",\"content\":\"thank you\"},{\"id\":1490863469638,\"toId\":0,\"userId\":82002,\"momentId\":15,\"date\":\"2017-03-30 16:44:29.0\",\"content\":\"Just do it\"},{\"id\":1490875660259,\"toId\":1490863469638,\"userId\":82055,\"momentId\":15,\"date\":\"2017-03-30 20:07:40.0\",\"content\":\"I prove wht you said(??????)\"}]},{\"Moment\":{\"id\":32,\"userId\":82002,\"date\":\"2017-02-08 16:06:11.0\",\"praiseUserIdList\":[38710,82002,82001],\"pictureList\":[\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"https://camo.githubusercontent.com/5f5c4e0c4dc539c34e8eae8ac0cbc6dccdfee5d3/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343533333831362d323032373434343231382e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},\"User\":{\"id\":82002,\"sex\":1,\"name\":\"Happy~\",\"tag\":\"iOS\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\",\"contactIdList\":[82005,82001,38710],\"pictureList\":[],\"date\":\"2017-02-01 19:21:50.0\"},\"Comment[]\":[{\"id\":1512035117021,\"toId\":0,\"userId\":82001,\"momentId\":32,\"date\":\"2017-11-30 17:45:17.0\",\"content\":\"图片看不了啊\"},{\"id\":1512038831617,\"toId\":1512035117021,\"userId\":82001,\"momentId\":32,\"date\":\"2017-11-30 18:47:11.0\",\"content\":\"代码截屏都是2k分辨率的，并且还放在GitHub上，可以等一会儿，或者更新下ZBLibray(图片加载库从UIL换成了Glide)就行\"},{\"id\":1512039030970,\"toId\":1512035117021,\"userId\":82001,\"momentId\":32,\"date\":\"2017-11-30 18:50:30.0\",\"content\":\"一般九宫格图片都是压缩图，分辨率在300*300左右，加载很快，点击放大后才是原图，1080P左右\"}]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 15:56:49'),(1521907303540,0,2,'User列表','/get','{\n   \"User[]\":{\n     \"page\":0,\n     \"count\":3, \n     \"User\":{\n       \"sex\":0\n     }\n   }\n}','{\"User[]\":[{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},{\"id\":82001,\"sex\":0,\"name\":\"测试改名\",\"tag\":\"APIJSON User\",\"head\":\"https://static.oschina.net/uploads/user/19/39085_50.jpg\",\"contactIdList\":[82025,82024,82003,93793],\"pictureList\":[\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"}],\"code\":200,\"msg\":\"success\"}','2018-03-24 16:01:43'),(1521907317871,0,2,'Moment和对应的User','/get','{\n   \"Moment\":{\n     \"userId\":38710\n   }, \n   \"User\":{\n     \"id\":38710\n   }\n}','{\"Moment\":{\"id\":235,\"userId\":38710,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON,let interfaces and documents go to hell !\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\",\"http://static.oschina.net/uploads/user/1332/2664107_50.jpg?t=1457405500000\"]},\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 16:01:57'),(1521907333045,0,2,'User','/get','{\n   \"User\":{\n     \"id\":38710\n   }\n}','{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 16:02:13'),(1521907333047,0,2,'Moment INNER JOIN User LEFT JOIN Comment','/get','{\n    \"[]\": {\n        \"count\": 10,\n        \"page\": 0,\n        \"join\": \"&/User/id@,</Comment/momentId@\",\n        \"Moment\": {\n            \"@order\": \"date+\"\n        },\n        \"User\": {\n            \"name?\": [\n                \"a\",\n                \"t\"\n            ],\n            \"id@\": \"/Moment/userId\",\n            \"@column\": \"id,name,head\"\n        },\n        \"Comment\": {\n            \"momentId@\": \"/Moment/id\",\n            \"@column\": \"id,momentId,content\"\n        }\n    }\n}','{\"[]\":[{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"User\":{\"id\":38710,\"name\":\"TommyLemon\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"},\"Comment\":{\"id\":47,\"momentId\":470,\"content\":\"This is a Content...-47\"}},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"User\":{\"id\":38710,\"name\":\"TommyLemon\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"},\"Comment\":{\"id\":47,\"momentId\":470,\"content\":\"This is a Content...-47\"}},{\"Moment\":{\"id\":170,\"userId\":70793,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-73\",\"praiseUserIdList\":[82044,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"Comment\":{\"id\":99,\"momentId\":170,\"content\":\"This is a Content...-99\"}},{\"Moment\":{\"id\":470,\"userId\":38710,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-470\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\"]},\"User\":{\"id\":38710,\"name\":\"TommyLemon\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\"},\"Comment\":{\"id\":47,\"momentId\":470,\"content\":\"This is a Content...-47\"}},{\"Moment\":{\"id\":170,\"userId\":70793,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-73\",\"praiseUserIdList\":[82044,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"Comment\":{\"id\":99,\"momentId\":170,\"content\":\"This is a Content...-99\"}},{\"Moment\":{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},\"Comment\":{\"id\":115,\"momentId\":371,\"content\":\"This is a Content...-115\"}},{\"Moment\":{\"id\":170,\"userId\":70793,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-73\",\"praiseUserIdList\":[82044,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"Comment\":{\"id\":99,\"momentId\":170,\"content\":\"This is a Content...-99\"}},{\"Moment\":{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},\"Comment\":{\"id\":115,\"momentId\":371,\"content\":\"This is a Content...-115\"}},{\"Moment\":{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},\"Comment\":{\"id\":115,\"momentId\":371,\"content\":\"This is a Content...-115\"}},{\"Moment\":{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},\"User\":{\"id\":82002,\"name\":\"Happy~\",\"head\":\"http://static.oschina.net/uploads/user/1174/2348263_50.png?t=1439773471000\"},\"Comment\":{\"id\":115,\"momentId\":371,\"content\":\"This is a Content...-115\"}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 16:02:43'),(1521907333048,0,2,'获取粉丝的动态列表','/get','{\n    \"User-id[]\": {\n        \"User\": {\n            \"contactIdList<>\": 82001\n        }\n    },\n    \"Moment[]\": {\n        \"Moment\": {\n            \"userId{}@\": \"User-id[]\"\n        }\n    }\n}','{\"User-id[]\":[82002,82003,82005,82041,82045,82058,1512531601485,1528254173621],\"Moment[]\":[{\"id\":32,\"userId\":82002,\"date\":\"2017-02-08 16:06:11.0\",\"praiseUserIdList\":[38710,82002,82001],\"pictureList\":[\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"https://camo.githubusercontent.com/5f5c4e0c4dc539c34e8eae8ac0cbc6dccdfee5d3/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343533333831362d323032373434343231382e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172508_mpwj.jpg\"]},{\"id\":371,\"userId\":82002,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-371\",\"praiseUserIdList\":[90814,93793,82003,82005,82006,82040,82002,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\",\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\"]},{\"id\":1508053762227,\"userId\":82003,\"date\":\"2017-10-15 15:49:22.0\",\"content\":\"我也试试\",\"praiseUserIdList\":[1515565976140],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},{\"id\":1508072491570,\"userId\":82002,\"date\":\"2017-10-15 21:01:31.0\",\"content\":\"有点冷~\",\"praiseUserIdList\":[82001,82002],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},{\"id\":1508073178489,\"userId\":82045,\"date\":\"2017-10-15 21:12:58.0\",\"content\":\"发动态\",\"praiseUserIdList\":[82001],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},{\"id\":1514017444961,\"userId\":82002,\"date\":\"2017-12-23 16:24:04.0\",\"content\":\"123479589679\",\"praiseUserIdList\":[82002,1520242280259,82001,70793,1524042900591,1528264711016],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},{\"id\":1531062713966,\"userId\":82002,\"date\":\"2018-07-08 23:11:53.0\",\"content\":\"云南好美啊( ◞˟૩˟)◞\",\"praiseUserIdList\":[82001,82005,38710,70793,93793,82003,1531969715979],\"pictureList\":[\"https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1531072366455&di=c0d4b15b2c4b70aad49e6ae747f60742&imgtype=0&src=http%3A%2F%2Fpic1.win4000.com%2Fwallpaper%2F3%2F57a2a41f57d09.jpg\",\"https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1531072499167&di=5b5621d117edbc5d344a03ba0a6b580b&imgtype=0&src=http%3A%2F%2Fi0.szhomeimg.com%2FUploadFiles%2FBBS%2F2006%2F08%2F05%2F24752199_79122.91.jpg\"]},{\"id\":1536805585275,\"userId\":82003,\"date\":\"2018-09-13 10:26:25.0\",\"content\":\"iPhone Xs发布了，大家怎么看？\",\"praiseUserIdList\":[82002,82005,70793,82003,82001],\"pictureList\":[\"https://pic1.zhimg.com/80/v2-e129b40810070443add1c28e6185c894_hd.jpg\"]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 16:03:13'),(1521907546129,0,2,'获取类似微信朋友圈的动态列表','/get','{\n    \"[]\": {\n        \"page\": 0,\n        \"count\": 2,\n        \"Moment\": {\n            \"content$\": \"%a%\"\n        },\n        \"User\": {\n            \"id@\": \"/Moment/userId\",\n            \"@column\": \"id,name,head\"\n        },\n        \"Comment[]\": {\n            \"count\": 2,\n            \"Comment\": {\n                \"momentId@\": \"[]/Moment/id\"\n            }\n        }\n    }\n}','{\"[]\":[{\"Moment\":{\"id\":15,\"userId\":70793,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"APIJSON is a JSON Transmission Structure Protocol…\",\"praiseUserIdList\":[82055,82002,38710],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"]},\"User\":{\"id\":70793,\"name\":\"Strong\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\"},\"Comment[]\":[{\"id\":176,\"toId\":166,\"userId\":38710,\"momentId\":15,\"date\":\"2017-03-25 20:28:03.0\",\"content\":\"thank you\"},{\"id\":1490863469638,\"toId\":0,\"userId\":82002,\"momentId\":15,\"date\":\"2017-03-30 16:44:29.0\",\"content\":\"Just do it\"}]},{\"Moment\":{\"id\":58,\"userId\":90814,\"date\":\"2017-02-01 19:14:31.0\",\"content\":\"This is a Content...-435\",\"praiseUserIdList\":[38710,82003,82005,93793,82006,82044,82001],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172507_aMmH.jpg\"]},\"User\":{\"id\":90814,\"name\":\"007\",\"head\":\"http://static.oschina.net/uploads/user/51/102723_50.jpg?t=1449212504000\"},\"Comment[]\":[{\"id\":13,\"toId\":0,\"userId\":82005,\"momentId\":58,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-13\"},{\"id\":77,\"toId\":13,\"userId\":93793,\"momentId\":58,\"date\":\"2017-02-01 19:20:50.0\",\"content\":\"This is a Content...-77\"}]}],\"code\":200,\"msg\":\"success\"}','2018-03-24 16:05:46'),(1521907570452,0,2,'获取动态及发布者用户','/get','{\n    \"Moment\": {},\n    \"User\": {\n        \"id@\": \"Moment/userId\"\n    }\n}','{\"Moment\":{\"id\":12,\"userId\":70793,\"date\":\"2017-02-08 16:06:11.0\",\"content\":\"1111534034\",\"praiseUserIdList\":[70793,93793,82044,82040,82055,90814,38710,82002,82006,1508072105320],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a4f5aadef3c886f028c79b4808613a/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343932353935372d313732303737333630382e6a7067\",\"http://static.oschina.net/uploads/img/201604/22172507_Pz9Y.png\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\",\"https://camo.githubusercontent.com/c98b1c86af136745cc4626c6ece830f76de9ee83/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343930383036362d313837323233393236352e6a7067\",\"https://camo.githubusercontent.com/f513fa631bd780dc0ec3cf2663777e356dc3664f/687474703a2f2f696d61676573323031352e636e626c6f67732e636f6d2f626c6f672f3636303036372f3230313630342f3636303036372d32303136303431343232343733323232332d3337333933303233322e6a7067\"]},\"User\":{\"id\":70793,\"sex\":0,\"name\":\"Strong\",\"tag\":\"djdj\",\"head\":\"http://static.oschina.net/uploads/user/585/1170143_50.jpg?t=1390226446000\",\"contactIdList\":[38710,82002],\"pictureList\":[\"http://static.oschina.net/uploads/img/201604/22172508_eGDi.jpg\",\"http://static.oschina.net/uploads/img/201604/22172507_rrZ5.jpg\",\"https://camo.githubusercontent.com/788c0a7e11a\",\"https://camo.githubusercontent.com/f513f67\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 16:06:10'),(1521907587430,0,2,'获取用户列表','/get','{\n    \"[]\": {\n        \"count\": 3,\n        \"User\": {\n            \"@column\": \"id,name\"\n        }\n    }\n}','{\"[]\":[{\"User\":{\"id\":38710,\"name\":\"TommyLemon\"}},{\"User\":{\"id\":70793,\"name\":\"Strong\"}},{\"User\":{\"id\":82001,\"name\":\"测试改名\"}}],\"code\":200,\"msg\":\"success\"}','2018-03-24 16:06:27'),(1521907601299,0,2,'获取用户','/get','{\n  \"User\":{\n  }\n}','{\"User\":{\"id\":38710,\"sex\":0,\"name\":\"TommyLemon\",\"tag\":\"Android&Java\",\"head\":\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"contactIdList\":[82003,82005,90814,82004,82009,82002,82044,93793,70793],\"pictureList\":[\"http://static.oschina.net/uploads/user/1218/2437072_100.jpg?t=1461076033000\",\"http://common.cnblogs.com/images/icon_weibo_24.png\"],\"date\":\"2017-02-01 19:21:50.0\"},\"code\":200,\"msg\":\"success\"}','2018-03-24 16:06:41'),(1541433143503,82001,2,'login Test','/login','{\n    \"type\": 0,\n    \"phone\": \"13000082001\",\n    \"password\": \"123456\",\n    \"version\": 1\n}',NULL,'2018-11-05 15:52:23'),(1541567473015,82001,2,'gets Privacy','/gets','{\n    \"Privacy\": {\n        \"id\": 82001\n    },\n    \"tag\": \"Privacy\"\n}',NULL,'2018-11-07 05:11:13'),(1541757709333,82001,2,'login Test','/login','{\n    \"type\": 0,\n    \"phone\": \"13000082001\",\n    \"password\": \"123456\",\n    \"version\": 1\n}',NULL,'2018-11-09 10:01:49');
/*!40000 ALTER TABLE `Document` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2018-11-11  4:18:32
