#lang racketscript/base

(provide string->color
         color->web-color
         string->web-color
         (rename-out [-color color])
         color?)

(struct color (red green blue alpha) #:auto-value 255 #:transparent)

(define -color
  (case-lambda
    [(a b c) (color a b c 255)]
    [(a b c d) (color a b c d)]))

(define (string->color color-string)
  ($ *color-table* (string-downcase color-string)))

(define (color->web-color color)
  (string-append "rgba("
                 (color-red color) ","
                 (color-green color) ","
                 (color-blue color) ","
                 (color-alpha color) ")"))

(define (string->web-color str)
  (color->web-color (string->color str)))

(define *color-table*
  ($/obj ["orange" (-color 255 165 0)]
         ["orangered" (-color 255 69 0)]
         ["tomato" (-color 255 99 71)]
         ["darkred" (-color 139 0 0)]
         ["red" (-color 255 0 0)]
         ["firebrick" (-color 178 34 34)]
         ["crimson" (-color 220 20 60)]
         ["deeppink" (-color 255 20 147)]
         ["maroon" (-color 176 48 96)]
         ["indian red" (-color 205 92 92)]
         ["indianred" (-color 205 92 92)]
         ["medium violet red" (-color 199 21 133)]
         ["mediumvioletred" (-color 199 21 133)]
         ["violet red" (-color 208 32 144)]
         ["violetred" (-color 208 32 144)]
         ["lightcoral" (-color 240 128 128)]
         ["hotpink" (-color 255 105 180)]
         ["palevioletred" (-color 219 112 147)]
         ["lightpink" (-color 255 182 193)]
         ["rosybrown" (-color 188 143 143)]
         ["pink" (-color 255 192 203)]
         ["orchid" (-color 218 112 214)]
         ["lavenderblush" (-color 255 240 245)]
         ["snow" (-color 255 250 250)]
         ["chocolate" (-color 210 105 30)]
         ["saddlebrown" (-color 139 69 19)]
         ["brown" (-color 132 60 36)]
         ["darkorange" (-color 255 140 0)]
         ["coral" (-color 255 127 80)]
         ["sienna" (-color 160 82 45)]
         ["salmon" (-color 250 128 114)]
         ["peru" (-color 205 133 63)]
         ["darkgoldenrod" (-color 184 134 11)]
         ["goldenrod" (-color 218 165 32)]
         ["sandybrown" (-color 244 164 96)]
         ["lightsalmon" (-color 255 160 122)]
         ["darksalmon" (-color 233 150 122)]
         ["gold" (-color 255 215 0)]
         ["yellow" (-color 255 255 0)]
         ["olive" (-color 128 128 0)]
         ["burlywood" (-color 222 184 135)]
         ["tan" (-color 210 180 140)]
         ["navajowhite" (-color 255 222 173)]
         ["peachpuff" (-color 255 218 185)]
         ["khaki" (-color 240 230 140)]
         ["darkkhaki" (-color 189 183 107)]
         ["moccasin" (-color 255 228 181)]
         ["wheat" (-color 245 222 179)]
         ["bisque" (-color 255 228 196)]
         ["palegoldenrod" (-color 238 232 170)]
         ["blanchedalmond" (-color 255 235 205)]
         ["medium goldenrod" (-color 234 234 173)]
         ["mediumgoldenrod" (-color 234 234 173)]
         ["papayawhip" (-color 255 239 213)]
         ["mistyrose" (-color 255 228 225)]
         ["lemonchiffon" (-color 255 250 205)]
         ["antiquewhite" (-color 250 235 215)]
         ["cornsilk" (-color 255 248 220)]
         ["lightgoldenrodyellow" (-color 250 250 210)]
         ["oldlace" (-color 253 245 230)]
         ["linen" (-color 250 240 230)]
         ["lightyellow" (-color 255 255 224)]
         ["seashell" (-color 255 245 238)]
         ["beige" (-color 245 245 220)]
         ["floralwhite" (-color 255 250 240)]
         ["ivory" (-color 255 255 240)]
         ["green" (-color 0 255 0)]
         ["lawngreen" (-color 124 252 0)]
         ["chartreuse" (-color 127 255 0)]
         ["green yellow" (-color 173 255 47)]
         ["greenyellow" (-color 173 255 47)]
         ["yellow green" (-color 154 205 50)]
         ["yellowgreen" (-color 154 205 50)]
         ["medium forest green" (-color 107 142 35)]
         ["olivedrab" (-color 107 142 35)]
         ["mediumforestgreen" (-color 107 142 35)]
         ["dark olive green" (-color 85 107 47)]
         ["darkolivegreen" (-color 85 107 47)]
         ["darkseagreen" (-color 143 188 139)]
         ["lime" (-color 0 255 0)]
         ["dark green" (-color 0 100 0)]
         ["darkgreen" (-color 0 100 0)]
         ["lime green" (-color 50 205 50)]
         ["limegreen" (-color 50 205 50)]
         ["forest green" (-color 34 139 34)]
         ["forestgreen" (-color 34 139 34)]
         ["spring green" (-color 0 255 127)]
         ["springgreen" (-color 0 255 127)]
         ["medium spring green" (-color 0 250 154)]
         ["mediumspringgreen" (-color 0 250 154)]
         ["sea green" (-color 46 139 87)]
         ["seagreen" (-color 46 139 87)]
         ["medium sea green" (-color 60 179 113)]
         ["mediumseagreen" (-color 60 179 113)]
         ["aquamarine" (-color 112 216 144)]
         ["lightgreen" (-color 144 238 144)]
         ["pale green" (-color 152 251 152)]
         ["palegreen" (-color 152 251 152)]
         ["medium aquamarine" (-color 102 205 170)]
         ["mediumaquamarine" (-color 102 205 170)]
         ["turquoise" (-color 64 224 208)]
         ["lightseagreen" (-color 32 178 170)]
         ["medium turquoise" (-color 72 209 204)]
         ["mediumturquoise" (-color 72 209 204)]
         ["honeydew" (-color 240 255 240)]
         ["mintcream" (-color 245 255 250)]
         ["royalblue" (-color 65 105 225)]
         ["dodgerblue" (-color 30 144 255)]
         ["deepskyblue" (-color 0 191 255)]
         ["cornflowerblue" (-color 100 149 237)]
         ["steel blue" (-color 70 130 180)]
         ["steelblue" (-color 70 130 180)]
         ["lightskyblue" (-color 135 206 250)]
         ["dark turquoise" (-color 0 206 209)]
         ["darkturquoise" (-color 0 206 209)]
         ["cyan" (-color 0 255 255)]
         ["aqua" (-color 0 255 255)]
         ["darkcyan" (-color 0 139 139)]
         ["teal" (-color 0 128 128)]
         ["sky blue" (-color 135 206 235)]
         ["skyblue" (-color 135 206 235)]
         ["cadet blue" (-color 96 160 160)]
         ["cadetblue" (-color 95 158 160)]
         ["dark slate gray" (-color 47 79 79)]
         ["darkslategray" (-color 47 79 79)]
         ["lightslategray" (-color 119 136 153)]
         ["slategray" (-color 112 128 144)]
         ["light steel blue" (-color 176 196 222)]
         ["lightsteelblue" (-color 176 196 222)]
         ["light blue" (-color 173 216 230)]
         ["lightblue" (-color 173 216 230)]
         ["powderblue" (-color 176 224 230)]
         ["paleturquoise" (-color 175 238 238)]
         ["lightcyan" (-color 224 255 255)]
         ["aliceblue" (-color 240 248 255)]
         ["azure" (-color 240 255 255)]
         ["medium blue" (-color 0 0 205)]
         ["mediumblue" (-color 0 0 205)]
         ["darkblue" (-color 0 0 139)]
         ["midnight blue" (-color 25 25 112)]
         ["midnightblue" (-color 25 25 112)]
         ["navy" (-color 36 36 140)]
         ["blue" (-color 0 0 255)]
         ["indigo" (-color 75 0 130)]
         ["blue violet" (-color 138 43 226)]
         ["blueviolet" (-color 138 43 226)]
         ["medium slate blue" (-color 123 104 238)]
         ["mediumslateblue" (-color 123 104 238)]
         ["slate blue" (-color 106 90 205)]
         ["slateblue" (-color 106 90 205)]
         ["purple" (-color 160 32 240)]
         ["dark slate blue" (-color 72 61 139)]
         ["darkslateblue" (-color 72 61 139)]
         ["darkviolet" (-color 148 0 211)]
         ["dark orchid" (-color 153 50 204)]
         ["darkorchid" (-color 153 50 204)]
         ["mediumpurple" (-color 147 112 219)]
         ["cornflower blue" (-color 68 64 108)]
         ["medium orchid" (-color 186 85 211)]
         ["mediumorchid" (-color 186 85 211)]
         ["magenta" (-color 255 0 255)]
         ["fuchsia" (-color 255 0 255)]
         ["darkmagenta" (-color 139 0 139)]
         ["violet" (-color 238 130 238)]
         ["plum" (-color 221 160 221)]
         ["lavender" (-color 230 230 250)]
         ["thistle" (-color 216 191 216)]
         ["ghostwhite" (-color 248 248 255)]
         ["white" (-color 255 255 255)]
         ["whitesmoke" (-color 245 245 245)]
         ["gainsboro" (-color 220 220 220)]
         ["light gray" (-color 211 211 211)]
         ["lightgray" (-color 211 211 211)]
         ["silver" (-color 192 192 192)]
         ["gray" (-color 190 190 190)]
         ["dark gray" (-color 169 169 169)]
         ["darkgray" (-color 169 169 169)]
         ["dim gray" (-color 105 105 105)]
         ["dimgray" (-color 105 105 105)]
         ["black" (-color 0 0 0)]))
