# financials.py
from typing import Optional, Any, Dict, List, Union, Iterator
from urllib3 import HTTPResponse
from datetime import datetime, date

from .base import BaseClient
from .models.financials import (
    FinancialBalanceSheet,
    FinancialCashFlowStatement,
    FinancialIncomeStatement,
    FinancialRatio,
)
from .models.common import Sort
from .models.request import RequestOptionBuilder


class FinancialsClient(BaseClient):
    """
    Client for the Stocks Financials REST Endpoints
    (aligned with the paths from /stocks/financials/v1/...)
    """

    def list_financials_balance_sheets(
        self,
        cik: Optional[str] = None,
        cik_any_of: Optional[str] = None,
        cik_gt: Optional[str] = None,
        cik_gte: Optional[str] = None,
        cik_lt: Optional[str] = None,
        cik_lte: Optional[str] = None,
        tickers: Optional[str] = None,
        tickers_all_of: Optional[str] = None,
        tickers_any_of: Optional[str] = None,
        period_end: Optional[Union[str, date]] = None,
        period_end_gt: Optional[Union[str, date]] = None,
        period_end_gte: Optional[Union[str, date]] = None,
        period_end_lt: Optional[Union[str, date]] = None,
        period_end_lte: Optional[Union[str, date]] = None,
        filing_date: Optional[Union[str, date]] = None,
        filing_date_gt: Optional[Union[str, date]] = None,
        filing_date_gte: Optional[Union[str, date]] = None,
        filing_date_lt: Optional[Union[str, date]] = None,
        filing_date_lte: Optional[Union[str, date]] = None,
        fiscal_year: Optional[float] = None,
        fiscal_year_gt: Optional[float] = None,
        fiscal_year_gte: Optional[float] = None,
        fiscal_year_lt: Optional[float] = None,
        fiscal_year_lte: Optional[float] = None,
        fiscal_quarter: Optional[float] = None,
        fiscal_quarter_gt: Optional[float] = None,
        fiscal_quarter_gte: Optional[float] = None,
        fiscal_quarter_lt: Optional[float] = None,
        fiscal_quarter_lte: Optional[float] = None,
        timeframe: Optional[str] = None,
        timeframe_any_of: Optional[str] = None,
        timeframe_gt: Optional[str] = None,
        timeframe_gte: Optional[str] = None,
        timeframe_lt: Optional[str] = None,
        timeframe_lte: Optional[str] = None,
        limit: Optional[int] = None,
        sort: Optional[Union[str, Sort]] = None,
        params: Optional[Dict[str, Any]] = None,
        raw: bool = False,
        options: Optional[RequestOptionBuilder] = None,
    ) -> Union[Iterator[FinancialBalanceSheet], HTTPResponse]:
        """
        Endpoint: GET /stocks/financials/v1/balance-sheets
        """
        url = "/stocks/financials/v1/balance-sheets"
        return self._paginate(
            path=url,
            params=self._get_params(self.list_financials_balance_sheets, locals()),
            raw=raw,
            deserializer=FinancialBalanceSheet.from_dict,
            options=options,
        )

    def list_financials_cash_flow_statements(
        self,
        cik: Optional[str] = None,
        cik_any_of: Optional[str] = None,
        cik_gt: Optional[str] = None,
        cik_gte: Optional[str] = None,
        cik_lt: Optional[str] = None,
        cik_lte: Optional[str] = None,
        period_end: Optional[Union[str, date]] = None,
        period_end_gt: Optional[Union[str, date]] = None,
        period_end_gte: Optional[Union[str, date]] = None,
        period_end_lt: Optional[Union[str, date]] = None,
        period_end_lte: Optional[Union[str, date]] = None,
        filing_date: Optional[Union[str, date]] = None,
        filing_date_gt: Optional[Union[str, date]] = None,
        filing_date_gte: Optional[Union[str, date]] = None,
        filing_date_lt: Optional[Union[str, date]] = None,
        filing_date_lte: Optional[Union[str, date]] = None,
        tickers: Optional[str] = None,
        tickers_all_of: Optional[str] = None,
        tickers_any_of: Optional[str] = None,
        fiscal_year: Optional[float] = None,
        fiscal_year_gt: Optional[float] = None,
        fiscal_year_gte: Optional[float] = None,
        fiscal_year_lt: Optional[float] = None,
        fiscal_year_lte: Optional[float] = None,
        fiscal_quarter: Optional[float] = None,
        fiscal_quarter_gt: Optional[float] = None,
        fiscal_quarter_gte: Optional[float] = None,
        fiscal_quarter_lt: Optional[float] = None,
        fiscal_quarter_lte: Optional[float] = None,
        timeframe: Optional[str] = None,
        timeframe_any_of: Optional[str] = None,
        timeframe_gt: Optional[str] = None,
        timeframe_gte: Optional[str] = None,
        timeframe_lt: Optional[str] = None,
        timeframe_lte: Optional[str] = None,
        limit: Optional[int] = None,
        sort: Optional[Union[str, Sort]] = None,
        params: Optional[Dict[str, Any]] = None,
        raw: bool = False,
        options: Optional[RequestOptionBuilder] = None,
    ) -> Union[Iterator[FinancialCashFlowStatement], HTTPResponse]:
        """
        Endpoint: GET /stocks/financials/v1/cash-flow-statements
        """
        url = "/stocks/financials/v1/cash-flow-statements"
        return self._paginate(
            path=url,
            params=self._get_params(
                self.list_financials_cash_flow_statements, locals()
            ),
            raw=raw,
            deserializer=FinancialCashFlowStatement.from_dict,
            options=options,
        )

    def list_financials_income_statements(
        self,
        cik: Optional[str] = None,
        cik_any_of: Optional[str] = None,
        cik_gt: Optional[str] = None,
        cik_gte: Optional[str] = None,
        cik_lt: Optional[str] = None,
        cik_lte: Optional[str] = None,
        tickers: Optional[str] = None,
        tickers_all_of: Optional[str] = None,
        tickers_any_of: Optional[str] = None,
        period_end: Optional[Union[str, date]] = None,
        period_end_gt: Optional[Union[str, date]] = None,
        period_end_gte: Optional[Union[str, date]] = None,
        period_end_lt: Optional[Union[str, date]] = None,
        period_end_lte: Optional[Union[str, date]] = None,
        filing_date: Optional[Union[str, date]] = None,
        filing_date_gt: Optional[Union[str, date]] = None,
        filing_date_gte: Optional[Union[str, date]] = None,
        filing_date_lt: Optional[Union[str, date]] = None,
        filing_date_lte: Optional[Union[str, date]] = None,
        fiscal_year: Optional[float] = None,
        fiscal_year_gt: Optional[float] = None,
        fiscal_year_gte: Optional[float] = None,
        fiscal_year_lt: Optional[float] = None,
        fiscal_year_lte: Optional[float] = None,
        fiscal_quarter: Optional[float] = None,
        fiscal_quarter_gt: Optional[float] = None,
        fiscal_quarter_gte: Optional[float] = None,
        fiscal_quarter_lt: Optional[float] = None,
        fiscal_quarter_lte: Optional[float] = None,
        timeframe: Optional[str] = None,
        timeframe_any_of: Optional[str] = None,
        timeframe_gt: Optional[str] = None,
        timeframe_gte: Optional[str] = None,
        timeframe_lt: Optional[str] = None,
        timeframe_lte: Optional[str] = None,
        limit: Optional[int] = None,
        sort: Optional[Union[str, Sort]] = None,
        params: Optional[Dict[str, Any]] = None,
        raw: bool = False,
        options: Optional[RequestOptionBuilder] = None,
    ) -> Union[Iterator[FinancialIncomeStatement], HTTPResponse]:
        """
        Endpoint: GET /stocks/financials/v1/income-statements
        """
        url = "/stocks/financials/v1/income-statements"
        return self._paginate(
            path=url,
            params=self._get_params(self.list_financials_income_statements, locals()),
            raw=raw,
            deserializer=FinancialIncomeStatement.from_dict,
            options=options,
        )

    def list_financials_ratios(
        self,
        ticker: Optional[str] = None,
        ticker_any_of: Optional[str] = None,
        ticker_gt: Optional[str] = None,
        ticker_gte: Optional[str] = None,
        ticker_lt: Optional[str] = None,
        ticker_lte: Optional[str] = None,
        cik: Optional[str] = None,
        cik_any_of: Optional[str] = None,
        cik_gt: Optional[str] = None,
        cik_gte: Optional[str] = None,
        cik_lt: Optional[str] = None,
        cik_lte: Optional[str] = None,
        price: Optional[float] = None,
        price_gt: Optional[float] = None,
        price_gte: Optional[float] = None,
        price_lt: Optional[float] = None,
        price_lte: Optional[float] = None,
        average_volume: Optional[float] = None,
        average_volume_gt: Optional[float] = None,
        average_volume_gte: Optional[float] = None,
        average_volume_lt: Optional[float] = None,
        average_volume_lte: Optional[float] = None,
        market_cap: Optional[float] = None,
        market_cap_gt: Optional[float] = None,
        market_cap_gte: Optional[float] = None,
        market_cap_lt: Optional[float] = None,
        market_cap_lte: Optional[float] = None,
        earnings_per_share: Optional[float] = None,
        earnings_per_share_gt: Optional[float] = None,
        earnings_per_share_gte: Optional[float] = None,
        earnings_per_share_lt: Optional[float] = None,
        earnings_per_share_lte: Optional[float] = None,
        price_to_earnings: Optional[float] = None,
        price_to_earnings_gt: Optional[float] = None,
        price_to_earnings_gte: Optional[float] = None,
        price_to_earnings_lt: Optional[float] = None,
        price_to_earnings_lte: Optional[float] = None,
        price_to_book: Optional[float] = None,
        price_to_book_gt: Optional[float] = None,
        price_to_book_gte: Optional[float] = None,
        price_to_book_lt: Optional[float] = None,
        price_to_book_lte: Optional[float] = None,
        price_to_sales: Optional[float] = None,
        price_to_sales_gt: Optional[float] = None,
        price_to_sales_gte: Optional[float] = None,
        price_to_sales_lt: Optional[float] = None,
        price_to_sales_lte: Optional[float] = None,
        price_to_cash_flow: Optional[float] = None,
        price_to_cash_flow_gt: Optional[float] = None,
        price_to_cash_flow_gte: Optional[float] = None,
        price_to_cash_flow_lt: Optional[float] = None,
        price_to_cash_flow_lte: Optional[float] = None,
        price_to_free_cash_flow: Optional[float] = None,
        price_to_free_cash_flow_gt: Optional[float] = None,
        price_to_free_cash_flow_gte: Optional[float] = None,
        price_to_free_cash_flow_lt: Optional[float] = None,
        price_to_free_cash_flow_lte: Optional[float] = None,
        dividend_yield: Optional[float] = None,
        dividend_yield_gt: Optional[float] = None,
        dividend_yield_gte: Optional[float] = None,
        dividend_yield_lt: Optional[float] = None,
        dividend_yield_lte: Optional[float] = None,
        return_on_assets: Optional[float] = None,
        return_on_assets_gt: Optional[float] = None,
        return_on_assets_gte: Optional[float] = None,
        return_on_assets_lt: Optional[float] = None,
        return_on_assets_lte: Optional[float] = None,
        return_on_equity: Optional[float] = None,
        return_on_equity_gt: Optional[float] = None,
        return_on_equity_gte: Optional[float] = None,
        return_on_equity_lt: Optional[float] = None,
        return_on_equity_lte: Optional[float] = None,
        debt_to_equity: Optional[float] = None,
        debt_to_equity_gt: Optional[float] = None,
        debt_to_equity_gte: Optional[float] = None,
        debt_to_equity_lt: Optional[float] = None,
        debt_to_equity_lte: Optional[float] = None,
        current: Optional[float] = None,
        current_gt: Optional[float] = None,
        current_gte: Optional[float] = None,
        current_lt: Optional[float] = None,
        current_lte: Optional[float] = None,
        quick: Optional[float] = None,
        quick_gt: Optional[float] = None,
        quick_gte: Optional[float] = None,
        quick_lt: Optional[float] = None,
        quick_lte: Optional[float] = None,
        cash: Optional[float] = None,
        cash_gt: Optional[float] = None,
        cash_gte: Optional[float] = None,
        cash_lt: Optional[float] = None,
        cash_lte: Optional[float] = None,
        ev_to_sales: Optional[float] = None,
        ev_to_sales_gt: Optional[float] = None,
        ev_to_sales_gte: Optional[float] = None,
        ev_to_sales_lt: Optional[float] = None,
        ev_to_sales_lte: Optional[float] = None,
        ev_to_ebitda: Optional[float] = None,
        ev_to_ebitda_gt: Optional[float] = None,
        ev_to_ebitda_gte: Optional[float] = None,
        ev_to_ebitda_lt: Optional[float] = None,
        ev_to_ebitda_lte: Optional[float] = None,
        enterprise_value: Optional[float] = None,
        enterprise_value_gt: Optional[float] = None,
        enterprise_value_gte: Optional[float] = None,
        enterprise_value_lt: Optional[float] = None,
        enterprise_value_lte: Optional[float] = None,
        free_cash_flow: Optional[float] = None,
        free_cash_flow_gt: Optional[float] = None,
        free_cash_flow_gte: Optional[float] = None,
        free_cash_flow_lt: Optional[float] = None,
        free_cash_flow_lte: Optional[float] = None,
        limit: Optional[int] = None,
        sort: Optional[Union[str, Sort]] = None,
        params: Optional[Dict[str, Any]] = None,
        raw: bool = False,
        options: Optional[RequestOptionBuilder] = None,
    ) -> Union[Iterator[FinancialRatio], HTTPResponse]:
        """
        Endpoint: GET /stocks/financials/v1/ratios
        """
        url = "/stocks/financials/v1/ratios"
        return self._paginate(
            path=url,
            params=self._get_params(self.list_financials_ratios, locals()),
            raw=raw,
            deserializer=FinancialRatio.from_dict,
            options=options,
        )
