/*!
 * bootstrap-fileinput v5.5.5
 * http://plugins.krajee.com/file-input
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2024, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD-3-Clause
 * https://github.com/kartik-v/bootstrap-fileinput/blob/master/LICENSE.md
 */
!function(e){"use strict";"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof module&&"object"==typeof module.exports?e(require("jquery")):e(window.jQuery)}(function(H){"use strict";H.fn.fileinputLocales={},H.fn.fileinputThemes={},H.fn.fileinputBsVersion||(H.fn.fileinputBsVersion=window.bootstrap&&window.bootstrap.Alert&&window.bootstrap.Alert.VERSION||window.Alert&&window.Alert.VERSION||"3.x.x"),String.prototype.setTokens=function(e){var t,i,a=this.toString();for(t in e)e.hasOwnProperty(t)&&(i=new RegExp("{"+t+"}","g"),a=a.replace(i,e[t]));return a},Array.prototype.flatMap||(Array.prototype.flatMap=function(e){return[].concat(this.map(e))}),W={FRAMES:".kv-preview-thumb",SORT_CSS:"file-sortable",INIT_FLAG:"init-",SCRIPT_SRC:document&&document.currentScript&&document.currentScript.src||null,OBJECT_PARAMS:'<param name="controller" value="true" />\n<param name="allowFullScreen" value="true" />\n<param name="allowScriptAccess" value="always" />\n<param name="autoPlay" value="false" />\n<param name="autoStart" value="false" />\n<param name="quality" value="high" />\n',DEFAULT_PREVIEW:'<div class="file-preview-other">\n<span class="{previewFileIconClass}">{previewFileIcon}</span>\n</div>',MODAL_ID:"kvFileinputModal",MODAL_EVENTS:["show","shown","hide","hidden","loaded"],logMessages:{ajaxError:"{status}: {error}. Error Details: {text}.",badDroppedFiles:"Error scanning dropped files!",badExifParser:"Error loading the piexif.js library. {details}",badInputType:'The input "type" must be set to "file" for initializing the "bootstrap-fileinput" plugin.',exifWarning:'To avoid this warning, either set "autoOrientImage" to "false" OR ensure you have loaded the "piexif.js" library correctly on your page before the "fileinput.js" script.',invalidChunkSize:'Invalid upload chunk size: "{chunkSize}". Resumable uploads are disabled.',invalidThumb:'Invalid thumb frame with id: "{id}".',noResumableSupport:"The browser does not support resumable or chunk uploads.",noUploadUrl:'The "uploadUrl" is not set. Ajax uploads and resumable uploads have been disabled.',retryStatus:"Retrying upload for chunk # {chunk} for {filename}... retry # {retry}.",chunkQueueError:"Could not push task to ajax pool for chunk index # {index}.",resumableMaxRetriesReached:"Maximum resumable ajax retries ({n}) reached.",resumableRetryError:"Could not retry the resumable request (try # {n})... aborting.",resumableAborting:"Aborting / cancelling the resumable request.",resumableRequestError:"Error processing resumable request. {msg}"},objUrl:window.URL||window.webkitURL,getZoomPlaceholder:function(){var e=W.SCRIPT_SRC,t="?kvTemp__2873389129__=";return e?(e=e.substring(0,e.lastIndexOf("/"))).substring(0,e.lastIndexOf("/")+1)+"img/loading.gif"+t:t},defaultButtonCss:function(e){return"btn-default btn-"+(e?"":"outline-")+"secondary"},isBs:function(e){var t=W.trim((H.fn.fileinputBsVersion||"")+"");return e=parseInt(e,10),t?e===parseInt(t.charAt(0),10):4===e},isNumeric:function(e){return void 0!==e&&!isNaN(parseFloat(e))&&isFinite(e)},trim:function(e){return void 0===e?"":e.toString().trim()},now:function(){return(new Date).getTime()},round:function(e){return e=parseFloat(e),isNaN(e)?0:Math.floor(Math.round(e))},getArray:function(e){for(var t=[],i=e&&e.length||0,a=0;a<i;a++)t.push(e[a]);return t},getFileRelativePath:function(e){return String(e.newPath||e.relativePath||e.webkitRelativePath||W.getFileName(e)||null)},getFileId:function(e,t){var i=W.getFileRelativePath(e);return"function"==typeof t?t(e):e&&i?e.size+"_"+encodeURIComponent(i).replace(/%/g,"_"):null},getFrameSelector:function(e,t){return'[id="'+e+'"]'+(t=t||"")},getZoomSelector:function(e,t){return W.getFrameSelector("zoom-"+e,t)},getFrameElement:function(e,t,i){return e.find(W.getFrameSelector(t,i))},getZoomElement:function(e,t,i){return e.find(W.getZoomSelector(t,i))},getElapsed:function(e){var t=e,i="",a={},r={year:31536e3,month:2592e3,week:604800,day:86400,hour:3600,minute:60,second:1};return W.getObjectKeys(r).forEach(function(e){a[e]=Math.floor(t/r[e]),t-=a[e]*r[e]}),H.each(a,function(e,t){0<t&&(i+=(i?" ":"")+t+e.substring(0,1))}),i},debounce:function(i,a){var r;return function(){var e=arguments,t=this;clearTimeout(r),r=setTimeout(function(){i.apply(t,e)},a)}},stopEvent:function(e){e.stopPropagation(),e.preventDefault()},getFileName:function(e){return e&&(e.fileName||e.name)||""},createObjectURL:function(e){return W.objUrl&&W.objUrl.createObjectURL&&e?W.objUrl.createObjectURL(e):""},revokeObjectURL:function(e){W.objUrl&&W.objUrl.revokeObjectURL&&e&&W.objUrl.revokeObjectURL(e)},compare:function(e,t,i){return void 0!==e&&(i?e===t:e.match(t))},isIE:function(e){var t;return"Microsoft Internet Explorer"===navigator.appName&&(10===e?new RegExp("msie\\s"+e,"i").test(navigator.userAgent):((t=document.createElement("div")).innerHTML="\x3c!--[if IE "+e+"]> <i></i> <![endif]--\x3e",e=t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),e))},canOrientImage:function(e){var e=H(document.createElement("img")).css({width:"1px",height:"1px"}).insertAfter(e),t=e.css("image-orientation");return e.remove(),!!t},canAssignFilesToInput:function(){var e=document.createElement("input");try{return e.type="file",!(e.files=null)}catch(e){return!1}},getDragDropFolders:function(e){var t,i,a=e?e.length:0,r=0;if(0<a&&e[0].webkitGetAsEntry())for(t=0;t<a;t++)(i=e[t].webkitGetAsEntry())&&i.isDirectory&&r++;return r},initModal:function(e){var t=H("body");t.length&&e.appendTo(t)},isFunction:function(e){return"function"==typeof e},isEmpty:function(e,t){return null==e||""===e||(W.isString(e)&&t?""===W.trim(e):W.isArray(e)?0===e.length:!(!H.isPlainObject(e)||!H.isEmptyObject(e)))},isArray:function(e){return Array.isArray(e)||"[object Array]"===Object.prototype.toString.call(e)},isString:function(e){return"[object String]"===Object.prototype.toString.call(e)},ifSet:function(e,t,i){return i=i||"",t&&"object"==typeof t&&e in t?t[e]:i},cleanArray:function(e){return(e=e instanceof Array?e:[]).filter(function(e){return null!=e})},spliceArray:function(e,t,i){var a,r,n=0,o=[];if(!(e instanceof Array))return[];for(r=H.extend(!0,[],e),i&&r.reverse(),a=0;a<r.length;a++)a!==t&&(o[n]=r[a],n++);return i&&o.reverse(),o},getNum:function(e,t){return t=t||0,"number"!=typeof e&&("string"==typeof e&&(e=parseFloat(e)),isNaN(e))?t:e},hasFileAPISupport:function(){return!(!window.File||!window.FileReader)},hasDragDropSupport:function(){var e=document.createElement("div");return!W.isIE(9)&&(void 0!==e.draggable||void 0!==e.ondragstart&&void 0!==e.ondrop)},hasFileUploadSupport:function(){return W.hasFileAPISupport()&&window.FormData},hasBlobSupport:function(){try{return!!window.Blob&&Boolean(new Blob)}catch(e){return!1}},hasArrayBufferViewSupport:function(){try{return 100===new Blob([new Uint8Array(100)]).size}catch(e){return!1}},hasResumableUploadSupport:function(){return W.hasFileUploadSupport()&&W.hasBlobSupport()&&W.hasArrayBufferViewSupport()&&(!!Blob.prototype.webkitSlice||!!Blob.prototype.mozSlice||!!Blob.prototype.slice||!1)},dataURI2Blob:function(e){var t,i,a,r,n=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,o=W.hasBlobSupport();if(!((o||n)&&window.atob&&window.ArrayBuffer&&window.Uint8Array))return null;for(t=(0<=e.split(",")[0].indexOf("base64")?atob:decodeURIComponent)(e.split(",")[1]),i=new ArrayBuffer(t.length),a=new Uint8Array(i),r=0;r<t.length;r+=1)a[r]=t.charCodeAt(r);return e=e.split(",")[0].split(":")[1].split(";")[0],o?new Blob([W.hasArrayBufferViewSupport()?a:i],{type:e}):((o=new n).append(i),o.getBlob(e))},arrayBuffer2String:function(e){if(window.TextDecoder)return new TextDecoder("utf-8").decode(e);for(var t,i,a,r=Array.prototype.slice.apply(new Uint8Array(e)),n="",o=0,s=r.length;o<s;)switch((t=r[o++])>>4){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:n+=String.fromCharCode(t);break;case 12:case 13:i=r[o++],n+=String.fromCharCode((31&t)<<6|63&i);break;case 14:i=r[o++],a=r[o++],n+=String.fromCharCode((15&t)<<12|(63&i)<<6|(63&a)<<0)}return n},isSvg:function(e){return!W.isEmpty(e)&&0!==(e=W.trim(e).replace(/\n/g," ")).length&&e.match(/^\s*<\?xml/i)&&(e.match(/<!DOCTYPE svg/i)||e.match(/<svg/i))},getMimeType:function(e,t,i){var a=e||"";switch(a){case"ffd8ffe0":case"ffd8ffe1":case"ffd8ffe2":return"image/jpeg";case"89504e47":return"image/png";case"47494638":return"image/gif";case"49492a00":return"image/tiff";case"52494646":return"image/webp";case"41433130":return"image/vnd.dwg";case"66747970":return"video/3gp";case"4f676753":return"video/ogg";case"1a45dfa3":return"video/mkv";case"000001ba":case"000001b3":return"video/mpeg";case"3026b275":return"video/wmv";case"25504446":return"application/pdf";case"25215053":return"application/ps";case"504b0304":case"504b0506":case"504b0508":return"application/zip";case"377abcaf":return"application/7z";case"75737461":return"application/tar";case"7801730d":return"application/dmg";default:switch(a.substring(0,6)){case"435753":return"application/x-shockwave-flash";case"494433":return"audio/mp3";case"425a68":return"application/bzip";default:switch(a.substring(0,4)){case"424d":return"image/bmp";case"fffb":return"audio/mp3";case"4d5a":return"application/exe";case"1f9d":case"1fa0":return"application/zip";case"1f8b":return"application/gzip";default:return t&&!t.match(/[^\u0000-\u007f]/)?"application/text-plain":i}}}},addCss:function(e,t){e.removeClass(t).addClass(t)},getElement:function(e,t,i){return W.isEmpty(e)||W.isEmpty(e[t])?i:H(e[t])},createDiv:function(){return H(document.createElement("div"))},createElement:function(e,t){return H(H.parseHTML("<"+(t=t||"div")+">"+e+"</"+t+">"))},uniqId:function(){return((new Date).getTime()+Math.floor(Math.random()*Math.pow(10,15))).toString(36)},cspBuffer:{CSP_ATTRIB:"data-csp-01928735",domElementsStyles:{},stash:function(e){var n=this,t=H.parseHTML("<div>"+e+"</div>"),e=H(t);return e.find("[style]").each(function(e,t){var t=H(t),i=t[0].style,a=W.uniqId(),r={};i&&i.length&&(H(i).each(function(){r[this]=i[this]}),n.domElementsStyles[a]=r,t.removeAttr("style").attr(n.CSP_ATTRIB,a))}),e.filter("*").removeAttr("style"),(Object.values?Object.values(t):Object.keys(t).map(function(e){return t[e]})).flatMap(function(e){return e.innerHTML}).join("")},apply:function(e){var a=this;H(e).find("["+a.CSP_ATTRIB+"]").each(function(e,t){var t=H(t),i=t.attr(a.CSP_ATTRIB),i=a.domElementsStyles[i];i&&t.css(i),t.removeAttr(a.CSP_ATTRIB)}),a.domElementsStyles={}}},setHtml:function(e,t){var i=W.cspBuffer;return e.html(i.stash(t)),i.apply(e),e},htmlEncode:function(e,t){return void 0===e?t||null:e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")},replaceTags:function(e,t){var i=e;return t&&H.each(t,function(e,t){"function"==typeof t&&(t=t()),i=i.split(e).join(t)}),i},cleanMemory:function(e){e=(e.is("img")?e:e.find("source")).attr("src");W.revokeObjectURL(e)},findFileName:function(e){var t=e.lastIndexOf("/");return-1===t&&(t=e.lastIndexOf("\\")),e.split(e.substring(t,t+1)).pop()},checkFullScreen:function(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement},toggleFullScreen:function(e){var t=document,i=t.documentElement,a=W.checkFullScreen();i&&e&&!a?i.requestFullscreen?i.requestFullscreen():i.msRequestFullscreen?i.msRequestFullscreen():i.mozRequestFullScreen?i.mozRequestFullScreen():i.webkitRequestFullscreen&&i.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):a&&(t.exitFullscreen?t.exitFullscreen():t.msExitFullscreen?t.msExitFullscreen():t.mozCancelFullScreen?t.mozCancelFullScreen():t.webkitExitFullscreen&&t.webkitExitFullscreen())},moveArray:function(e,t,i,a){var r=H.extend(!0,[],e);if(a&&r.reverse(),i>=r.length)for(var n=i-r.length;1+n--;)r.push(void 0);return r.splice(i,0,r.splice(t,1)[0]),a&&r.reverse(),r},closeButton:function(e){return'<button type="button" class="'+(e=(W.isBs(5)?"btn-close":"close")+(e?" "+e:""))+'" aria-label="Close">\n'+(W.isBs(5)?"":'  <span aria-hidden="true">&times;</span>\n')+"</button>"},getRotation:function(e){switch(e){case 2:return"rotateY(180deg)";case 3:return"rotate(180deg)";case 4:return"rotate(180deg) rotateY(180deg)";case 5:return"rotate(270deg) rotateY(180deg)";case 6:return"rotate(90deg)";case 7:return"rotate(90deg) rotateY(180deg)";case 8:return"rotate(270deg)";default:return""}},setTransform:function(e,t){e&&(e.style.transform=t,e.style.webkitTransform=t,e.style["-moz-transform"]=t,e.style["-ms-transform"]=t,e.style["-o-transform"]=t)},getObjectKeys:function(e){var t=[];return e&&H.each(e,function(e){t.push(e)}),t},getObjectSize:function(e){return W.getObjectKeys(e).length},whenAll:function(e){for(var t,i,a,r=[].slice,n=1===arguments.length&&W.isArray(e)?e:r.call(arguments),o=H.Deferred(),s=0,l=n.length,d=l,c=i=a=Array(l),u=function(e,t,i){return function(){i!==n&&s++,o.notifyWith(t[e]=this,i[e]=r.call(arguments)),--d||o[(s?"reject":"resolve")+"With"](t,i)}},p=0;p<l;p++)(t=n[p])&&W.isFunction(t.promise)?t.promise().done(u(p,a,n)).fail(u(p,c,i)):(o.notifyWith(this,t),--d);return d||o.resolveWith(a,n),o.promise()}},(c=function(e,t){var i=this;i.$element=H(e),i.$parent=i.$element.parent(),i._validate()&&(i.isPreviewable=W.hasFileAPISupport(),i.isIE9=W.isIE(9),i.isIE10=W.isIE(10),(i.isPreviewable||i.isIE9)&&(i._init(t),i._listen()),i.$element.removeClass("file-loading"))}).prototype={constructor:c,_cleanup:function(){var e=this;e.reader=null,e.clearFileStack(),e.fileBatchCompleted=!0,e.isError=!1,e.isDuplicateError=!1,e.isPersistentError=!1,e.cancelling=!1,e.paused=!1,e.lastProgress=0,e._initAjax()},_isAborted:function(){return this.cancelling||this.paused},_initAjax:function(){var e=this,i=e.taskManager={pool:{},addPool:function(e){return i.pool[e]=new i.TasksPool(e)},getPool:function(e){return i.pool[e]},addTask:function(e,t){return new i.Task(e,t)},TasksPool:function(e){var c=this;c.id=e,c.cancelled=!1,c.cancelledDeferrer=H.Deferred(),c.tasks={},c.addTask=function(e,t){return c.tasks[e]=new i.Task(e,t)},c.size=function(){return W.getObjectSize(c.tasks)},c.run=function(e){var t,i,a,r,n=0,o=!1,s=W.getObjectKeys(c.tasks).map(function(e){return c.tasks[e]}),l=[],d=H.Deferred();if(c.cancelled)return c.cancelledDeferrer.resolve(),d.reject();if(e)for(i=function(e){H.when(e.deferred).fail(function(){o=!0,a.apply(null,arguments)}).always(a)},a=function(){var e=W.getArray(arguments);d.notify(e),l.push(e),c.cancelled?(d.reject.apply(null,l),c.cancelledDeferrer.resolve()):(l.length===c.size()&&(o?d.reject:d.resolve).apply(null,l),s.length&&(t=s.shift(),i(t),t.run()))};s.length&&n++<e;)t=s.shift(),i(t),t.run();else r=W.getObjectKeys(c.tasks).map(function(e){return c.tasks[e].deferred}),W.whenAll(r).done(function(){var e=W.getArray(arguments);c.cancelled?(d.reject.apply(null,e),c.cancelledDeferrer.resolve()):(d.resolve.apply(null,e),c.cancelledDeferrer.reject())}).fail(function(){var e=W.getArray(arguments);d.reject.apply(null,e),c.cancelled?c.cancelledDeferrer.resolve():c.cancelledDeferrer.reject()}),H.each(c.tasks,function(e){(t=c.tasks[e]).run()});return d},c.cancel=function(){return c.cancelled=!0,c.cancelledDeferrer}},Task:function(e,t){var i=this;i.id=e,i.deferred=H.Deferred(),i.logic=t,i.context=null,i.run=function(){var e=W.getArray(arguments);return e.unshift(i.deferred),t.apply(i.context,e),i.deferred},i.runWithContext=function(e){return i.context=e,i.run()}}};e.ajaxQueue=[],e.ajaxRequests=[],e.ajaxPool=null,e.ajaxAborted=!1},_init:function(e,t){var i,a,r=this,n=r.$element;r.options=e,r.zoomPlaceholder=W.getZoomPlaceholder(),r.canOrientImage=W.canOrientImage(n),H.each(e,function(e,t){switch(e){case"minFileCount":case"maxFileCount":case"maxTotalFileCount":case"minFileSize":case"maxFileSize":case"maxMultipleFileSize":case"maxFilePreviewSize":case"resizeQuality":case"resizeIfSizeMoreThan":case"progressUploadThreshold":case"initialPreviewCount":case"zoomModalHeight":case"minImageHeight":case"maxImageHeight":case"minImageWidth":case"maxImageWidth":case"bytesToKB":r[e]=W.getNum(t);break;default:r[e]=t}}),(!r.bytesToKB||r.bytesToKB<=0)&&(r.bytesToKB=1024),void 0===r.errorCloseButton&&(r.errorCloseButton=W.closeButton("kv-error-close"+(W.isBs(5)?"  float-end":""))),0<r.maxTotalFileCount&&r.maxTotalFileCount<r.maxFileCount&&(r.maxTotalFileCount=r.maxFileCount),r.rtl&&(a=r.previewZoomButtonIcons.prev,r.previewZoomButtonIcons.prev=r.previewZoomButtonIcons.next,r.previewZoomButtonIcons.next=a),!isNaN(r.maxAjaxThreads)&&r.maxAjaxThreads<r.resumableUploadOptions.maxThreads&&(r.resumableUploadOptions.maxThreads=r.maxAjaxThreads),r._initFileManager(),"function"==typeof r.autoOrientImage&&(r.autoOrientImage=r.autoOrientImage()),"function"==typeof r.autoOrientImageInitial&&(r.autoOrientImageInitial=r.autoOrientImageInitial()),t||r._cleanup(),r.duplicateErrors=[],r.$form=n.closest("form"),r._initTemplateDefaults(),r.uploadFileAttr=W.isEmpty(n.attr("name"))?"file_data":n.attr("name"),a=r._getLayoutTemplate("progress"),r.progressTemplate=a.replace("{class}",r.progressClass),r.progressInfoTemplate=a.replace("{class}",r.progressInfoClass),r.progressPauseTemplate=a.replace("{class}",r.progressPauseClass),r.progressCompleteTemplate=a.replace("{class}",r.progressCompleteClass),r.progressErrorTemplate=a.replace("{class}",r.progressErrorClass),r.isDisabled=n.attr("disabled")||n.attr("readonly"),r.isDisabled&&n.attr("disabled",!0),r.isClickable=r.browseOnZoneClick&&r.showPreview&&(r.dropZoneEnabled||!W.isEmpty(r.defaultPreviewContent)),r.isAjaxUpload=W.hasFileUploadSupport()&&!W.isEmpty(r.uploadUrl),r.dropZoneEnabled=W.hasDragDropSupport()&&r.dropZoneEnabled,r.isAjaxUpload||(r.dropZoneEnabled=r.dropZoneEnabled&&W.canAssignFilesToInput()),r.slug="function"==typeof e.slugCallback?e.slugCallback:r._slugDefault,r.mainTemplate=r.showCaption?r._getLayoutTemplate("main1"):r._getLayoutTemplate("main2"),r.captionTemplate=r._getLayoutTemplate("caption"),r.previewGenericTemplate=r._getPreviewTemplate("generic"),!r.imageCanvas&&r.resizeImage&&(r.maxImageWidth||r.maxImageHeight)&&(r.imageCanvas=document.createElement("canvas"),r.imageCanvasContext=r.imageCanvas.getContext("2d")),W.isEmpty(n.attr("id"))&&n.attr("id",W.uniqId()),r.namespace=".fileinput_"+n.attr("id").replace(/-/g,"_"),void 0===r.$container?r.$container=r._createContainer():r._refreshContainer(),a=r.$container,r.$dropZone=a.find(".file-drop-zone"),r.$progress=a.find(".kv-upload-progress"),r.$btnUpload=a.find(".fileinput-upload"),r.$captionContainer=W.getElement(e,"elCaptionContainer",a.find(".file-caption")),r.$caption=W.getElement(e,"elCaptionText",a.find(".file-caption-name")),W.isEmpty(r.msgPlaceholder)||(i=n.attr("multiple")?r.filePlural:r.fileSingle,r.$caption.attr("placeholder",r.msgPlaceholder.replace("{files}",i))),r.$captionIcon=r.$captionContainer.find(".file-caption-icon"),r.$previewContainer=W.getElement(e,"elPreviewContainer",a.find(".file-preview")),r.$preview=W.getElement(e,"elPreviewImage",a.find(".file-preview-thumbnails")),r.$previewStatus=W.getElement(e,"elPreviewStatus",a.find(".file-preview-status")),r.$errorContainer=W.getElement(e,"elErrorContainer",r.$previewContainer.find(".kv-fileinput-error")),r._validateDisabled(),W.isEmpty(r.msgErrorClass)||W.addCss(r.$errorContainer,r.msgErrorClass),t?r._errorsExist()||r.$errorContainer.hide():(r._resetErrors(),r.$errorContainer.hide(),r.previewInitId="thumb-"+n.attr("id"),r._initPreviewCache(),r._initPreview(!0),r._initPreviewActions(),r.$parent.hasClass("file-loading")&&(r.$container.insertBefore(r.$parent),r.$parent.remove())),r._setFileDropZoneTitle(),n.attr("disabled")&&r.disable(),r._initZoom(),r.hideThumbnailContent&&W.addCss(r.$preview,"hide-content")},_initFileManager:function(){var d=this;d.uploadStartTime=W.now(),d.fileManager={stack:{},filesProcessed:[],errors:[],loadedImages:{},totalImages:0,totalFiles:null,totalSize:null,uploadedSize:0,stats:{},bpsLog:[],bps:0,initStats:function(e){var t={started:W.now()};e?d.fileManager.stats[e]=t:d.fileManager.stats=t},getUploadStats:function(e,t,i){var n=d.fileManager,a=e?n.stats[e]&&n.stats[e].started||W.now():d.uploadStartTime,r=(W.now()-a)/1e3,o=Math.ceil(r?t/r:0),s=i-t,l=n.bpsLog.length?d.bitrateUpdateDelay:0;return setTimeout(function(){var e,t,i,a=0,r=0;for(n.bpsLog.push(o),n.bpsLog.sort(function(e,t){return e-t}),i=10<(t=n.bpsLog.length)?t-10:Math.ceil(t/2),e=t;i<e;e--)r=parseFloat(n.bpsLog[e]),a++;n.bps=64*(0<a?r/a:0)},l),l={fileId:e,started:a,elapsed:r,loaded:t,total:i,bps:n.bps,bitrate:d._getSize(n.bps,!1,d.bitRateUnits),pendingBytes:s},e?n.stats[e]=l:n.stats=l,l},exists:function(e){return-1!==H.inArray(e,d.fileManager.getIdList())},count:function(){return d.fileManager.getIdList().length},total:function(){var e=d.fileManager;return e.totalFiles||(e.totalFiles=e.count()),e.totalFiles},getTotalSize:function(){var i=d.fileManager;return i.totalSize||(i.totalSize=0,H.each(d.getFileStack(),function(e,t){t=parseFloat(t.size);i.totalSize+=isNaN(t)?0:t})),i.totalSize},add:function(e,t){(t=t||d.fileManager.getId(e))&&(d.fileManager.stack[t]={file:e,name:W.getFileName(e),relativePath:W.getFileRelativePath(e),size:e.size,nameFmt:d._getFileName(e,""),sizeFmt:d._getSize(e.size)})},remove:function(e){e=d._getThumbFileId(e);d.fileManager.removeFile(e)},removeFile:function(e){var t=d.fileManager;e&&(delete t.stack[e],delete t.loadedImages[e])},move:function(i,a){var r={},n=d.fileManager.stack;(i||a)&&i!==a&&(H.each(n,function(e,t){e!==i&&(r[e]=t),e===a&&(r[i]=n[i])}),d.fileManager.stack=r)},list:function(){var i=[];return H.each(d.getFileStack(),function(e,t){t&&t.file&&i.push(t.file)}),i},isPending:function(e){return-1===H.inArray(e,d.fileManager.filesProcessed)&&d.fileManager.exists(e)},isProcessed:function(){var t=!0,i=d.fileManager;return H.each(d.getFileStack(),function(e){i.isPending(e)&&(t=!1)}),t},clear:function(){var e=d.fileManager;d.isDuplicateError=!1,d.isPersistentError=!1,e.totalFiles=null,e.totalSize=null,e.uploadedSize=0,e.stack={},e.errors=[],e.filesProcessed=[],e.stats={},e.bpsLog=[],e.bps=0,e.clearImages()},clearImages:function(){d.fileManager.loadedImages={},d.fileManager.totalImages=0},addImage:function(e,t){d.fileManager.loadedImages[e]=t},removeImage:function(e){delete d.fileManager.loadedImages[e]},getImageIdList:function(){return W.getObjectKeys(d.fileManager.loadedImages)},getImageCount:function(){return d.fileManager.getImageIdList().length},getId:function(e){return d._getFileId(e)},getIndex:function(e){return d.fileManager.getIdList().indexOf(e)},getThumb:function(t){var i=null;return d._getThumbs().each(function(){var e=H(this);d._getThumbFileId(e)===t&&(i=e)}),i},getThumbIndex:function(e){e=d._getThumbFileId(e);return d.fileManager.getIndex(e)},getIdList:function(){return W.getObjectKeys(d.fileManager.stack)},getFile:function(e){return d.fileManager.stack[e]||null},getFileName:function(e,t){e=d.fileManager.getFile(e);return e?t?e.nameFmt||"":e.name||"":""},getFirstFile:function(){var e=d.fileManager.getIdList(),e=e&&e.length?e[0]:null;return d.fileManager.getFile(e)},setFile:function(e,t){d.fileManager.getFile(e)?d.fileManager.stack[e].file=t:d.fileManager.add(t,e)},setProcessed:function(e){d.fileManager.filesProcessed.push(e)},getProgress:function(){var e=d.fileManager.total(),t=d.fileManager.filesProcessed.length;return e?Math.ceil(t/e*100):0},setProgress:function(e,t){e=d.fileManager.getFile(e);!isNaN(t)&&e&&(e.progress=t)}}},_setUploadData:function(i,e){var a=this;H.each(e,function(e,t){e=a.uploadParamNames[e]||e;W.isArray(t)?i.append(e,t[0],t[1]):i.append(e,t)})},_initResumableUpload:function(){var m,g=this,h=g.resumableUploadOptions,v=W.logMessages,w=g.fileManager;g.enableResumableUpload&&(!1!==h.fallback&&"function"!=typeof h.fallback&&(h.fallback=function(e){e._log(v.noResumableSupport),e.enableResumableUpload=!1}),W.hasResumableUploadSupport()||!1===h.fallback?!g.uploadUrl&&g.enableResumableUpload?(g._log(v.noUploadUrl),g.enableResumableUpload=!1):(h.chunkSize=parseFloat(h.chunkSize),h.chunkSize<=0||isNaN(h.chunkSize)?(g._log(v.invalidChunkSize,{chunkSize:h.chunkSize}),g.enableResumableUpload=!1):(m=g.resumableManager={init:function(e,t,i){m.logs=[],m.stack=[],m.error="",m.id=e,m.file=t.file,m.fileName=t.name,m.fileIndex=i,m.completed=!1,m.lastProgress=0,g.showPreview&&(m.$thumb=w.getThumb(e)||null,m.$progress=m.$btnDelete=null,m.$thumb)&&m.$thumb.length&&(m.$progress=m.$thumb.find(".file-thumb-progress"),m.$btnDelete=m.$thumb.find(".kv-file-remove")),m.chunkSize=h.chunkSize*g.bytesToKB,m.chunkCount=m.getTotalChunks()},setAjaxError:function(e,t,i,a){e.responseJSON&&e.responseJSON.error&&(i=e.responseJSON.error.toString()),a||(m.error=i),h.showErrorLog&&g._log(v.ajaxError,{status:e.status,error:i,text:e.responseText||""})},reset:function(){m.stack=[],m.chunksProcessed={}},setProcessed:function(e){var t=m.id,i=m.$thumb,a=m.$progress,r=i&&i.length,n={id:r?i.attr("id"):"",index:w.getIndex(t),fileId:t},o=g.resumableUploadOptions.skipErrorsAndProceed;m.completed=!0,m.lastProgress=0,r&&i.removeClass("file-uploading"),"success"===e?(w.uploadedSize+=m.file.size,g.showPreview&&(g._setProgress(101,a),g._setThumbStatus(i,"Success"),g._initUploadSuccess(m.chunksProcessed[t].data,i)),w.removeFile(t),delete m.chunksProcessed[t],g._raise("fileuploaded",[n.id,n.index,n.fileId]),w.isProcessed()&&g._setProgress(101)):"cancel"!==e&&(g.showPreview&&(g._setThumbStatus(i,"Error"),g._setPreviewError(i,!0),g._setProgress(101,a,g.msgProgressError),g._setProgress(101,g.$progress,g.msgProgressError),g.cancelling=!o),g.$errorContainer.find('li[data-file-id="'+n.fileId+'"]').length||(r={file:m.fileName,max:h.maxRetries,error:m.error},e=g.msgResumableUploadRetriesExceeded.setTokens(r),H.extend(n,r),g._showFileError(e,n,"filemaxretries"),o&&(w.removeFile(t),delete m.chunksProcessed[t],w.isProcessed())&&g._setProgress(101))),w.isProcessed()&&m.reset()},check:function(){H.each(m.logs,function(e,t){if(!t)return!1})},processedResumables:function(){var e,t=m.logs,i=0;if(!t||!t.length)return 0;for(e=0;e<t.length;e++)!0===t[e]&&i++;return i},getUploadedSize:function(){var e=m.processedResumables()*m.chunkSize;return e>m.file.size?m.file.size:e},getTotalChunks:function(){var e=parseFloat(m.chunkSize);return!isNaN(e)&&0<e?Math.ceil(m.file.size/e):0},getProgress:function(){var e=m.processedResumables(),t=m.chunkCount;return 0===t?0:Math.ceil(e/t*100)},checkAborted:function(e){g._isAborted()&&(clearInterval(e),g.unlock())},upload:function(){var t=w.getIdList(),i="new",a=setInterval(function(){var e;m.checkAborted(a),"new"===i&&(g.lock(),i="processing",e=t.shift(),w.initStats(e),w.stack[e])&&(m.init(e,w.stack[e],w.getIndex(e)),m.processUpload()),!w.isPending(e)&&m.completed&&(i="new"),w.isProcessed()&&((e=g.$preview.find(".file-preview-initial")).length&&(W.addCss(e,W.SORT_CSS),g._initSortable()),clearInterval(a),g._clearFileInput(),g.unlock(),setTimeout(function(){var e=g.previewCache.data;e&&(g.initialPreview=e.content,g.initialPreviewConfig=e.config,g.initialPreviewThumbTags=e.tags),g._raise("filebatchuploadcomplete",[g.initialPreview,g.initialPreviewConfig,g.initialPreviewThumbTags,g._getExtraData()])},g.processDelay))},g.processDelay)},uploadResumable:function(){for(var e=g.taskManager,t=m.chunkCount,i=e.addPool(m.id),a=0;a<t;a++)m.logs[a]=!(!m.chunksProcessed[m.id]||!m.chunksProcessed[m.id][a]),m.logs[a]||m.pushAjax(a,0);i.run(h.maxThreads).done(function(){m.setProcessed("success")}).fail(function(){m.setProcessed(i.cancelled?"cancel":"error")})},processUpload:function(){var r,e,n,o=m.id;h.testUrl?(r=new FormData,e=w.stack[o],g._setUploadData(r,{fileId:o,fileName:e.fileName,fileSize:e.size,fileRelativePath:e.relativePath,chunkSize:m.chunkSize,chunkCount:m.chunkCount}),g._ajaxSubmit(function(e){n=g._getOutData(r,e),g._raise("filetestbeforesend",[o,w,m,n])},function(e,t,i){n=g._getOutData(r,i,e);var i=g.uploadParamNames.chunksUploaded||"chunksUploaded",a=[o,w,m,n];e[i]&&W.isArray(e[i])?(m.chunksProcessed[o]||(m.chunksProcessed[o]={}),H.each(e[i],function(e,t){m.logs[t]=!0,m.chunksProcessed[o][t]=!0}),m.chunksProcessed[o].data=e,g._raise("filetestsuccess",a)):g._raise("filetesterror",a),m.uploadResumable()},function(){g._raise("filetestcomplete",[o,w,m,g._getOutData(r)])},function(e,t,i){n=g._getOutData(r,e),g._raise("filetestajaxerror",[o,w,m,n]),m.setAjaxError(e,t,i,!0),m.uploadResumable()},r,o,m.fileIndex,h.testUrl)):m.uploadResumable()},pushAjax:function(e,t){var i=g.taskManager.getPool(m.id);i.addTask(i.size()+1,function(e){var t=m.stack.shift(),i=t[0];m.chunksProcessed[m.id]&&m.chunksProcessed[m.id][i]?g._log(v.chunkQueueError,{index:i}):m.sendAjax(i,t[1],e)}),m.stack.push([e,t])},sendAjax:function(r,n,o){function s(e,t){t&&(e=e.setTokens(t)),e=p.resumableRequestError.setTokens({msg:e}),g._log(e),o.reject(e)}var l,e,d,t,i=m.chunkSize,c=m.id,a=m.file,u=m.$thumb,p=W.logMessages,f=m.$btnDelete;m.chunksProcessed[c]&&m.chunksProcessed[c][r]||(n>h.maxRetries?(s(p.resumableMaxRetriesReached,{n:h.maxRetries}),m.setProcessed("error")):(e=a[a.slice?"slice":a.mozSlice?"mozSlice":a.webkitSlice?"webkitSlice":"slice"](i*r,i*(r+1)),d=new FormData,t=w.stack[c],g._setUploadData(d,{chunkCount:m.chunkCount,chunkIndex:r,chunkSize:i,chunkSizeStart:i*r,fileBlob:[e,m.fileName],fileId:c,fileName:m.fileName,fileRelativePath:t.relativePath,fileSize:a.size,retryCount:n}),m.$progress&&m.$progress.length&&m.$progress.show(),g._ajaxSubmit(function(e){l=g._getOutData(d,e),g.showPreview&&(u.hasClass("file-preview-success")||(g._setThumbStatus(u,"Loading"),W.addCss(u,"file-uploading")),f.attr("disabled",!0)),g._raise("filechunkbeforesend",[c,r,n,w,m,l])},function(e,t,i){var a;g._isAborted()?s(p.resumableAborting):(l=g._getOutData(d,i,e),i=g.uploadParamNames.chunkIndex||"chunkIndex",a=[c,r,n,w,m,l],e.error?(h.showErrorLog&&g._log(v.retryStatus,{retry:n+1,filename:m.fileName,chunk:r}),g._raise("filechunkerror",a),m.pushAjax(r,n+1),m.error=e.error,s(e.error)):(m.logs[e[i]]=!0,m.chunksProcessed[c]||(m.chunksProcessed[c]={}),m.chunksProcessed[c][e[i]]=!0,m.chunksProcessed[c].data=e,o.resolve.call(null,e),g._raise("filechunksuccess",a),m.check()))},function(){g._isAborted()||g._raise("filechunkcomplete",[c,r,n,w,m,g._getOutData(d)])},function(e,t,i){g._isAborted()?s(p.resumableAborting):(l=g._getOutData(d,e),m.setAjaxError(e,t,i),g._raise("filechunkajaxerror",[c,r,n,w,m,l]),m.pushAjax(r,n+1),s(p.resumableRetryError,{n:n-1}))},d,c,m.fileIndex)))}}).reset()):h.fallback(g))},_initTemplateDefaults:function(){function e(e,t){return'<object class="kv-preview-data file-preview-'+e+'" title="{caption}" data="{data}" type="'+t+'"'+s+">\n"+W.DEFAULT_PREVIEW+"\n</object>\n"}var i=this,t="btn btn-sm btn-kv "+W.defaultButtonCss(),a='{preview}\n<div class="kv-upload-progress kv-hidden"></div><div class="clearfix"></div>\n<div class="file-caption {class}">\n  <div class="input-group {inputGroupClass}">\n      {caption}\n<span class="file-caption-icon"></span>\n'+(W.isBs(5)?"":'<div class="input-group-btn input-group-append">\n')+"      {remove}\n      {cancel}\n      {pause}\n      {upload}\n      {browse}\n"+(W.isBs(5)?"":"    </div>\n")+"  </div>",r=W.closeButton("fileinput-remove"),n=W.MODAL_ID+"Label",o='<div id="'+W.MODAL_ID+'" class="file-zoom-dialog modal fade" aria-labelledby="'+n+'" {tabIndexConfig}></div>',n='<div class="modal-dialog modal-lg{rtl}" role="document">\n  <div class="modal-content">\n    <div class="modal-header kv-zoom-header">\n      <h6 class="modal-title kv-zoom-title" id="'+n+'"><span class="kv-zoom-caption"></span> <span class="kv-zoom-size"></span></h6>\n      <div class="kv-zoom-actions">{rotate}{toggleheader}{fullscreen}{borderless}{close}</div>\n    </div>\n    <div class="floating-buttons"></div>\n    <div class="kv-zoom-body file-zoom-content {zoomFrameClass}"></div>\n{prev} {next}\n    <div class="kv-zoom-description"></div>\n  </div>\n</div>\n',s=" {style}",l=e("html","text/html"),d=e("text","text/plain;charset=UTF-8"),c=e("pdf","application/pdf"),u='<img src="{data}" class="file-preview-image kv-preview-data" title="{title}" alt="{alt}"'+s+">\n",p='<iframe class="kv-preview-data file-preview-office" src="https://view.officeapps.live.com/op/embed.aspx?src={data}"'+s+"></iframe>",f='<iframe class="kv-preview-data file-preview-gdocs" src="https://docs.google.com/gview?url={data}&embedded=true"'+s+"></iframe>",m='<video class="kv-preview-data file-preview-video" controls'+s+'>\n<source src="{data}" type="{type}">\n'+W.DEFAULT_PREVIEW+"\n</video>\n",g='\x3c!--suppress ALL --\x3e<audio class="kv-preview-data file-preview-audio" controls'+s+'>\n<source src="{data}" type="{type}">\n'+W.DEFAULT_PREVIEW+"\n</audio>\n",h='<embed class="kv-preview-data file-preview-flash" src="{data}" type="application/x-shockwave-flash"'+s+">\n",v='<object class="kv-preview-data file-preview-object file-object {typeCss}" data="{data}" type="{type}"'+s+'>\n<param name="movie" value="{caption}" />\n'+W.OBJECT_PARAMS+" "+W.DEFAULT_PREVIEW+"\n</object>\n",w='<div class="kv-preview-data file-preview-other-frame"'+s+">\n"+W.DEFAULT_PREVIEW+"\n</div>\n",b={width:"100%",height:"100%","min-height":"480px"};i._isPdfRendered()&&(c=i.pdfRendererTemplate.replace("{renderer}",i._encodeURI(i.pdfRendererUrl))),i.defaults={layoutTemplates:{main1:a,main2:'{preview}\n<div class="kv-upload-progress kv-hidden"></div>\n<div class="clearfix"></div>\n<span class="{class}">{remove}\n{cancel}\n{upload}\n{browse}\n</span>',preview:'<div class="file-preview {class}">\n  {close}  <div class="{dropClass} clearfix">\n    <div class="file-preview-thumbnails clearfix">\n    </div>\n    <div class="file-preview-status text-center text-success"></div>\n    <div class="kv-fileinput-error"></div>\n  </div>\n</div>',close:r,fileIcon:'<i class="bi-file-earmark-arrow-up"></i>',caption:'<input readonly class="file-caption-name form-control {class}">\n',modalMain:o,modal:n,descriptionClose:'<button type="button" class="kv-desc-hide" aria-label="Close">{closeIcon}</button>',progress:'<div class="progress">\n    <div class="{class}" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">\n        {status}\n     </div>\n</div>{stats}',stats:'<div class="text-primary file-upload-stats"><span class="pending-time">{pendingTime}</span> <span class="upload-speed">{uploadSpeed}</span></div>',size:" <samp>({sizeText})</samp>",footer:'<div class="file-thumbnail-footer">\n    <div class="file-footer-caption" title="{caption}">\n        <div class="file-caption-info">{caption}</div>\n        <div class="file-size-info">{size}</div>\n    </div>\n    {progress}\n{indicator}\n{actions}\n</div>',indicator:'<div class="file-upload-indicator" title="{indicatorTitle}">{indicator}</div>',actions:'<div class="file-actions">\n    <div class="file-footer-buttons">\n        {rotate} {download} {upload} {delete} {zoom} {other}    </div>\n</div>\n{drag}\n<div class="clearfix"></div>',actionDelete:'<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}" {dataUrl}{dataKey}>{removeIcon}</button>\n',actionRotate:'<button type="button" class="kv-file-rotate {rotateClass}" title="{rotateTitle}">{rotateIcon}</button>',actionUpload:'<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">{uploadIcon}</button>',actionDownload:'<a class="kv-file-download {downloadClass}" title="{downloadTitle}" href="{downloadUrl}" download="{caption}" target="_blank">{downloadIcon}</a>',actionZoom:'<button type="button" class="kv-file-zoom {zoomClass}" title="{zoomTitle}">{zoomIcon}</button>',actionDrag:'<span class="file-drag-handle {dragClass}" title="{dragTitle}">{dragIcon}</span>',btnDefault:'<button type="{type}" title="{title}" class="{css}" {status} {tabIndexConfig}>{icon} {label}</button>',btnLink:'<a href="{href}" title="{title}" class="{css}" {status} {tabIndexConfig}>{icon} {label}</a>',btnBrowse:'<div class="{css}" {status} {tabIndexConfig}>{icon} {label}</div>',zoomCache:'<div class="kv-zoom-cache">{zoomContent}</div>'},previewMarkupTags:{tagBefore1:'<div class="file-preview-frame {frameClass}" id="{previewId}" data-fileindex="{fileindex}" data-fileid="{fileid}" data-filename="{filename}" data-template="{template}" data-zoom="{zoomData}"><div class="kv-file-content">\n',tagBefore2:'<div class="file-preview-frame {frameClass}" id="{previewId}" data-fileindex="{fileindex}" data-fileid="{fileid}" data-filename="{filename}" data-template="{template}" data-zoom="{zoomData}" title="{caption}"><div class="kv-file-content">\n',tagAfter:"</div>{footer}\n{zoomCache}</div>\n"},previewContentTemplates:{generic:"{content}\n",html:l,image:u,text:d,office:p,gdocs:f,video:m,audio:g,flash:h,object:v,pdf:c,other:w},allowedPreviewTypes:["image","html","text","video","audio","flash","pdf","object"],previewTemplates:{},previewSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"213px",height:"160px"},text:{width:"213px",height:"160px"},office:{width:"213px",height:"160px"},gdocs:{width:"213px",height:"160px"},video:{width:"213px",height:"160px"},audio:{width:"100%",height:"30px"},flash:{width:"213px",height:"160px"},object:{width:"213px",height:"160px"},pdf:{width:"100%",height:"160px",position:"relative"},other:{width:"213px",height:"160px"}},previewSettingsSmall:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"100%",height:"160px"},text:{width:"100%",height:"160px"},office:{width:"100%",height:"160px"},gdocs:{width:"100%",height:"160px"},video:{width:"100%",height:"auto"},audio:{width:"100%",height:"30px"},flash:{width:"100%",height:"auto"},object:{width:"100%",height:"auto"},pdf:{width:"100%",height:"160px"},other:{width:"100%",height:"160px"}},previewZoomSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:b,text:b,office:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},gdocs:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},video:{width:"auto",height:"100%","max-width":"100%"},audio:{width:"100%",height:"30px"},flash:{width:"auto",height:"480px"},object:{width:"auto",height:"100%","max-width":"100%","min-height":"480px"},pdf:b,other:{width:"auto",height:"100%","min-height":"480px"}},mimeTypeAliases:{"video/quicktime":"video/mp4"},fileTypeSettings:{image:function(e,t){return W.compare(e,"image.*")&&!W.compare(e,/(tiff?|wmf)$/i)||W.compare(t,/\.(gif|png|jpe?g)$/i)},html:function(e,t){return W.compare(e,"text/html")||W.compare(t,/\.(htm|html)$/i)},office:function(e,t){return W.compare(e,/(word|excel|powerpoint|office)$/i)||W.compare(t,/\.(docx?|xlsx?|pptx?|pps|potx?)$/i)},gdocs:function(e,t){return W.compare(e,/(word|excel|powerpoint|office|iwork-pages|tiff?)$/i)||W.compare(t,/\.(docx?|xlsx?|pptx?|pps|potx?|rtf|ods|odt|pages|ai|dxf|ttf|tiff?|wmf|e?ps)$/i)},text:function(e,t){return W.compare(e,"text.*")||W.compare(t,/\.(xml|javascript)$/i)||W.compare(t,/\.(txt|md|nfo|ini|json|php|js|css)$/i)},video:function(e,t){return W.compare(e,"video.*")&&(W.compare(e,/(ogg|mp4|mp?g|mov|webm|3gp)$/i)||W.compare(t,/\.(og?|mp4|webm|mp?g|mov|3gp)$/i))},audio:function(e,t){return W.compare(e,"audio.*")&&(W.compare(t,/(ogg|mp3|mp?g|wav)$/i)||W.compare(t,/\.(og?|mp3|mp?g|wav)$/i))},flash:function(e,t){return W.compare(e,"application/x-shockwave-flash",!0)||W.compare(t,/\.(swf)$/i)},pdf:function(e,t){return W.compare(e,"application/pdf",!0)||W.compare(t,/\.(pdf)$/i)},object:function(){return!0},other:function(){return!0}},fileActionSettings:{showRemove:!0,showUpload:!0,showDownload:!0,showZoom:!0,showDrag:!0,showRotate:!0,removeIcon:'<i class="bi-trash"></i>',removeClass:t,removeErrorClass:"btn btn-sm btn-kv btn-danger",removeTitle:"Remove file",uploadIcon:'<i class="bi-upload"></i>',uploadClass:t,uploadTitle:"Upload file",uploadRetryIcon:'<i class="bi-cloud-arrow-up-fill"></i>',uploadRetryTitle:"Retry upload",downloadIcon:'<i class="bi-download"></i>',downloadClass:t,downloadTitle:"Download file",rotateIcon:'<i class="bi-arrow-clockwise"></i>',rotateClass:t,rotateTitle:"Rotate 90 deg. clockwise",zoomIcon:'<i class="bi-zoom-in"></i>',zoomClass:t,zoomTitle:"View Details",dragIcon:'<i class="bi-arrows-move"></i>',dragClass:"text-primary",dragTitle:"Move / Rearrange",dragSettings:{},indicatorNew:'<i class="bi-plus-lg text-warning"></i>',indicatorSuccess:'<i class="bi-check-lg text-success"></i>',indicatorError:'<i class="bi-exclamation-lg text-danger"></i>',indicatorLoading:'<i class="bi-hourglass-bottom text-muted"></i>',indicatorPaused:'<i class="bi-pause-fill text-primary"></i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading &hellip;",indicatorPausedTitle:"Upload Paused"}},H.each(i.defaults,function(e,t){"allowedPreviewTypes"===e?void 0===i.allowedPreviewTypes&&(i.allowedPreviewTypes=t):i[e]=H.extend(!0,{},t,i[e])}),i._initPreviewTemplates()},_initPreviewTemplates:function(){var i,a=this,r=a.previewMarkupTags,n=r.tagAfter;H.each(a.previewContentTemplates,function(e,t){W.isEmpty(a.previewTemplates[e])&&(i=r.tagBefore2,"generic"!==e&&"image"!==e||(i=r.tagBefore1),a._isPdfRendered()&&"pdf"===e&&(i=i.replace("kv-file-content","kv-file-content kv-pdf-rendered")),a.previewTemplates[e]=i+t+n)})},_initPreviewCache:function(){var m=this;m.previewCache={data:{},init:function(){var e=m.initialPreview;0<e.length&&!W.isArray(e)&&(e=e.split(m.initialPreviewDelimiter)),m.previewCache.data={content:e,config:m.initialPreviewConfig,tags:m.initialPreviewThumbTags}},count:function(e){return m.previewCache.data&&m.previewCache.data.content?(e?m.previewCache.data.content.filter(function(e){return null!==e}):m.previewCache.data.content).length:0},get:function(e,t){function i(e,t,i,a,r,n,o,s){var o=" file-preview-initial "+W.SORT_CSS+(o?" "+o:""),l=m.previewInitId+"-"+n,d=c&&c.fileId||l;return m._generatePreviewTemplate(e,t,i,a,l,d,!1,null,null,o,r,n,s,p,c&&c.zoomData||t)}var a,r,n,o,s=W.INIT_FLAG+e,l=m.previewCache.data,c=l.config[e],d=l.content[e],u=W.ifSet("previewAsData",c,m.initialPreviewAsData),p=c?{title:c.title||null,alt:c.alt||null}:{title:null,alt:null};return d&&d.length?(t=void 0===t||t,a=W.ifSet("type",c,m.initialPreviewFileType||"generic"),r=W.ifSet("filename",c,W.ifSet("caption",c)),n=W.ifSet("filetype",c,a),t=m.previewCache.footer(e,t,c&&c.size||null),o=W.ifSet("frameClass",c),u=u?i(a,d,r,n,t,s,o):i("generic",d,r,n,t,s,o,a).setTokens({content:l.content[e]}),l.tags.length&&l.tags[e]&&(u=W.replaceTags(u,l.tags[e])),W.isEmpty(c)||W.isEmpty(c.frameAttr)||(d=W.createDiv(),W.setHtml(d,u),d.find(".file-preview-initial").attr(c.frameAttr),u=d.html(),d.remove()),u):""},clean:function(e){e.content=W.cleanArray(e.content),e.config=W.cleanArray(e.config),e.tags=W.cleanArray(e.tags),m.previewCache.data=e},add:function(e,t,i,a){var r,n=m.previewCache.data;return e&&e.length?(r=e.length-1,W.isArray(e)||(e=e.split(m.initialPreviewDelimiter)),a&&n.content?(r=n.content.push(e[0])-1,n.config[r]=t,n.tags[r]=i):(n.content=e,n.config=t,n.tags=i),m.previewCache.clean(n),r):0},set:function(e,t,i,a){var r,n=m.previewCache.data;if(e&&e.length&&(e=W.isArray(e)?e:e.split(m.initialPreviewDelimiter)).filter(function(e){return null!==e}).length){if(void 0===n.content&&(n.content=[]),void 0===n.config&&(n.config=[]),void 0===n.tags&&(n.tags=[]),a){for(r=0;r<e.length;r++)e[r]&&n.content.push(e[r]);for(r=0;r<t.length;r++)t[r]&&n.config.push(t[r]);for(r=0;r<i.length;r++)i[r]&&n.tags.push(i[r])}else n.content=e,n.config=t,n.tags=i;m.previewCache.clean(n)}},unset:function(e){var t=m.previewCache.count(),i=m.reversePreviewOrder;t&&(1===t?(m.previewCache.data.content=[],m.previewCache.data.config=[],m.previewCache.data.tags=[],m.initialPreview=[],m.initialPreviewConfig=[],m.initialPreviewThumbTags=[]):(m.previewCache.data.content=W.spliceArray(m.previewCache.data.content,e,i),m.previewCache.data.config=W.spliceArray(m.previewCache.data.config,e,i),m.previewCache.data.tags=W.spliceArray(m.previewCache.data.tags,e,i),t=H.extend(!0,{},m.previewCache.data),m.previewCache.clean(t)))},out:function(){var e,t,i="",a=m.previewCache.count();if(0===a)return{content:"",caption:""};for(e=0;e<a;e++)t=m.previewCache.get(e),i=m.reversePreviewOrder?t+i:i+t;return{content:i,caption:m._getMsgSelected(a)}},footer:function(e,t,i){var a=m.previewCache.data||{};if(W.isEmpty(a.content))return"";(W.isEmpty(a.config)||W.isEmpty(a.config[e]))&&(a.config[e]={}),t=void 0===t||t;var a=a.config[e],e=W.ifSet("caption",a),r=W.ifSet("width",a,"auto"),n=W.ifSet("url",a,!1),o=W.ifSet("key",a,null),s=W.ifSet("fileId",a,null),l=m.fileActionSettings,d=m.initialPreviewShowDelete||!1,s=m.initialPreviewDownloadUrl?m.initialPreviewDownloadUrl+"?key="+o+(s?"&fileId="+s:""):"",s=a.downloadUrl||s,c=a.filename||a.caption||"",u=!!s,d=W.ifSet("showRemove",a,d),p=W.ifSet("showRotate",a,W.ifSet("showRotate",l,!0)),u=W.ifSet("showDownload",a,W.ifSet("showDownload",l,u)),f=W.ifSet("showZoom",a,W.ifSet("showZoom",l,!0)),l=W.ifSet("showDrag",a,W.ifSet("showDrag",l,!0)),u=u&&!1!==a.downloadUrl&&!!s,a=m._renderFileActions(a,!1,u,d,p,f,l,!1===n&&t,n,o,!0,s,c);return m._getLayoutTemplate("footer").setTokens({progress:m._renderThumbProgress(),actions:a,caption:e,size:m._getSize(i),width:r,indicator:""})}},m.previewCache.init()},_isPdfRendered:function(){var e=this.usePdfRenderer;return("function"==typeof e?e():!!e)&&this.pdfRendererUrl},_handler:function(e,t,i){var a=this.namespace,t=t.split(" ").join(a+" ")+a;e&&e.length&&e.off(t).on(t,i)},_encodeURI:function(e){return this.encodeUrl?encodeURI(e):e},_log:function(e,t){var i=this.$element.attr("id");this.showConsoleLogs&&(e="bootstrap-fileinput: "+(e=i?'"'+i+'": '+e:e),"object"==typeof t&&(e=e.setTokens(t)),window.console&&void 0!==window.console.log?window.console.log(e):window.alert(e))},_validate:function(){var e="file"===this.$element.attr("type");return e||this._log(W.logMessages.badInputType),e},_errorsExist:function(){var e;return!!this.$errorContainer.find("li").length||(e=W.createDiv(),W.setHtml(e,this.$errorContainer.html()),e.find(".kv-error-close").remove(),e.find("ul").remove(),!!W.trim(e.text()).length)},_errorHandler:function(e,t){function i(e){a._showError(e.replace("{name}",t))}var a=this,e=e.target.error;e.code===e.NOT_FOUND_ERR?i(a.msgFileNotFound):i(e.code===e.SECURITY_ERR?a.msgFileSecured:e.code===e.NOT_READABLE_ERR?a.msgFileNotReadable:e.code===e.ABORT_ERR?a.msgFilePreviewAborted:a.msgFilePreviewError)},_addError:function(e){var t=this,i=t.$errorContainer;e&&i.length&&(W.setHtml(i,t.errorCloseButton+e),t._handler(i.find(".kv-error-close"),"click",function(){setTimeout(function(){t.showPreview&&!t.getFrames().length&&t.clear(),i.fadeOut("slow")},t.processDelay)}))},_setValidationError:function(e){this.$container.removeClass(e=(e?e+" ":"")+"has-error").addClass("has-error"),W.addCss(this.$caption,"is-invalid")},_resetErrors:function(e){var t=this,i=t.$errorContainer,a=t.resumableUploadOptions.retainErrorHistory;t.isPersistentError||t.enableResumableUpload&&a&&!t.clearInput||(t.clearInput=!1,t.isError=!1,t.$container.removeClass("has-error"),t.$caption.removeClass("is-invalid is-valid file-processing"),i.html(""),e?i.fadeOut("slow"):i.hide())},_showFolderError:function(e){var t,i=this,a=i.$errorContainer;e&&(i.isAjaxUpload||i._clearFileInput(),t=i.msgFoldersNotAllowed.replace("{n}",e),i._addError(t),i._setValidationError(),a.fadeIn(i.fadeDelay),i._raise("filefoldererror",[e,t]))},showUserError:function(e,t,i){var a,r=this;r.uploadInitiated&&(t&&t.fileId?(i||r.$errorContainer.find('[data-file-id="'+t.fileId+'"]').remove(),(a=r.fileManager.getFileName(t.fileId))&&(e="<b>"+a+":</b> "+e)):i||r.$errorContainer.html(""),r._showFileError(e,t,"fileusererror"))},_showFileError:function(e,t,i){var a=this,r=a.$errorContainer,i=i||"fileuploaderror",n=t&&t.fileId||"",n=t&&t.id?'<li data-thumb-id="'+t.id+'" data-file-id="'+n+'">'+e+"</li>":"<li>"+e+"</li>";return 0===r.find("ul").length?a._addError("<ul>"+n+"</ul>"):(r.find("ul").append(W.cspBuffer.stash(n)),W.cspBuffer.apply(r)),r.fadeIn(a.fadeDelay),a._raise(i,[t,e]),a._setValidationError("file-input-new"),!0},_showError:function(e,t,i){var a=this,r=a.$errorContainer,i=i||"fileerror";return(t=t||{}).reader=a.reader,a._addError(e),r.fadeIn(a.fadeDelay),a._raise(i,[t,e]),a.isAjaxUpload||a._clearFileInput(),a._setValidationError("file-input-new"),a.$btnUpload.attr("disabled",!0),!0},_noFilesError:function(e){var t=this,i=1<t.minFileCount?t.filePlural:t.fileSingle,i=t.msgFilesTooLess.replace("{n}",t.minFileCount).replace("{files}",i),a=t.$errorContainer,i="<li>"+i+"</li>";0===a.find("ul").length?t._addError("<ul>"+i+"</ul>"):a.find("ul").append(i),t.isError=!0,t._updateFileDetails(0),a.fadeIn(t.fadeDelay),t._raise("fileerror",[e,i]),t._clearFileInput(),t._setValidationError()},_parseError:function(e,t,i,a){var r=this,i=W.trim(i+""),n=t.responseJSON&&t.responseJSON.error?t.responseJSON.error.toString():"",t=n||t.responseText;return r.cancelling&&r.msgUploadAborted&&(i=r.msgUploadAborted),r.showAjaxErrorDetails&&t&&(n?i=W.trim(n+""):(n=(t=W.trim(t.replace(/\n\s*\n/g,"\n"))).length?"<pre>"+t+"</pre>":"",i+=i?n:t)),i=i||r.msgAjaxError.replace("{operation}",e),r.cancelling=!1,a?"<b>"+a+": </b>"+i:i},_parseFileType:function(e,t){var i,a,r=this.allowedPreviewTypes||[];if("application/text-plain"===e)return"text";for(a=0;a<r.length;a++)if(i=r[a],i=(0,this.fileTypeSettings[i])(e,t)?i:"",!W.isEmpty(i))return i;return"other"},_getPreviewIcon:function(e){var i,a=this,r=null;return e&&-1<e.indexOf(".")&&(i=e.split(".").pop(),a.previewFileIconSettings&&(r=a.previewFileIconSettings[i]||a.previewFileIconSettings[i.toLowerCase()]||null),a.previewFileExtSettings)&&H.each(a.previewFileExtSettings,function(e,t){a.previewFileIconSettings[e]&&t(i)&&(r=a.previewFileIconSettings[e])}),r||a.previewFileIcon},_parseFilePreviewIcon:function(e,t){t=this._getPreviewIcon(t);return e=-1<e.indexOf("{previewFileIcon}")?e.setTokens({previewFileIconClass:this.previewFileIconClass,previewFileIcon:t}):e},_raise:function(e,t){var i=this,a=H.Event(e),r=(void 0!==t?i.$element.trigger(a,t):i.$element.trigger(a),a.result),t=!1===r;if(a.isDefaultPrevented()||t)return!1;if("filebatchpreupload"===a.type&&(r||t))return i.ajaxAborted=r,!1;switch(e){case"filebatchuploadcomplete":case"filebatchuploadsuccess":case"fileuploaded":case"fileclear":case"filecleared":case"filereset":case"fileerror":case"filefoldererror":case"filecustomerror":case"filesuccessremove":break;default:i.ajaxAborted||(i.ajaxAborted=r)}return!0},_listenFullScreen:function(e){var t,i,a=this.$modal;a&&a.length&&(t=a&&a.find(".btn-kv-fullscreen"),i=a&&a.find(".btn-kv-borderless"),t.length)&&i.length&&(t.removeClass("active").attr("aria-pressed","false"),i.removeClass("active").attr("aria-pressed","false"),(e?t:i).addClass("active").attr("aria-pressed","true"),a.hasClass("file-zoom-fullscreen")||e?this._maximizeZoomDialog():i.removeClass("active").attr("aria-pressed","false"))},_listen:function(){var t=this,i=t.$element,e=t.$form,a=t.$container;t._handler(i,"click",function(e){t._initFileSelected(),i.hasClass("file-no-browse")&&(i.data("zoneClicked")?i.data("zoneClicked",!1):e.preventDefault())}),t._handler(i,"change",H.proxy(t._change,t)),t._handler(t.$caption,"paste",H.proxy(t.paste,t)),t.showBrowse&&(t._handler(t.$btnFile,"click",H.proxy(t._browse,t)),t._handler(t.$btnFile,"keypress",function(e){13===(e.keyCode||e.which)&&(i.trigger("click"),t._browse(e))})),t._handler(a.find(".fileinput-remove:not([disabled])"),"click",H.proxy(t.clear,t)),t._handler(a.find(".fileinput-cancel"),"click",H.proxy(t.cancel,t)),t._handler(a.find(".fileinput-pause"),"click",H.proxy(t.pause,t)),t._initDragDrop(),t._handler(e,"reset",H.proxy(t.clear,t)),t.isAjaxUpload||t._handler(e,"submit",H.proxy(t._submitForm,t)),t._handler(t.$container.find(".fileinput-upload"),"click",H.proxy(t._uploadClick,t)),t._handler(H(window),"resize",function(){t._listenFullScreen(screen.width===window.innerWidth&&screen.height===window.innerHeight)}),t._handler(H(document),"webkitfullscreenchange mozfullscreenchange fullscreenchange MSFullscreenChange",function(){t._listenFullScreen(W.checkFullScreen())}),t.$caption.on("focus",function(){t.$captionContainer.focus()}),t._autoFitContent(),t._initClickable(),t._refreshPreview()},_autoFitContent:function(){var i,e=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,a=this,e=e<400?a.previewSettingsSmall||a.defaults.previewSettingsSmall:a.previewSettings||a.defaults.previewSettings;H.each(e,function(e,t){i=".file-preview-frame .file-preview-"+e,a.$preview.find(i+".kv-preview-data,"+i+" .kv-preview-data").css(t)})},_scanDroppedItems:function(t,i,a){a=a||"";var r,e,n,o=this,s=function(e){o._log(W.logMessages.badDroppedFiles),o._log(e)};t.isFile?t.file(function(e){a&&(e.newPath=a+e.name),i.push(e)},s):t.isDirectory&&(e=t.createReader(),(n=function(){e.readEntries(function(e){if(e&&0<e.length){for(r=0;r<e.length;r++)o._scanDroppedItems(e[r],i,a+t.name+"/");n()}return null},s)})())},_initDragDrop:function(){var e=this,t=e.$dropZone;e.dropZoneEnabled&&e.showPreview&&(e._handler(t,"dragenter dragover",H.proxy(e._zoneDragEnter,e)),e._handler(t,"dragleave",H.proxy(e._zoneDragLeave,e)),e._handler(t,"drop",H.proxy(e._zoneDrop,e)),e._handler(H(document),"dragenter dragover drop",e._zoneDragDropInit))},_zoneDragDropInit:function(e){e.stopPropagation(),e.preventDefault()},_zoneDragEnter:function(e){var t=e.originalEvent.dataTransfer,i=-1<H.inArray("Files",t.types);this._zoneDragDropInit(e),this.isDisabled||!i?(t.effectAllowed="none",t.dropEffect="none"):(t.dropEffect="copy",this._raise("fileDragEnter",{sourceEvent:e,files:t.types.Files})&&W.addCss(this.$dropZone,"file-highlighted"))},_zoneDragLeave:function(e){this._zoneDragDropInit(e),this.isDisabled||this._raise("fileDragLeave",{sourceEvent:e})&&this.$dropZone.removeClass("file-highlighted")},_dropFiles:function(e,t){var i=this,a=i.$element;i.isAjaxUpload?i._change(e,t):(i.changeTriggered=!0,a.get(0).files=t,setTimeout(function(){i.changeTriggered=!1,a.trigger("change"+i.namespace)},i.processDelay)),i.$dropZone.removeClass("file-highlighted")},_addFilesFromSystem:function(e,t,i){var a,r=this,n=t.files,o=t.items,t=W.getDragDropFolders(o);if(e.preventDefault(),r.isDisabled||W.isEmpty(n)||!n.length)console.log("No valid copied files found in clipboard for pasting.");else if(r._raise(i,{sourceEvent:e,files:n}))if(0<t)if(r.isAjaxUpload){for(n=[],a=0;a<o.length;a++){var s=o[a].webkitGetAsEntry();s&&r._scanDroppedItems(s,n)}setTimeout(function(){r._dropFiles(e,n)},500)}else r._showFolderError(t);else r._dropFiles(e,n)},_zoneDrop:function(e){this.$element;var t=e.originalEvent.dataTransfer;this._addFilesFromSystem(e,t,"fileDragDrop")},_uploadClick:function(e){var t=this.$container.find(".fileinput-upload"),i=!t.hasClass("disabled")&&W.isEmpty(t.attr("disabled"));e&&e.isDefaultPrevented()||(this.isAjaxUpload?(e.preventDefault(),i&&this.upload()):i&&"submit"!==t.attr("type")&&(e.preventDefault(),(i=t.closest("form")).length)&&i.trigger("submit"))},_submitForm:function(){return this._isFileSelectionValid()&&!this._abort({})},_clearPreview:function(){var e=this;(e.showUploadedThumbs?e.getFrames(":not(.file-preview-success)"):e.getFrames()).each(function(){H(this).remove()}),e.getFrames().length&&e.showPreview||e._resetUpload(),e._validateDefaultPreview()},_initSortable:function(){var e,l=this,t=l.$preview,i="."+W.SORT_CSS,a=H("body"),r=H("html"),d=l.reversePreviewOrder,n=window.Sortable;n&&0!==t.find(i).length&&(e=a.length?a:r.length?r:l.$container,H.extend(!0,i={handle:".drag-handle-init",dataIdAttr:"data-fileid",animation:600,draggable:i,scroll:!(a=function(){e.removeClass("file-grabbing")}),forceFallback:!0,onChoose:r=function(){e.addClass("file-grabbing")},onStart:r,onUnchoose:a,onEnd:a,onSort:function(e){var t,i=e.oldIndex,a=e.newIndex,r=0,n=l.initialPreviewConfig.length,o=0<n&&n<=a,s=H(e.item);l.initialPreview=W.moveArray(l.initialPreview,i,a=o?n-1:a,d),l.initialPreviewConfig=W.moveArray(l.initialPreviewConfig,i,a,d),l.previewCache.init(),l.getFrames(".file-preview-initial").each(function(){H(this).attr("data-fileindex",W.INIT_FLAG+r),r++}),o&&(t=l.getFrames(":not(.file-preview-initial):first")).length&&s.slideUp(function(){s.insertBefore(t).slideDown()}),l._raise("filesorted",{previewId:s.attr("id"),oldIndex:i,newIndex:a,stack:l.initialPreviewConfig})}},l.fileActionSettings.dragSettings),l.sortable&&l.sortable.destroy(),l.sortable=n.create(t[0],i))},_setPreviewContent:function(e){W.setHtml(this.$preview,e),this._autoFitContent()},_initPreviewImageOrientations:function(){var r=this,n=0,o=r.canOrientImage;(r.autoOrientImageInitial||o)&&r.getFrames(".file-preview-initial").each(function(){var e,t,i=H(this),a=r.initialPreviewConfig[n];a&&a.exif&&a.exif.Orientation&&(t=i.attr("id"),e=i.find(">.kv-file-content img"),t=r._getZoom(t," >.kv-file-content img"),o?e.css("image-orientation",r.autoOrientImageInitial?"from-image":"none"):r.setImageOrientation(e,t,a.exif.Orientation,i)),n++})},_initPreview:function(e){var t,i=this,a=i.initialCaption||"";i.previewCache.count(!0)?(t=i.previewCache.out(),a=e&&i.initialCaption?i.initialCaption:t.caption,i._setPreviewContent(t.content),i._setInitThumbAttr(),i._setCaption(a),i._initSortable(),W.isEmpty(t.content)||i.$container.removeClass("file-input-new"),i._initPreviewImageOrientations()):(i._clearPreview(),e?i._setCaption(a):i._initCaption())},_getZoomButton:function(e){var t=this.previewZoomButtonIcons[e],i=this.previewZoomButtonClasses[e],a=' title="'+(this.previewZoomButtonTitles[e]||"")+'" ',r=W.isBs(5)?"bs-":"",a=a+("close"===e?" data-"+r+'dismiss="modal" aria-hidden="true"':"");return"fullscreen"!==e&&"borderless"!==e&&"toggleheader"!==e||(a+=' data-toggle="button" aria-pressed="false"'),'<button type="button" class="'+i+" btn-kv-"+e+'"'+a+">"+t+"</button>"},_getModalContent:function(){var e=this;return e._getLayoutTemplate("modal").setTokens({rtl:e.rtl?" kv-rtl":"",zoomFrameClass:e.frameClass,prev:e._getZoomButton("prev"),next:e._getZoomButton("next"),rotate:e._getZoomButton("rotate"),toggleheader:e._getZoomButton("toggleheader"),fullscreen:e._getZoomButton("fullscreen"),borderless:e._getZoomButton("borderless"),close:e._getZoomButton("close")})},_listenModalEvent:function(a){var r=this,n=r.$modal;n.on(a+".bs.modal",function(e){var t,i;"bs.modal"===e.namespace&&("hide"==a&&n.data("angle",0),t=n.find(".btn-fullscreen"),i=n.find(".btn-borderless"),n.data("fileinputPluginId")===r.$element.attr("id")&&r._raise("filezoom"+a,{sourceEvent:e,previewId:n.data("previewId"),modal:n}),"shown"===a)&&(r._handleRotation(n,n.find(".file-zoom-detail"),n.data("angle")),i.removeClass("active").attr("aria-pressed","false"),t.removeClass("active").attr("aria-pressed","false"),n.hasClass("file-zoom-fullscreen"))&&(r._maximizeZoomDialog(),(W.checkFullScreen()?t:i).addClass("active").attr("aria-pressed","true"))})},_initZoom:function(){var i=this,e=i._getLayoutTemplate("modalMain"),t="#"+W.MODAL_ID,e=i._setTabIndex("modal",e);i.showPreview&&(i.$modal=H(t),i.$modal&&i.$modal.length||(e=W.createElement(W.cspBuffer.stash(e)).insertAfter(i.$container),i.$modal=H(t).insertBefore(e),W.cspBuffer.apply(i.$modal),e.remove()),W.initModal(i.$modal),i.$modal.html(W.cspBuffer.stash(i._getModalContent())),W.cspBuffer.apply(i.$modal),H.each(W.MODAL_EVENTS,function(e,t){i._listenModalEvent(t)}))},_initZoomButtons:function(){var e=this.$modal,t=e.data("previewId")||"",i=this.getFrames().toArray(),a=i.length,r=e.find(".btn-kv-prev"),n=e.find(".btn-kv-next");e.find(".btn-kv-rotate");i.length<2?(r.hide(),n.hide()):(r.show(),n.show(),a&&(e=H(i[0]),i=H(i[a-1]),r.removeAttr("disabled"),n.removeAttr("disabled"),this.reversePreviewOrder&&([r,n]=[n,r]),e.length&&e.attr("id")===t&&r.attr("disabled",!0),i.length)&&i.attr("id")===t&&n.attr("disabled",!0))},_maximizeZoomDialog:function(){var e=this.$modal,t=e.find(".modal-header:visible"),i=e.find(".modal-footer:visible"),a=e.find(".kv-zoom-body"),r=H(window).height();e.addClass("file-zoom-fullscreen"),t&&t.length&&(r-=t.outerHeight(!0)),i&&i.length&&(r-=i.outerHeight(!0)),a&&a.length&&(r-=a.outerHeight(!0)-a.height()),e.find(".kv-zoom-body").height(r)},_resizeZoomDialog:function(e){var t=this,i=t.$modal,a=i.find(".btn-kv-fullscreen"),r=i.find(".btn-kv-borderless");if(i.hasClass("file-zoom-fullscreen"))W.toggleFullScreen(!1),e?a.hasClass("active")||(i.removeClass("file-zoom-fullscreen"),t._resizeZoomDialog(!0),r.hasClass("active")&&r.removeClass("active").attr("aria-pressed","false")):a.hasClass("active")?a.removeClass("active").attr("aria-pressed","false"):(i.removeClass("file-zoom-fullscreen"),t.$modal.find(".kv-zoom-body").css("height",t.zoomModalHeight));else{if(!e)return void t._maximizeZoomDialog();W.toggleFullScreen(!0)}i.focus()},_setZoomContent:function(e,t){var i,a,r,n,o,s=this,l=e.attr("id"),d=s._getZoom(l),c=s.$modal,u=c.find(".btn-kv-fullscreen"),p=c.find(".btn-kv-borderless"),f=c.find(".btn-kv-toggleheader"),m=e.data("zoom");m&&(m=decodeURIComponent(m),o=d.html().replace(s.zoomPlaceholder,"").setTokens({zoomData:m}),W.setHtml(d,o),e.data("zoom",""),d.attr("data-zoom",m)),o=d.attr("data-template")||"generic",d=(m=d.find(".kv-file-content")).length?m.html():"",m=e.data("caption")||s.msgZoomModalHeading,n=e.data("size")||"",e=e.data("description")||"",W.setHtml(c.find(".kv-zoom-caption").attr("title",m),m),W.setHtml(c.find(".kv-zoom-size"),n),m=c.find(".kv-zoom-description").hide(),e&&(s.showDescriptionClose&&(e=s._getLayoutTemplate("descriptionClose").setTokens({closeIcon:s.previewZoomButtonIcons.close})+"</button>"+e),W.setHtml(m,e).show(),s.showDescriptionClose)&&s._handler(c.find(".kv-desc-hide"),"click",function(){H(this).parent().fadeOut("fast",function(){c.focus()})}),i=c.find(".kv-zoom-body"),c.removeClass("kv-single-content"),t?(r=i.addClass("file-thumb-loading").clone().insertAfter(i),W.setHtml(i,d).hide(),r.fadeOut("fast",function(){i.fadeIn("fast",function(){i.removeClass("file-thumb-loading")}),r.remove()})):W.setHtml(i,d),(n=s.previewZoomSettings[o])&&(a=i.find(".kv-preview-data"),W.addCss(a,"file-zoom-detail"),H.each(n,function(e,t){a.css(e,t),(a.attr("width")&&"width"===e||a.attr("height")&&"height"===e)&&a.removeAttr(e)})),c.data("previewId",l),s._handler(c.find(".btn-kv-prev"),"click",function(){s._zoomSlideShow("prev",l)}),s._handler(c.find(".btn-kv-next"),"click",function(){s._zoomSlideShow("next",l)}),s._handler(u,"click",function(){s._resizeZoomDialog(!0)}),s._handler(p,"click",function(){s._resizeZoomDialog(!1)}),s._handler(f,"click",function(){function e(e){var t=s.$modal.find(".kv-zoom-body"),i=s.zoomModalHeight;c.hasClass("file-zoom-fullscreen")&&(i=t.outerHeight(!0),e||(i-=a.outerHeight(!0))),t.css("height",e?i+e:i)}var t,a=c.find(".modal-header"),i=c.find(".floating-buttons"),r=a.find(".kv-zoom-actions");a.is(":visible")?(t=a.outerHeight(!0),a.slideUp("slow",function(){r.find(".btn").appendTo(i),e(t)})):(i.find(".btn").appendTo(r),a.slideDown("slow",function(){e()})),c.focus()}),s._handler(c,"keydown",function(e){var t,i,a=e.which||e.keyCode,r=s.processDelay+1,e=H(this).find(".btn-kv-prev"),n=H(this).find(".btn-kv-next"),o=H(this).data("previewId");[t,i]=s.rtl?[39,37]:[37,39],H.each({prev:[e,t],next:[n,i]},function(e,t){var i=t[0];a===t[1]&&i.length&&(c.focus(),i.attr("disabled")||(i.blur(),setTimeout(function(){i.focus(),s._zoomSlideShow(e,o),setTimeout(function(){i.attr("disabled")&&c.focus()},r)},r)))})})},_showModal:function(e){var t,i,a=this,r=a.$modal;e&&e.length&&(W.initModal(r),W.setHtml(r,a._getModalContent()),a._setZoomContent(e),r.removeClass("rotatable"),r.data({backdrop:!1,fileinputPluginId:a.$element.attr("id")}),r.find(".kv-zoom-body").css("height",a.zoomModalHeight),(t=e.find(".kv-file-content > :first-child")).length&&(i=t.css("transform"))&&r.find(".file-zoom-detail").css("transform",i),e.hasClass("rotatable")&&r.addClass("rotatable"),e.data("angle")&&r.data("angle",e.data("angle")),e.data("angle"),r.modal("show"),a._initZoomButtons(),a._initRotateZoom(e,t))},_zoomPreview:function(e){if(!e.length)throw"Cannot zoom to detailed preview!";e=e.closest(W.FRAMES),this._showModal(e)},_zoomSlideShow:function(e,t){var i,a,r,n,o=this,s=o.$modal,l=s.find(".kv-zoom-actions .btn-kv-"+e),d=o.getFrames().toArray(),c=[],u=d.length;if(o.reversePreviewOrder&&(e="prev"===e?"next":"prev"),!l.attr("disabled")){for(i=0;i<u;i++)(a=H(d[i]))&&a.length&&a.find(".kv-file-zoom:visible").length&&c.push(d[i]);for(u=c.length,i=0;i<u;i++)if(H(c[i]).attr("id")===t){r="prev"===e?i-1:i+1;break}r<0||u<=r||!c[r]||((l=H(c[r])).length&&o._setZoomContent(l,e),o._initZoomButtons(),l.length&&l.hasClass("rotatable")?(n=l.data("angle")||0,s.addClass("rotatable").data("angle",n),n=l.find(".kv-file-content > :first-child"),o._initRotateZoom(l,n)):s.removeClass("rotatable").removeData("angle"),o._raise("filezoom"+e,{previewId:t,modal:o.$modal}))}},_initZoomButton:function(){var t=this;t.$preview.find(".kv-file-zoom").each(function(){var e=H(this);t._handler(e,"click",function(){t._zoomPreview(e)})})},_inputFileCount:function(){return this.$element[0].files.length},_refreshPreview:function(){var e,t=this;(t._inputFileCount()||t.isAjaxUpload)&&t.showPreview&&t.isPreviewable&&(t.isAjaxUpload&&0<t.fileManager.count()?(e=H.extend(!0,[],t.getFileList()),t.fileManager.clear(),t._clearFileInput()):e=t.$element[0].files,e)&&e.length&&t.readFiles(e)},_clearObjects:function(e){e.find("video audio").each(function(){this.pause(),H(this).remove()}),e.find("img object div").each(function(){H(this).remove()})},_clearFileInput:function(){var e,t,i,a=this.$element;this._inputFileCount()&&(e=a.closest("form"),t=H(document.createElement("form")),i=H(document.createElement("div")),a.before(i),(e.length?e:i).after(t),t.append(a).trigger("reset"),i.before(a).remove(),t.remove())},_resetUpload:function(){var e=this;e.uploadInitiated=!1,e.uploadStartTime=W.now(),e.uploadCache=[],e.$btnUpload.removeAttr("disabled"),e._setProgress(0),e._hideProgress(),e._resetErrors(!1),e._initAjax(),e.fileManager.clearImages(),e._resetCanvas(),e.overwriteInitial&&(e.initialPreview=[],e.initialPreviewConfig=[],e.initialPreviewThumbTags=[],e.previewCache.data={content:[],config:[],tags:[]})},_resetCanvas:function(){var e=this;e.imageCanvas&&e.imageCanvasContext&&e.imageCanvasContext.clearRect(0,0,e.imageCanvas.width,e.imageCanvas.height)},_hasInitialPreview:function(){return!this.overwriteInitial&&this.previewCache.count(!0)},_resetPreview:function(){var e,t,i=this,a=i.showUploadedThumbs,r=!i.removeFromPreviewOnError,n=(a||r)&&i.isDuplicateError;i.previewCache.count(!0)?(e=i.previewCache.out(),n&&(t=W.createDiv().insertAfter(i.$container),i.getFrames().each(function(){var e=H(this);(a&&e.hasClass("file-preview-success")||r&&e.hasClass("file-preview-error"))&&t.append(e)})),i._setPreviewContent(e.content),i._setInitThumbAttr(),e=i.initialCaption||e.caption,i._setCaption(e),n&&(t.contents().appendTo(i.$preview),t.remove())):(i._clearPreview(),i._initCaption()),i.showPreview&&(i._initZoom(),i._initSortable()),i.isDuplicateError=!1},_clearDefaultPreview:function(){this.$preview.find(".file-default-preview").remove()},_validateDefaultPreview:function(){var e=this;e.showPreview&&!W.isEmpty(e.defaultPreviewContent)&&(e._setPreviewContent('<div class="file-default-preview">'+e.defaultPreviewContent+"</div>"),e.$container.removeClass("file-input-new"),e._initClickable())},_resetPreviewThumbs:function(e){var t=this;e?(t._clearPreview(),t.clearFileStack()):t._hasInitialPreview()?(e=t.previewCache.out(),t._setPreviewContent(e.content),t._setInitThumbAttr(),t._setCaption(e.caption),t._initPreviewActions()):t._clearPreview()},_getLayoutTemplate:function(e){e=this.layoutTemplates[e];return W.isEmpty(this.customLayoutTags)?e:W.replaceTags(e,this.customLayoutTags)},_getPreviewTemplate:function(e){var t=this.previewTemplates,e=t[e]||t.other;return W.isEmpty(this.customPreviewTags)?e:W.replaceTags(e,this.customPreviewTags)},_getOutData:function(e,t,i,a){var r=this;return t=t||{},i=i||{},{formdata:e,files:a=a||r.fileManager.list(),filenames:r.filenames,filescount:r.getFilesCount(),extra:r._getExtraData(),response:i,reader:r.reader,jqXHR:t}},_getMsgSelected:function(e,t){var i=this,a=1===e?i.fileSingle:i.filePlural;return 0<e?i.msgSelected.replace("{n}",e).replace("{files}",a):t?i.msgProcessing:i.msgNoFilesSelected},_getFrame:function(e,t){var i=W.getFrameElement(this.$preview,e);return!this.showPreview||t||i.length||this._log(W.logMessages.invalidThumb,{id:e}),i},_getZoom:function(e,t){t=W.getZoomElement(this.$preview,e,t);return this.showPreview&&!t.length&&this._log(W.logMessages.invalidThumb,{id:e}),t},_getThumbs:function(e){return this.getFrames(":not(.file-preview-initial)"+(e=e||""))},_getThumbId:function(e){return this.previewInitId+"-"+e},_getExtraData:function(e,t){var i=this.uploadExtraData;return i="function"==typeof this.uploadExtraData?this.uploadExtraData(e,t):i},_initXhr:function(e,n){var o=this,s=o.fileManager,t=function(e){var t=0,i=e.total,a=e.loaded||e.position,r=s.getUploadStats(n,a,i);e.lengthComputable&&!o.enableResumableUpload&&(t=W.round(a/i*100)),n?o._setFileUploadStats(n,t,r):o._setProgress(t,null,null,o._getStats(r)),o._raise("fileajaxprogress",[r])};return e.upload&&(o.progressDelay&&(t=W.debounce(t,o.progressDelay)),e.upload.addEventListener("progress",t,!1)),e},_initAjaxSettings:function(){this._ajaxSettings=H.extend(!0,{},this.ajaxSettings),this._ajaxDeleteSettings=H.extend(!0,{},this.ajaxDeleteSettings)},_mergeAjaxCallback:function(e,t,i){var a,r=this._ajaxSettings,n=this.mergeAjaxCallbacks;"delete"===i&&(r=this._ajaxDeleteSettings,n=this.mergeAjaxDeleteCallbacks),a=r[e],r[e]=n&&"function"==typeof a?"before"===n?function(){a.apply(this,arguments),t.apply(this,arguments)}:function(){t.apply(this,arguments),a.apply(this,arguments)}:t},_ajaxSubmit:function(e,t,i,a,r,n,o,s){var l=this,d=l.taskManager;l._raise("filepreajax",[r,n,o])&&(r.append("initialPreview",JSON.stringify(l.initialPreview)),r.append("initialPreviewConfig",JSON.stringify(l.initialPreviewConfig)),r.append("initialPreviewThumbTags",JSON.stringify(l.initialPreviewThumbTags)),l._initAjaxSettings(),l._mergeAjaxCallback("beforeSend",e),l._mergeAjaxCallback("success",t),l._mergeAjaxCallback("complete",i),l._mergeAjaxCallback("error",a),"function"==typeof(s=s||l.uploadUrlThumb||l.uploadUrl)&&(s=s()),"object"==typeof(e=l._getExtraData(n,o)||{})&&H.each(e,function(e,t){r.append(e,t)}),t={xhr:function(){var e=H.ajaxSettings.xhr();return l._initXhr(e,n)},url:l._encodeURI(s),type:"POST",dataType:"json",data:r,cache:!1,processData:!1,contentType:!1},i=H.extend(!0,{},t,l._ajaxSettings),l.ajaxQueue.push(i),d.addTask(n+"-"+o,function(){var e=this.self,t=e.ajaxQueue.shift(),t=H.ajax(t);e.ajaxRequests.push(t)}).runWithContext({self:l}))},_mergeArray:function(e,t){var i=W.cleanArray(this[e]),t=W.cleanArray(t);this[e]=i.concat(t)},_initUploadSuccess:function(e,t,i){var a,r,n,o,s,l=this;l.showPreview&&"object"==typeof e&&!H.isEmptyObject(e)&&void 0!==e.initialPreview&&0<e.initialPreview.length&&(l.hasInitData=!0,n=e.initialPreviewConfig||[],o=e.initialPreviewThumbTags||[],a=void 0===e.append||e.append,(e=0<(e=e.initialPreview||[]).length&&!W.isArray(e)?e.split(l.initialPreviewDelimiter):e).length&&(l._mergeArray("initialPreview",e),l._mergeArray("initialPreviewConfig",n),l._mergeArray("initialPreviewThumbTags",o)),void 0!==t?i?(i=t.attr("id"),null!==(s=l._getUploadCacheIndex(i))&&(l.uploadCache[s]={id:i,content:e[0],config:n[0]||[],tags:o[0]||[],append:a})):(s=l.previewCache.add(e[0],n[0],o[0],a),i=l.previewCache.get(s,!1),r=W.createElement(W.cspBuffer.stash(i)).hide().appendTo(t),W.cspBuffer.apply(t),t.fadeOut("slow",function(){var e=r.find("> .file-preview-frame");e&&e.length&&e.insertBefore(t).fadeIn("slow").css("display:inline-block"),l._initPreviewActions(),l._clearFileInput(),t.remove(),r.remove(),l._initSortable()})):(l.previewCache.set(e,n,o,a),l._initPreview(),l._initPreviewActions())),l._resetCaption()},_getUploadCacheIndex:function(e){for(var t=this.uploadCache.length,i=0;i<t;i++)if(this.uploadCache[i].id===e)return i;return null},_initSuccessThumbs:function(){var i=this;i.showPreview&&setTimeout(function(){i._getThumbs(W.FRAMES+".file-preview-success").each(function(){var t=H(this),e=t.find(".kv-file-remove");e.removeAttr("disabled"),i._handler(e,"click",function(){var e=t.attr("id"),e=i._raise("filesuccessremove",[e,t.attr("data-fileindex")]);W.cleanMemory(t),!1!==e&&(i.$caption.attr("title",""),t.fadeOut("slow",function(){i.fileManager;t.remove(),i.getFrames().length||i.reset()}))})})},i.processDelay)},_updateInitialPreview:function(){var i=this,e=i.uploadCache;i.showPreview&&(H.each(e,function(e,t){i.previewCache.add(t.content,t.config,t.tags,t.append)}),i.hasInitData)&&(i._initPreview(),i._initPreviewActions())},_getThumbFileId:function(e){return this.showPreview&&void 0!==e?e.attr("data-fileid"):null},_getThumbFile:function(e){e=this._getThumbFileId(e);return e?this.fileManager.getFile(e):null},_uploadSingle:function(r,n,o,e){var s,l,t,d,i,c,u,p,a,f,m,g=this,h=g.fileManager,v=h.count(),w=new FormData,b=g._getThumbId(n),_=0<v||!H.isEmptyObject(g.uploadExtraData),C=g.ajaxOperations.uploadThumb,x=h.getFile(n),y={id:b,index:r,fileId:n},T=g.fileManager.getFileName(n,!0),P=function(){e&&e.resolve&&e.resolve()},F=function(){e&&e.reject&&e.reject()};g.enableResumableUpload||(g.uploadInitiated=!0,g.showPreview&&(l=h.getThumb(n),u=l.find(".file-thumb-progress"),d=l.find(".kv-file-upload"),i=l.find(".kv-file-remove"),u.show()),0===v)||!_||g.showPreview&&d&&d.hasClass("disabled")||g._abort(y)||(m=function(){c?h.errors.push(n):h.removeFile(n),h.setProcessed(n),h.isProcessed()&&(g.fileBatchCompleted=!0,t())},t=function(){var i;g.fileBatchCompleted&&setTimeout(function(){var e=0===h.count(),t=h.errors.length;g._updateInitialPreview(),g.unlock(e),e&&g._clearFileInput(),i=g.$preview.find(".file-preview-initial"),g.uploadAsync&&i.length&&(W.addCss(i,W.SORT_CSS),g._initSortable()),g._raise("filebatchuploadcomplete",[h.stack,g._getExtraData()]),g.retryErrorUploads&&0!==t||h.clear(),g._setProgress(101),g.ajaxAborted=!1,g.uploadInitiated=!1},g.processDelay)},v=function(e){s=g._getOutData(w,e),h.initStats(n),g.fileBatchCompleted=!1,o||(g.ajaxAborted=!1),g.showPreview&&(l.hasClass("file-preview-success")||(g._setThumbStatus(l,"Loading"),W.addCss(l,"file-uploading")),d.attr("disabled",!0),i.attr("disabled",!0)),o||g.lock(),-1!==h.errors.indexOf(n)&&delete h.errors[n],g._raise("filepreupload",[s,b,r,g._getThumbFileId(l)]),H.extend(!0,y,s),g._abort(y)&&(e.abort(),o||(g._setThumbStatus(l,"New"),l.removeClass("file-uploading"),d.removeAttr("disabled"),i.removeAttr("disabled")),g._setProgressCancelled())},_=function(e,t,i){var a=g.showPreview&&l.attr("id")?l.attr("id"):b;s=g._getOutData(w,i,e),H.extend(!0,y,s),setTimeout(function(){W.isEmpty(e)||W.isEmpty(e.error)?(g.showPreview&&(g._setThumbStatus(l,"Success"),d.hide(),g._initUploadSuccess(e,l,o),g._setProgress(101,u)),g._raise("fileuploaded",[s,a,r,g._getThumbFileId(l)]),o?(m(),P()):g.fileManager.remove(l)):(c=!0,p=g._parseError(C,i,g.msgUploadError,g.fileManager.getFileName(n)),g._showFileError(p,y),g._setPreviewError(l,!0),g.retryErrorUploads||d.hide(),o&&(m(),P()),g._setProgress(101,g._getFrame(a).find(".file-thumb-progress"),g.msgUploadError))},g.processDelay)},a=function(){g.showPreview&&(d.removeAttr("disabled"),i.removeAttr("disabled"),l.removeClass("file-uploading")),o?t():(g.unlock(!1),g._clearFileInput()),g._initSuccessThumbs()},f=function(t,e,i){p=g._parseError(C,t,i,g.fileManager.getFileName(n)),c=!0,setTimeout(function(){var e;o&&(m(),F()),g.fileManager.setProgress(n,100),g._setPreviewError(l,!0),g.retryErrorUploads||d.hide(),H.extend(!0,y,g._getOutData(w,t)),g._setProgress(101,g.$progress,g.msgAjaxProgressError.replace("{operation}",C)),e=g.showPreview&&l?l.find(".file-thumb-progress"):"",g._setProgress(101,e,g.msgUploadError),g._showFileError(p,y)},g.processDelay)},g._setFileData(w,x.file,T,n),g._setUploadData(w,{fileId:n}),g._ajaxSubmit(v,_,a,f,w,n,r))},_setFileData:function(e,t,i,a){var r=this.preProcessUpload;r&&"function"==typeof r?e.append(this.uploadFileAttr,r(a,t)):e.append(this.uploadFileAttr,t,i)},_checkBatchPreupload:function(e,t){var a=this;return!!a._raise("filebatchpreupload",[e])||(a._abort(e),t&&t.abort(),a._getThumbs().each(function(){var e=H(this),t=e.find(".kv-file-upload"),i=e.find(".kv-file-remove");e.hasClass("file-preview-loading")&&(a._setThumbStatus(e,"New"),e.removeClass("file-uploading")),t.removeAttr("disabled"),i.removeAttr("disabled")}),a._setProgressCancelled(),!1)},_uploadBatch:function(){var s,l,e,t,i,a,d=this,r=d.fileManager,n=r.total(),o=0<n||!H.isEmptyObject(d.uploadExtraData),c=new FormData,u=d.ajaxOperations.uploadBatch;0!==n&&o&&!d._abort({})&&(l=function(){d.fileManager.clear(),d._clearFileInput()},o=function(e){d.lock(),r.initStats();var t=d._getOutData(c,e);d.ajaxAborted=!1,d.showPreview&&d._getThumbs().each(function(){var e=H(this),t=e.find(".kv-file-upload"),i=e.find(".kv-file-remove");e.hasClass("file-preview-success")||(d._setThumbStatus(e,"Loading"),W.addCss(e,"file-uploading")),t.attr("disabled",!0),i.attr("disabled",!0)}),d._checkBatchPreupload(t,e)},e=function(e,t,i){var a=d._getOutData(c,i,e),r=0,n=d._getThumbs(":not(.file-preview-success)"),o=W.isEmpty(e)||W.isEmpty(e.errorkeys)?[]:e.errorkeys;W.isEmpty(e)||W.isEmpty(e.error)?(d._raise("filebatchuploadsuccess",[a]),l(),d.showPreview?(n.each(function(){var e=H(this);d._setThumbStatus(e,"Success"),e.removeClass("file-uploading"),e.find(".kv-file-upload").hide().removeAttr("disabled")}),d._initUploadSuccess(e)):d.reset(),d._setProgress(101)):(d.showPreview&&(n.each(function(){var e=H(this);e.removeClass("file-uploading"),e.find(".kv-file-upload").removeAttr("disabled"),e.find(".kv-file-remove").removeAttr("disabled"),0===o.length||-1!==H.inArray(r,o)?(d._setPreviewError(e,!0),d.retryErrorUploads||(e.find(".kv-file-upload").hide(),d.fileManager.remove(e))):(e.find(".kv-file-upload").hide(),d._setThumbStatus(e,"Success"),d.fileManager.remove(e)),e.hasClass("file-preview-error")&&!d.retryErrorUploads||r++}),d._initUploadSuccess(e)),s=d._parseError(u,i,d.msgUploadError),d._showFileError(s,a,"filebatchuploaderror"),d._setProgress(101,d.$progress,d.msgUploadError))},t=function(){d.unlock(),d._initSuccessThumbs(),d._clearFileInput(),d._raise("filebatchuploadcomplete",[d.fileManager.stack,d._getExtraData()])},i=function(e,t,i){var a=d._getOutData(c,e);s=d._parseError(u,e,i),d._showFileError(s,a,"filebatchuploaderror"),d.uploadFileCount=n-1,d.showPreview&&(d._getThumbs().each(function(){var e=H(this);e.removeClass("file-uploading"),d._getThumbFile(e)&&d._setPreviewError(e)}),d._getThumbs().removeClass("file-uploading"),d._getThumbs(" .kv-file-upload").removeAttr("disabled"),d._getThumbs(" .kv-file-delete").removeAttr("disabled"),d._setProgress(101,d.$progress,d.msgAjaxProgressError.replace("{operation}",u)))},a=0,H.each(d.fileManager.stack,function(e,t){W.isEmpty(t.file)||d._setFileData(c,t.file,t.nameFmt||"untitled_"+a,e),a++}),d._ajaxSubmit(o,e,t,i,c))},_uploadExtraOnly:function(){var r,n=this,o={},s=new FormData,l=n.ajaxOperations.uploadExtra;n._ajaxSubmit(function(e){n.lock();var t=n._getOutData(s,e);n._setProgress(50),o.data=t,o.xhr=e,n._checkBatchPreupload(t,e)},function(e,t,i){var a=n._getOutData(s,i,e);W.isEmpty(e)||W.isEmpty(e.error)?(n._raise("filebatchuploadsuccess",[a]),n._clearFileInput(),n._initUploadSuccess(e),n._setProgress(101)):(r=n._parseError(l,i,n.msgUploadError),n._showFileError(r,a,"filebatchuploaderror"))},function(){n.unlock(),n._clearFileInput(),n._raise("filebatchuploadcomplete",[n.fileManager.stack,n._getExtraData()])},function(e,t,i){var a=n._getOutData(s,e);r=n._parseError(l,e,i),o.data=a,n._showFileError(r,a,"filebatchuploaderror"),n._setProgress(101,n.$progress,n.msgAjaxProgressError.replace("{operation}",l))},s)},_deleteFileIndex:function(e){var t=this,i=e.attr("data-fileindex"),e=t.reversePreviewOrder;i.substring(0,5)===W.INIT_FLAG&&(i=parseInt(i.replace(W.INIT_FLAG,"")),t.initialPreview=W.spliceArray(t.initialPreview,i,e),t.initialPreviewConfig=W.spliceArray(t.initialPreviewConfig,i,e),t.initialPreviewThumbTags=W.spliceArray(t.initialPreviewThumbTags,i,e),t.getFrames().each(function(){var e=H(this),t=e.attr("data-fileindex");t.substring(0,5)===W.INIT_FLAG&&(t=parseInt(t.replace(W.INIT_FLAG,"")),i<t)&&e.attr("data-fileindex",W.INIT_FLAG+--t)}))},_resetCaption:function(){var r=this;setTimeout(function(){var e="",t=r.previewCache.count(!0),i=r.fileManager.count(),a=r.showPreview&&r.getFrames(":not(.file-preview-success):not(.file-preview-error)").length;0!==i||0!==t||a?(e=1<(a=t+i)?r._getMsgSelected(a):0===i?(e="",(e=(t=r.initialPreviewConfig[0])?t.caption||t.filename||"":e)||r._getMsgSelected(a)):(i=r.fileManager.getFirstFile())?i.nameFmt:"_",r._setCaption(e)):r.reset()},r.processDelay)},_handleRotation:function(e,t,i){var a,r,n,o="",s=1,l=t[0],d=t.parent(),c=H("body"),u=!!c.length;u&&c.addClass("kv-overflow-hidden"),!t.length||e.hasClass("hide-rotate")?u&&c.removeClass("kv-overflow-hidden"):((n=t.css("transform"))&&t.css("transform","none"),n&&t.css("transform",n),n="rotate("+(i=i||0)+"deg)",a="rotate("+(r=i%360)+"deg)",o="",90!=r&&270!=r||(i=l.naturalWidth||t.outerWidth()||0,s=(l=l.naturalHeight||t.outerHeight()||0)<i&&0!=i?(l/i).toFixed(2):1,1!==(s=d.length&&(l=d.height(),d=d.width(),s*(i=Math.min(i,d))<l)?l<i&&0!=i?(l/i).toFixed(2):1:s)&&(o=" scale("+s+")")),t.addClass("rotate-animate").css("transform",n+o),setTimeout(function(){t.removeClass("rotate-animate").css("transform",a+o),u&&c.removeClass("kv-overflow-hidden"),e.data("angle",r)},this.fadeDelay))},_initRotateButton:function(){var a=this;a.getFrames(".rotatable .kv-file-rotate").each(function(){var e=H(this),t=e.closest(W.FRAMES),i=t.find(".kv-file-content > :first-child");a._handler(e,"click",function(){var e=(t.data("angle")||0)+90;a._handleRotation(t,i,e)})})},_initRotateZoom:function(e,t){var i=this,a=i.$modal,r=a.find(".btn-kv-rotate"),n=e.data("angle");a.data("angle",n),r.length&&(r.off("click"),a.hasClass("rotatable"))&&r.on("click",function(){n=(a.data("angle")||0)+90,a.data("angle",n),i._handleRotation(a,a.find(".file-zoom-detail"),n),i._handleRotation(e,t,n),e.hasClass("hide-rotate")&&e.data("angle",n)})},_initFileActions:function(){var n=this;n.showPreview&&(n._initZoomButton(),n._initRotateButton(),n.getFrames(" .kv-file-remove").each(function(){var e,t=H(this),i=t.closest(W.FRAMES),a=i.attr("id"),r=i.attr("data-fileindex");n.fileManager;n._handler(t,"click",function(){if(!1===n._raise("filepreremove",[a,r])||!n._validateMinCount())return!1;e=i.hasClass("file-preview-error"),W.cleanMemory(i),i.fadeOut("slow",function(){n.fileManager.remove(i),n._clearObjects(i),i.remove(),a&&e&&n.$errorContainer.find('li[data-thumb-id="'+a+'"]').fadeOut("fast",function(){H(this).remove(),n._errorsExist()||n._resetErrors()}),n._clearFileInput(),n._resetCaption(),n._raise("fileremoved",[a,r])})})}),n.getFrames(" .kv-file-upload").each(function(){var i=H(this);n._handler(i,"click",function(){var e=i.closest(W.FRAMES),t=n._getThumbFileId(e);n._hideProgress(),e.hasClass("file-preview-error")&&!n.retryErrorUploads||n._uploadSingle(n.fileManager.getIndex(t),t,!1)})}))},_initPreviewActions:function(){function m(){var e=g.isAjaxUpload?g.previewCache.count(!0):g._inputFileCount();g.getFrames().length||e?g._resetCaption():(g._setCaption(""),g.reset(),g.initialCaption="")}var g=this,e=g.$preview,h=g.deleteExtraData||{},t=W.FRAMES+" .kv-file-remove",i=g.fileActionSettings,v=i.removeClass,w=i.removeErrorClass;g._initZoomButton(),g._initRotateButton(),e.find(t).each(function(){var r,e,t,n,i,o,s,a,l,d,c=H(this),u=c.data("url")||g.deleteUrl,p=c.data("key"),f=g.ajaxOperations.deleteThumb;W.isEmpty(u)||void 0===p||("function"==typeof u&&(u=u()),n=c.closest(W.FRAMES),a=g.previewCache.data,s=n.attr("data-fileindex"),s=parseInt(s.replace(W.INIT_FLAG,"")),a=W.isEmpty(a.config)&&W.isEmpty(a.config[s])?null:a.config[s],l=W.isEmpty(a)||W.isEmpty(a.extra)?h:a.extra,d=a&&(a.filename||a.caption)||"","function"==typeof l&&(l=l()),o={id:c.attr("id"),key:p,extra:l},a=function(e){g.ajaxAborted=!1,g._raise("filepredelete",[p,e,l]),g._abort()?e.abort():(c.removeClass(w),W.addCss(n,"file-uploading"),W.addCss(c,"disabled "+v))},e=function(e,t,i){var a;W.isEmpty(e)||W.isEmpty(e.error)?(n.removeClass("file-uploading").addClass("file-deleted"),n.fadeOut("slow",function(){s=parseInt(n.attr("data-fileindex").replace(W.INIT_FLAG,"")),g.previewCache.unset(s),g._deleteFileIndex(n),a=g.previewCache.count(!0),a=0<a?g._getMsgSelected(a):"",g._setCaption(a),g._raise("filedeleted",[p,i,l]),g._clearObjects(n),n.remove(),m()})):(o.jqXHR=i,o.response=e,r=g._parseError(f,i,g.msgDeleteError,d),g._showFileError(r,o,"filedeleteerror"),n.removeClass("file-uploading"),c.removeClass("disabled "+v).addClass(w),m())},t=function(e,t,i){i=g._parseError(f,e,i,d);o.jqXHR=e,o.response={},g._showFileError(i,o,"filedeleteerror"),n.removeClass("file-uploading"),c.removeClass("disabled "+v).addClass(w),m()},g._initAjaxSettings(),g._mergeAjaxCallback("beforeSend",a,"delete"),g._mergeAjaxCallback("success",e,"delete"),g._mergeAjaxCallback("error",t,"delete"),i=H.extend(!0,{},{url:g._encodeURI(u),type:"POST",dataType:"json",data:H.extend(!0,{},{key:p},l)},g._ajaxDeleteSettings),g._handler(c,"click",function(){if(!g._validateMinCount())return!1;g.ajaxAborted=!1,g._raise("filebeforedelete",[p,l]),g.ajaxAborted instanceof Promise?g.ajaxAborted.then(function(e){e||H.ajax(i)}):g.ajaxAborted||H.ajax(i)}))})},_hideFileIcon:function(){this.overwriteInitial&&this.$captionContainer.removeClass("icon-visible")},_showFileIcon:function(){W.addCss(this.$captionContainer,"icon-visible")},_getSize:function(e,t,i){var a,r=parseFloat(e),n=0,o=this.bytesToKB,s=this.fileSizeGetter,l=r;if(!W.isNumeric(e)||!W.isNumeric(r))return"";if("function"==typeof s)a=s(r);else{if(i=i||this.sizeUnits,0<r){for(;o<=l;)l/=o,++n;i[n]||(l=r,n=0)}a=(e=(e=l.toFixed(2))==l?l:e)+" "+i[n]}return t?a:this._getLayoutTemplate("size").replace("{sizeText}",a)},_getFileType:function(e){return this.mimeTypeAliases[e]||e},_generatePreviewTemplate:function(o,e,s,l,d,c,t,i,a,u,r,p,f,m,n){var g,h=this,v=h.slug(s),w="",b="",_=a||s,a=_.split(".").pop().toLowerCase(),C=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,x=v,y=v,T="type-default",P=r||h._renderFileFooter(o,v,i,"auto",t),r=-1!==H.inArray(a,h.alwaysPreviewFileExtensions),i=h.preferIconicPreview&&!r,t=h.preferIconicZoomPreview&&!r,r=i?"other":o,C=C<400?h.previewSettingsSmall[r]||h.defaults.previewSettingsSmall[r]:h.previewSettings[r]||h.defaults.previewSettings[r];return C&&H.each(C,function(e,t){b+=e+":"+t+";"}),r=function(e,t,i,a,r){var n=i?"zoom-"+d:d,e=h._getPreviewTemplate(e),a=(u||"")+" "+a;return h.frameClass&&(a=h.frameClass+" "+a),i&&(a=a.replace(" "+W.SORT_CSS,"")),e=h._parseFilePreviewIcon(e,s),"object"!==o||l||H.each(h.defaults.fileTypeSettings,function(e,t){"object"!==e&&"other"!==e&&t(s,l)&&(T="type-"+e)}),W.isEmpty(m)||(void 0!==m.title&&null!==m.title&&(x=m.title),null!=m.alt&&(y=x=m.alt)),n={previewId:n,caption:v,title:x,alt:y,frameClass:a,type:h._getFileType(l),fileindex:p,fileid:c||"",filename:_,typeCss:T,footer:P,data:i&&r?h.zoomPlaceholder+"{zoomData}":t,template:f||o,style:b?'style="'+b+'"':"",zoomData:r?encodeURIComponent(r):""},i&&(n.zoomCache="",n.zoomData="{zoomData}"),e.setTokens(n)},p=p||d.slice(d.lastIndexOf("-")+1),C=h.fileActionSettings.showRotate&&-1!==H.inArray(a,h.rotatableFileExtensions),h.fileActionSettings.showZoom&&(g="kv-zoom-thumb",C&&(g+=" rotatable"+(t?" hide-rotate":"")),w=r(t?"other":o,e,!0,g,n)),w="\n"+h._getLayoutTemplate("zoomCache").replace("{zoomContent}",w),"function"==typeof h.sanitizeZoomCache&&(w=h.sanitizeZoomCache(w)),g="kv-preview-thumb",C&&(g+=" rotatable"+(i||h.hideThumbnailContent||!!h.previewFileIconSettings[a]?" hide-rotate":"")),r(i?"other":o,e,!1,g,n).setTokens({zoomCache:w})},_addToPreview:function(e,t){return t=W.cspBuffer.stash(t),t=this.reversePreviewOrder?e.prepend(t):e.append(t),W.cspBuffer.apply(e),t},_previewDefault:function(e,t){var i,a,r,n,o,s,l,d=this,c=d.$preview;d.showPreview&&(i=W.getFileName(e),a=e?e.type:"",r=e.size||0,n=d._getFileName(e,""),o=!0===t&&!d.isAjaxUpload,s=W.createObjectURL(e),e=d.fileManager.getId(e),l=d._getThumbId(e),d._clearDefaultPreview(),s=d._generatePreviewTemplate("other",s,i,a,l,e,o,r),d._addToPreview(c,s),d._setThumbAttr(l,n,r),!0===t)&&d.isAjaxUpload&&d._setThumbStatus(d._getFrame(l),"Error")},_previewFile:function(e,t,i,a,r){var n,o,s,l,d,c,u,p;this.showPreview&&(n=this,p=W.getFileName(t),o=r.type,s=r.name,u=n._parseFileType(o,p),l=n.$preview,d=t.size||0,i="image"===u?i.target.result:a,a=n.fileManager.getId(t),c=n._getThumbId(a),u=n._generatePreviewTemplate(u,i,p,o,c,a,!1,d,r.filename),n._clearDefaultPreview(),n._addToPreview(l,u),p=n._getFrame(c),n._validateImageOrientation(p.find("img"),t,c,a,s,o,d,i),n._setThumbAttr(c,s,d),n._initSortable())},_setThumbAttr:function(e,t,i,a){e=this._getFrame(e);e.length&&(i=i&&0<i?this._getSize(i):"",e.data({caption:t,size:i,description:a||""}))},_setInitThumbAttr:function(){var e,t,i,a,r=this.previewCache.data,n=this.previewCache.count(!0);if(0!==n)for(var o=0;o<n;o++)i=r.config[o],a=this.previewInitId+"-"+W.INIT_FLAG+o,e=W.ifSet("caption",i,W.ifSet("filename",i)),t=W.ifSet("size",i),i=W.ifSet("description",i),this._setThumbAttr(a,e,t,i)},_slugDefault:function(e){return W.isEmpty(e,!0)?"":String(e).replace(/[\[\]\/\{}:;#%=\(\)\*\+\?\\\^\$\|<>&"']/g,"_")},_updateFileDetails:function(e){var t=this,i=t.$element,i=W.isIE(9)&&W.findFileName(i.val())||i[0].files[0]&&i[0].files[0].name,i=!i&&0<t.fileManager.count()?t.fileManager.getFirstFile().nameFmt:i?t.slug(i):"_",a=t.isAjaxUpload?t.fileManager.count():e,r=t.previewCache.count(!0)+a,a=1===a?i:t._getMsgSelected(r,!t.isAjaxUpload&&!t.isError);t.isError?(t.$previewContainer.removeClass("file-thumb-loading"),t._initCapStatus(),t.$previewStatus.html(""),t.$captionContainer.removeClass("icon-visible")):t._showFileIcon(),t._setCaption(a,t.isError),t.$container.removeClass("file-input-new file-input-ajax-new"),t._raise("fileselect",[e,i]),t.previewCache.count(!0)&&t._initPreviewActions()},_setThumbStatus:function(e,t){var i,a,r,n,o;this.showPreview&&(a=(i="indicator"+t)+"Title",r="file-preview-"+t.toLowerCase(),n=e.find(".file-upload-indicator"),o=this.fileActionSettings,e.removeClass("file-preview-success file-preview-error file-preview-paused file-preview-loading"),"Success"===t&&e.find(".file-drag-handle").remove(),W.setHtml(n,o[i]),n.attr("title",o[a]),e.addClass(r),"Error"!==t||this.retryErrorUploads||e.find(".kv-file-upload").attr("disabled",!0))},_setProgressCancelled:function(){this._setProgress(101,this.$progress,this.msgCancelled)},_setProgress:function(e,t,i,a){var r,n,o,s=this;(t=t||s.$progress).length&&(r=Math.min(e,100),n=s.progressUploadThreshold,o=e<=100?s.progressTemplate:s.progressCompleteTemplate,o=r<100?s.progressTemplate:i?s.paused?s.progressPauseTemplate:s.progressErrorTemplate:o,100<=e&&(a=""),W.isEmpty(o)||(n=(n=n&&n<r&&e<=100?o.setTokens({percent:n,status:s.msgUploadThreshold}):o.setTokens({percent:r,status:100<e?s.msgUploadEnd:r+"%"})).setTokens({stats:a=a||""}),W.setHtml(t,n),i&&W.setHtml(t.find('[role="progressbar"]'),i)))},_hasFiles:function(){var e=this.$element[0];return!!(e&&e.files&&e.files.length)},_setFileDropZoneTitle:function(){var e,t=this,i=t.$container.find(".file-drop-zone"),a=t.dropZoneTitle;t.isClickable&&(e=W.isEmpty(t.$element.attr("multiple"))?t.fileSingle:t.filePlural,a+=t.dropZoneClickTitle.replace("{files}",e)),i.find("."+t.dropZoneTitleClass).remove(),!t.showPreview||0===i.length||0<t.fileManager.count()||!t.dropZoneEnabled||0<t.previewCache.count()||!t.isAjaxUpload&&t._hasFiles()||(0===i.find(W.FRAMES).length&&W.isEmpty(t.defaultPreviewContent)&&(i.prepend(W.cspBuffer.stash('<div class="'+t.dropZoneTitleClass+'">'+a+"</div>")),W.cspBuffer.apply(i)),t.$container.removeClass("file-input-new"),t.isAjaxUpload&&W.addCss(t.$container,"file-input-ajax-new"))},_getStats:function(e){var t,i;return this.showUploadStats&&e&&e.bitrate?(i=this._getLayoutTemplate("stats"),t=e.elapsed&&e.bps?this.msgPendingTime.setTokens({time:W.getElapsed(Math.ceil(e.pendingBytes/e.bps))}):this.msgCalculatingTime,i.setTokens({uploadSpeed:e.bitrate,pendingTime:t})):""},_setResumableProgress:function(e,t,i){var a=this.resumableManager,a=i?a:this,i=i?i.find(".file-thumb-progress"):null;0===a.lastProgress&&(a.lastProgress=e),this._setProgress(e=e<a.lastProgress?a.lastProgress:e,i,null,this._getStats(t)),a.lastProgress=e},_toggleResumableProgress:function(e,t){var i=this.$progress;i&&i.length&&W.setHtml(i,e.setTokens({percent:101,status:t,stats:""}))},_setFileUploadStats:function(e,t,i){var a,r,n,o,s,l,d,c,u,p=this,f=p.$progress;(p.showPreview||f&&f.length)&&(c=p.resumableManager,r=(a=p.fileManager).getThumb(e),n=0,o=a.getTotalSize(),s=H.extend(!0,{},i),p.enableResumableUpload?(l=i.loaded,d=c.getUploadedSize(),c=c.file.size,u=a.uploadedSize+(l+=d),t=W.round(100*l/c),i.pendingBytes=c-d,p._setResumableProgress(t,i,r),l=Math.floor(100*u/o),s.pendingBytes=o-u,p._setResumableProgress(l,s)):(a.setProgress(e,t),f=r&&r.length?r.find(".file-thumb-progress"):null,p._setProgress(t,f,null,p._getStats(i)),H.each(a.stats,function(e,t){n+=t.loaded}),s.pendingBytes=o-n,l=W.round(n/o*100),p._setProgress(l,null,null,p._getStats(s))))},_validateMinCount:function(){var e=this,t=e.isAjaxUpload?e.fileManager.count():e._inputFileCount();return!(e.validateInitialCount&&0<e.minFileCount&&e._getFileCount(t-1)<e.minFileCount&&(e._noFilesError({}),1))},_getFileCount:function(e,t){return(t=void 0===t?this.validateInitialCount&&!this.overwriteInitial:t)&&(e+=this.previewCache.count(!0)),e},_getFileId:function(e){return W.getFileId(e,this.generateFileId)},_getFileName:function(e,t){e=W.getFileName(e);return e?this.slug(e):t},_getFileNames:function(t){return this.filenames.filter(function(e){return t?void 0!==e:null!=e})},_setPreviewError:function(e,t){var i=this,a=i.removeFromPreviewOnError&&!i.retryErrorUploads;t&&!a||i.fileManager.remove(e),i.showPreview&&(a?e.remove():(i._setThumbStatus(e,"Error"),i._refreshUploadButton(e)))},_refreshUploadButton:function(e){var e=e.find(".kv-file-upload"),t=this.fileActionSettings,i=t.uploadIcon,a=t.uploadTitle;e.length&&(this.retryErrorUploads&&(i=t.uploadRetryIcon,a=t.uploadRetryTitle),e.attr("title",a),W.setHtml(e,i))},_isValidSize:function(e,t,i,a,r,n){var o=this,s=o[("Small"===e?"min":"max")+"Image"+t];return!(!W.isEmpty(s)&&i.length)||(i=i[0],i="Width"===t?i.naturalWidth||i.width:i.naturalHeight||i.height,"Small"===e?s<=i:i<=s)||(t=o["msgImage"+t+e]||'Image "{name}" has a size validation error (limit "{size}").',o._showFileError(t.setTokens({name:r,size:s,dimension:i}),n),o._setPreviewError(a),o.fileManager.remove(a),o._clearFileInput(),!1)},_getExifObj:function(e){var t,i=W.logMessages.exifWarning;if("data:image/jpeg;base64,"===e.slice(0,23)||"data:image/jpg;base64,"===e.slice(0,22)){try{t=window.piexif?window.piexif.load(e):null}catch(e){t=null,i=e&&e.message||""}return!t&&this.showExifErrorLog&&this._log(W.logMessages.badExifParser,{details:i}),t}t=null},setImageOrientation:function(o,s,l,d){var c,u,p=this,e=!o||!o.length,t=!s||!s.length,f=!1,m=e&&d&&"image"===d.attr("data-template");e&&t||(e="load.fileinputimageorient",m?(o=s,s=null,o.css(p.previewSettings.image),u=W.createDiv().appendTo(d.find(".kv-file-content")),c=H(document.createElement("span")).insertBefore(o),o.css("visibility","hidden").removeClass("file-zoom-detail").appendTo(u)):f=!o.is(":visible"),o.off(e).on(e,function(){f&&(p.$preview.removeClass("hide-content"),d.find(".kv-file-content").css("visibility","hidden"));var e,t=o[0],i=s&&s.length?s[0]:null,a=t.offsetHeight,r=t.offsetWidth,n=W.getRotation(l);f&&(d.find(".kv-file-content").css("visibility","visible"),p.$preview.addClass("hide-content")),o.data("orientation",l),i&&s.data("orientation",l),l<5?(W.setTransform(t,n),W.setTransform(i,n)):(e=Math.atan(r/a),a=(r=Math.sqrt(Math.pow(a,2)+Math.pow(r,2)))?a/Math.cos(Math.PI/2+e)/r:1,e=" scale("+Math.abs(a)+")",W.setTransform(t,n+e),W.setTransform(i,n+e),m&&(o.css("visibility","visible").insertAfter(c).addClass("file-zoom-detail"),c.remove(),u.remove()))}))},_validateImageOrientation:function(e,t,i,a,r,n,o,s){var l,d=this,c=d.autoOrientImage,u=d._getExifObj(s);d.canOrientImage?e.css("image-orientation",c?"from-image":"none"):(c=W.getZoomSelector(i," img"),(l=u?u["0th"][piexif.ImageIFD.Orientation]:null)&&(d.setImageOrientation(e,H(c),l,d._getFrame(i)),d._raise("fileimageoriented",{$img:e,file:t}))),d._validateImage(i,a,r,n,o,s,u)},_validateImage:function(i,a,r,n,o,s,l){var d,e,c=this,t=c.$preview,u=c._getFrame(i),p=u.attr("data-fileindex"),f=u.find("img");r=r||"Untitled",f.one("load",function(){f.data("validated")||(f.data("validated",!0),e=u.width(),t.width()<e&&f.css("width","100%"),d={ind:p,id:i,fileId:a},setTimeout(function(){var e=c._isValidSize("Small","Width",f,u,r,d),t=c._isValidSize("Small","Height",f,u,r,d);c.resizeImage||(e=e&&c._isValidSize("Large","Width",f,u,r,d),t=t&&c._isValidSize("Large","Height",f,u,r,d)),c._raise("fileimageloaded",[i]),u.data("exif",l),e&&t&&(c.fileManager.addImage(a,{ind:p,img:f,thumb:u,pid:i,typ:n,siz:o,validated:!1,imgData:s,exifObj:l}),c._validateAllImages())},c.processDelay))}).one("error",function(){c._raise("fileimageloaderror",[i])})},_validateAllImages:function(){var i,a=this,r={val:0},n=a.fileManager.getImageCount(),o=a.resizeIfSizeMoreThan;n===a.fileManager.totalImages&&(a._raise("fileimagesloaded"),a.resizeImage)&&H.each(a.fileManager.loadedImages,function(e,t){t.validated||((i=t.siz)&&i>o*a.bytesToKB&&a._getResizedImage(e,t,r,n),t.validated=!0)})},_getResizedImage:function(e,t,i,a){var r,n,o,s=this,l=H(t.img)[0],d=l.naturalWidth,c=l.naturalHeight,u=1,p=s.maxImageWidth||d,f=s.maxImageHeight||c,m=!(!d||!c),g=s.imageCanvas,h=s.imageCanvasContext,v=t.typ,w=t.pid,b=t.ind,_=t.thumb,t=t.exifObj,C=function(e,t,i){s.isAjaxUpload?s._showFileError(e,t,i):s._showError(e,t,i),s._setPreviewError(_)},x=s.fileManager.getFile(e),y={id:w,index:b,fileId:e},w=[e,w,b];if(x&&m&&!(d<=p&&c<=f)||(m&&x&&s._raise("fileimageresized",w),i.val++,i.val===a&&s._raise("fileimagesresized"),m)){v=v||s.resizeDefaultImageType,b=p<d,x=f<c,u="width"===s.resizePreference?b?p/d:x?f/c:1:x?f/c:b?p/d:1,s._resetCanvas(),c*=u,g.width=d*=u,g.height=c;try{h.drawImage(l,0,0,d,c),n=g.toDataURL(v,s.resizeQuality),t&&(o=window.piexif.dump(t),n=window.piexif.insert(o,n)),r=W.dataURI2Blob(n),s.fileManager.setFile(e,r),s._raise("fileimageresized",w),i.val++,i.val===a&&s._raise("fileimagesresized",[void 0,void 0]),r instanceof Blob||C(s.msgImageResizeError,y,"fileimageresizeerror")}catch(e){i.val++,i.val===a&&s._raise("fileimagesresized",[void 0,void 0]),C(s.msgImageResizeException.replace("{errors}",e.message),y,"fileimageresizeexception")}}else C(s.msgImageResizeError,y,"fileimageresizeerror")},_showProgress:function(){this.$progress&&this.$progress.length&&this.$progress.show()},_hideProgress:function(){this.$progress&&this.$progress.length&&this.$progress.hide()},_initBrowse:function(e){var t=this.$element;this.showBrowse?this.$btnFile=e.find(".btn-file").append(t):(t.appendTo(e).attr("tabindex",-1),W.addCss(t,"file-no-browse"))},_initClickable:function(){var t,e,i=this;i.isClickable&&(t=i.$dropZone,i.isAjaxUpload||(e=i.$preview.find(".file-default-preview")).length&&(t=e),W.addCss(t,"clickable"),t.attr("tabindex",-1),i._handler(t,"click",function(e){e=H(e.target);i.$errorContainer.is(":visible")||e.parents(".file-preview-thumbnails").length&&!e.parents(".file-default-preview").length||(i.$element.data("zoneClicked",!0).trigger("click"),t.blur())}))},_initCaption:function(){var e=this.initialCaption||"";return this.overwriteInitial||W.isEmpty(e)?(this.$caption.val(""),!1):(this._setCaption(e),!0)},_setCaption:function(e,t){var i,a,r,n=this;if(n.$caption.length){if(n.$captionContainer.removeClass("icon-visible"),t)i=H("<div>"+n.msgValidationError+"</div>").text(),r=(t=n.fileManager.count())?(r=n.fileManager.getFirstFile(),1===t&&r?r.nameFmt:n._getMsgSelected(t)):n._getMsgSelected(n.msgNo),r=W.isEmpty(e)?r:e,a='<span class="'+n.msgValidationErrorClass+'">'+n.msgValidationErrorIcon+"</span>";else{if(W.isEmpty(e))return void n.$caption.attr("title","");r=i=H("<div>"+e+"</div>").text(),a=n._getLayoutTemplate("fileIcon")}n.$captionContainer.addClass("icon-visible"),n.$caption.attr("title",i).val(r),W.setHtml(n.$captionIcon,a)}},_createContainer:function(){var e=this,t={class:"file-input file-input-new"+(e.rtl?" kv-rtl":"")},i=W.createElement(W.cspBuffer.stash(e._renderMain()));return W.cspBuffer.apply(i),i.insertBefore(e.$element).attr(t),e._initBrowse(i),e.theme&&i.addClass("theme-"+e.theme),i},_refreshContainer:function(){var e=this,t=e.$container;e.$element.insertAfter(t),W.setHtml(t,e._renderMain()),e._initBrowse(t),e._validateDisabled()},_validateDisabled:function(){this.$caption.attr({readonly:this.isDisabled})},_setTabIndex:function(e,t){e=this.tabIndexConfig[e];return t.setTokens({tabIndexConfig:null==e?"":'tabindex="'+e+'"'})},_renderMain:function(){var e=this,t=e.dropZoneEnabled?" file-drop-zone":"file-drop-disabled",i=e.showClose?e._getLayoutTemplate("close"):"",t=e.showPreview?e._getLayoutTemplate("preview").setTokens({class:e.previewClass,dropClass:t}):"",a=e.captionTemplate.setTokens({class:(e.isDisabled?e.captionClass+" file-caption-disabled":e.captionClass)+" kv-fileinput-caption"}),a=e._setTabIndex("caption",a);return e.mainTemplate.setTokens({class:e.mainClass+(!e.showBrowse&&e.showCaption?" no-browse":""),inputGroupClass:e.inputGroupClass,preview:t,close:i,caption:a,upload:e._renderButton("upload"),remove:e._renderButton("remove"),cancel:e._renderButton("cancel"),pause:e._renderButton("pause"),browse:e._renderButton("browse")})},_renderButton:function(e){var t=this,i=t._getLayoutTemplate("btnDefault"),a=t[e+"Class"],r=t[e+"Title"],n=t[e+"Icon"],o=t[e+"Label"],s=t.isDisabled?" disabled":"",l="button";switch(e){case"remove":if(t.showRemove)break;return"";case"cancel":if(!t.showCancel)return"";a+=" kv-hidden";break;case"pause":if(!t.showPause)return"";a+=" kv-hidden";break;case"upload":if(!t.showUpload)return"";t.isAjaxUpload&&!t.isDisabled?i=t._getLayoutTemplate("btnLink").replace("{href}",t.uploadUrl):l="submit";break;case"browse":if(!t.showBrowse)return"";i=t._getLayoutTemplate("btnBrowse");break;default:return""}return i=t._setTabIndex(e,i),a+="browse"===e?" btn-file":" fileinput-"+e+" fileinput-"+e+"-button",W.isEmpty(o)||(o=' <span class="'+t.buttonLabelClass+'">'+o+"</span>"),i.setTokens({type:l,css:a,title:r,status:s,icon:n,label:o})},_renderThumbProgress:function(){return'<div class="file-thumb-progress kv-hidden">'+this.progressInfoTemplate.setTokens({percent:101,status:this.msgUploadBegin,stats:""})+"</div>"},_renderFileFooter:function(e,t,i,a,r){var n=this,o=n.fileActionSettings,s=o.showRemove,l=o.showDrag,d=o.showUpload,c=o.showRotate,u=o.showZoom,p=n._getLayoutTemplate("footer"),f=n._getLayoutTemplate("indicator"),m=r?o.indicatorError:o.indicatorNew,r=r?o.indicatorErrorTitle:o.indicatorNewTitle,o=f.setTokens({indicator:m,indicatorTitle:r}),f={type:e,caption:t,size:i=n._getSize(i),width:a,progress:"",indicator:o};return n.isAjaxUpload?(f.progress=n._renderThumbProgress(),f.actions=n._renderFileActions(f,d,!1,s,c,u,l,!1,!1,!1)):f.actions=n._renderFileActions(f,!1,!1,!1,!1,u,l,!1,!1,!1),m=p.setTokens(f),W.replaceTags(m,n.previewThumbTags)},_renderFileActions:function(e,t,i,a,r,n,o,s,l,d,c,u,p){var f,m,g,h,v,w,b,_,C,x=this;return!e.type&&c&&(e.type="image"),x.enableResumableUpload?t=!1:"function"==typeof t&&(t=t(e)),"function"==typeof i&&(i=i(e)),"function"==typeof a&&(a=a(e)),"function"==typeof n&&(n=n(e)),"function"==typeof o&&(o=o(e)),"function"==typeof r&&(r=r(e)),t||i||a||r||n||o?(e=!1===l?"":' data-url="'+l+'"',l=!1===d?"":' data-key="'+d+'"',w=v=h=g=m=f="",b=x._getLayoutTemplate("actions"),_=x.fileActionSettings,C=x.otherActionButtons.setTokens({dataKey:l,key:d}),s=s?_.removeClass+" disabled":_.removeClass,a&&(h=x._getLayoutTemplate("actionDelete").setTokens({removeClass:s,removeIcon:_.removeIcon,removeTitle:_.removeTitle,dataUrl:e,dataKey:l,key:d})),r&&(g=x._getLayoutTemplate("actionRotate").setTokens({rotateClass:_.rotateClass,rotateIcon:_.rotateIcon,rotateTitle:_.rotateTitle})),t&&(v=x._getLayoutTemplate("actionUpload").setTokens({uploadClass:_.uploadClass,uploadIcon:_.uploadIcon,uploadTitle:_.uploadTitle})),i&&(w=(w=x._getLayoutTemplate("actionDownload").setTokens({downloadClass:_.downloadClass,downloadIcon:_.downloadIcon,downloadTitle:_.downloadTitle,downloadUrl:u||x.initialPreviewDownloadUrl})).setTokens({filename:p,key:d})),n&&(f=x._getLayoutTemplate("actionZoom").setTokens({zoomClass:_.zoomClass,zoomIcon:_.zoomIcon,zoomTitle:_.zoomTitle})),o&&c&&(a="drag-handle-init "+_.dragClass,m=x._getLayoutTemplate("actionDrag").setTokens({dragClass:a,dragTitle:_.dragTitle,dragIcon:_.dragIcon})),b.setTokens({delete:h,upload:v,download:w,rotate:g,zoom:f,drag:m,other:C})):""},_browse:function(e){var t=this;e&&e.isDefaultPrevented()||!t._raise("filebrowse")||(t.isError&&!t.isAjaxUpload&&t.clear(),t.focusCaptionOnBrowse&&t.$captionContainer.focus())},_change:function(e){var n=this;if(H(document.body).off("focusin.fileinput focusout.fileinput"),n.changeTriggered)n._toggleLoading("hide");else{n._toggleLoading("show");var t,i,a,r=n.$element,o=n.isAjaxUpload,s=1<arguments.length?arguments[1]:r[0].files,l=n.fileManager.count(),r=W.isEmpty(r.attr("multiple")),d=!o&&r?1:n.maxFileCount,c=n.maxTotalFileCount,u=0<c&&d<c,r=r&&0<l,p=function(e,t,i,a){var r=H.extend(!0,{},n._getOutData(null,{},{},s),{id:i,index:a}),i={id:i,index:a,file:t,files:s};return n.isPersistentError=!0,n._toggleLoading("hide"),o?n._showFileError(e,r):n._showError(e,i)},f=function(e,t,i){i=(i=i?n.msgTotalFilesTooMany:n.msgFilesTooMany).replace("{m}",t).replace("{n}",e);n.isError=p(i,null,null,null),n.$captionContainer.removeClass("icon-visible"),n._setCaption("",!0),n.$container.removeClass("file-input-new file-input-ajax-new")};if(n.reader=null,n._resetUpload(),n._hideFileIcon(),n.dropZoneEnabled&&n.$container.find(".file-drop-zone ."+n.dropZoneTitleClass).remove(),e=s=o?s:e.target&&void 0===e.target.files?e.target.value?[{name:e.target.value.replace(/^.+\\/,"")}]:[]:e.target.files||{},W.isEmpty(e)||0===e.length)o||n.clear(),n._raise("fileselectnone");else{if(n._resetErrors(),a=e.length,i=o?n.fileManager.count()+a:a,t=n._getFileCount(i,!u&&void 0),0<d&&d<t){if(!n.autoReplace||d<a)return void f(n.autoReplace&&d<a?a:t,d);d<t&&n._resetPreviewThumbs(o)}else{if(u&&(t=n._getFileCount(i,!0),0<c)&&c<t){if(!n.autoReplace||d<a)return void f(n.autoReplace&&c<a?a:t,c,!0);d<t&&n._resetPreviewThumbs(o)}!o||r?(n._resetPreviewThumbs(!1),r&&n.clearFileStack()):!o||0!==l||n.previewCache.count(!0)&&!n.overwriteInitial||n._resetPreviewThumbs(!0)}n.autoReplace&&n._getThumbs().each(function(){var e=H(this);(e.hasClass("file-preview-success")||e.hasClass("file-preview-error"))&&e.remove()}),n.readFiles(e),n._toggleLoading("hide")}}},_abort:function(e){var t=this;return t.ajaxAborted&&"object"==typeof t.ajaxAborted&&void 0!==t.ajaxAborted.message?((e=H.extend(!0,{},t._getOutData(null),e)).abortData=t.ajaxAborted.data||{},e.abortMessage=t.ajaxAborted.message,t._setProgress(101,t.$progress,t.msgCancelled),t._showFileError(t.ajaxAborted.message,e,"filecustomerror"),t.cancel(),t.unlock(),!0):!!t.ajaxAborted},_resetFileStack:function(){var a=this,r=0;a._getThumbs().each(function(){var e=H(this),t=e.attr("data-fileindex"),i=e.attr("id");"-1"!==t&&-1!==t&&(a._getThumbFile(e)?e.attr({"data-fileindex":"-1"}):(e.attr({"data-fileindex":r}),r++),a._getZoom(i).attr({"data-fileindex":e.attr("data-fileindex")}))})},_isFileSelectionValid:function(e){var t=this;return e=e||0,t.required&&!t.getFilesCount()?(t.$errorContainer.html(""),t._showFileError(t.msgFileRequired),!1):!(0<t.minFileCount&&t._getFileCount(e)<t.minFileCount&&(t._noFilesError({}),1))},_canPreview:function(e){var t,i,a,r,n,o,s,l,d,c,u,p=this;return!(!(e&&p.showPreview&&p.$preview&&p.$preview.length)||(t=e.name||"",i=(e.size||0)/p.bytesToKB,a=p._parseFileType(e=e.type||"",t),d=p.allowedPreviewTypes,c=p.allowedPreviewMimeTypes,u=p.allowedPreviewExtensions||[],r=p.disabledPreviewTypes,n=p.disabledPreviewMimeTypes,o=p.disabledPreviewExtensions||[],p=p.maxFilePreviewSize&&parseFloat(p.maxFilePreviewSize)||0,s=new RegExp("\\.("+u.join("|")+")$","i"),l=new RegExp("\\.("+o.join("|")+")$","i"),d=!d||-1!==d.indexOf(a),c=!c||-1!==c.indexOf(e),u=!u.length||W.compare(t,s),r&&-1!==r.indexOf(a))||n&&-1!==n.indexOf(e)||o.length&&W.compare(t,l)||p&&!isNaN(p)&&p<i)&&(d||c||u)},addToStack:function(e,t){this.stackIsUpdating=!0,this.fileManager.add(e,t),this._refreshPreview(),this.stackIsUpdating=!1},clearFileStack:function(){var e=this;return e.fileManager.clear(),e._initResumableUpload(),e.enableResumableUpload?(null===e.showPause&&(e.showPause=!0),null===e.showCancel&&(e.showCancel=!1)):(e.showPause=!1,null===e.showCancel&&(e.showCancel=!0)),e.$element},getFileStack:function(){return this.fileManager.stack},getFileList:function(){return this.fileManager.list()},getFilesSize:function(){return this.fileManager.getTotalSize()},getFilesCount:function(e){var t=this,i=t.isAjaxUpload?t.fileManager.count():t._inputFileCount();return e&&(i+=t.previewCache.count(!0)),t._getFileCount(i)},_initCapStatus:function(e){var t=this.$caption;t.removeClass("is-valid file-processing"),e&&("processing"===e?t.addClass("file-processing"):t.addClass("is-valid"))},_toggleLoading:function(e){var t=this;W.setHtml(t.$previewStatus,"hide"===e?"":t.msgProcessing),t.$container.removeClass("file-thumb-loading"),t._initCapStatus("hide"===e?"":"processing"),"hide"!==e&&(t.dropZoneEnabled&&t.$container.find(".file-drop-zone ."+t.dropZoneTitleClass).remove(),t.$container.addClass("file-thumb-loading"))},_initFileSelected:function(){var e=this,t=e.$element,i=H(document.body),a="focusin.fileinput focusout.fileinput";i.length?i.off(a).on("focusout.fileinput",function(){e._toggleLoading("show")}).on("focusin.fileinput",function(){setTimeout(function(){t.val()||e._setFileDropZoneTitle(),i.off(a),e._toggleLoading("hide")},2500)}):e._toggleLoading("hide")},readFiles:function(S){this.reader=new FileReader;var I,E=this,A=E.reader,z=E.$previewContainer,D=E.$previewStatus,j=E.msgLoading,U=E.msgProgress,$=E.previewInitId,M=S.length,R=E.fileTypeSettings,B=E.allowedFileTypes,O=B?B.length:0,L=E.allowedFileExtensions,N=W.isEmpty(L)?"":L.join(", "),Z=function(e,t,i,a,r){var n=H.extend(!0,{},E._getOutData(null,{},{},S),{id:i,index:a,fileId:r}),r={id:i,index:a,fileId:r,file:t,files:S};Object.values(S).forEach(e=>{E._previewDefault(e,!0)}),t=E._getFrame(i,!0),E._toggleLoading("hide"),E.isAjaxUpload?setTimeout(function(){I(a+1)},E.processDelay):(E.unlock(),M=0),(E.removeFromPreviewOnError&&t.length?t:(E._initFileActions(),t.find(".kv-file-upload"))).remove(),E.isPersistentError=!0,E.isError=E.isAjaxUpload?E._showFileError(e,n):E._showError(e,r),E._updateFileDetails(M)};E.fileManager.clearImages(),H.each(S,function(e,t){var i=E.fileTypeSettings.image;i&&i(t.type)&&E.fileManager.totalImages++}),(I=function(d){var e=E.$errorContainer,i=E.fileManager;if(M<=d)E.unlock(),E.duplicateErrors.length&&(h="<li>"+E.duplicateErrors.join("</li><li>")+"</li>",0===e.find("ul").length?W.setHtml(e,E.errorCloseButton+"<ul>"+h+"</ul>"):(e.find("ul").append(W.cspBuffer.stash(h)),W.cspBuffer.apply(e)),e.fadeIn(E.fadeDelay),E._handler(e.find(".kv-error-close"),"click",function(){e.fadeOut(E.fadeDelay)}),E.duplicateErrors=[]),E.isAjaxUpload?(E._raise("filebatchselected",[i.stack]),0!==i.count()||E.isError||E.reset()):E._raise("filebatchselected",[S]),z.removeClass("file-thumb-loading"),E._initCapStatus("valid"),D.html("");else{E.lock(!0);var a,r,c,u,t,p,f,n,o,s,l,m,g=S[d],h=g&&g.size||0,v=E._getSize(h,!0),w=R.image,h=h/E.bytesToKB,b="",_=0,C="",x=!1,y=0,T=function(e){e=e||g,a=n=E._getFileId(g),r=$+"-"+a,f=W.createObjectURL(e),p=E._getFileName(g,"")},P=function(){var e=!!i.loadedImages[a],t=U.setTokens({index:d+1,files:M,percent:50,name:p});setTimeout(function(){W.setHtml(D,t),E._updateFileDetails(M),0<E.getFilesCount(!0)&&E.getFrames(":visible")&&E.$dropZone.find("."+E.dropZoneTitleClass).remove(),I(d+1)},E.processDelay),E._raise("fileloaded",[g,r,a,d,A])&&E.isAjaxUpload?e||i.add(g):e&&i.removeFile(a)};if(g){if(T(),0<O)for(u=0;u<O;u++)t=B[u],t=E.msgFileTypes[t]||t,C+=0===u?t:", "+t;if(!1===p)I(d+1);else if(0===p.length)m=E.msgInvalidFileName.replace("{name}",W.htmlEncode(W.getFileName(g),"[unknown]")),Z(m,g,r,d,n);else if(W.isEmpty(L)||(b=new RegExp("\\.("+L.join("|")+")$","i")),E.isAjaxUpload&&i.exists(n)||E._getFrame(r,!0).length)l={id:r,index:d,fileId:n,file:g,files:S},m=E.msgDuplicateFile.setTokens({name:p,size:v}),E.isAjaxUpload?(E.stackIsUpdating||(E.duplicateErrors.push(m),E.isDuplicateError=!0,E._raise("fileduplicateerror",[g,n,p,v,r,d])),I(d+1)):(E._showError(m,l),E.unlock(),M=0,E._clearFileInput(),E.reset()),E._updateFileDetails(M);else{if(0<E.maxMultipleFileSize&&1<S.length){var F=[],k=0;if(Object.values(S).forEach(e=>{k+=e.size/E.bytesToKB,F.push(e.name)}),k>E.maxMultipleFileSize)return m=E.msgMultipleSizeTooLarge.setTokens({name:F,size:E._getSize(k,!0),maxSize:E._getSize(E.maxMultipleFileSize*E.bytesToKB,!0)}),void Z(m,g,r,d,n)}else if(0<E.maxFileSize&&h>E.maxFileSize)return m=E.msgSizeTooLarge.setTokens({name:p,size:v,maxSize:E._getSize(E.maxFileSize*E.bytesToKB,!0)}),void Z(m,g,r,d,n);if(null!==E.minFileSize&&h<=W.getNum(E.minFileSize))m=E.msgSizeTooSmall.setTokens({name:p,size:v,minSize:E._getSize(E.minFileSize*E.bytesToKB,!0)}),Z(m,g,r,d,n);else{if(!W.isEmpty(B)&&W.isArray(B)){for(u=0;u<B.length;u+=1)s=B[u],_+=(s=R[s])&&"function"==typeof s&&s(g.type,W.getFileName(g))?1:0;if(0===_)return m=E.msgInvalidFileType.setTokens({name:p,types:C}),void Z(m,g,r,d,n)}0!==_||W.isEmpty(L)||!W.isArray(L)||W.isEmpty(b)||(l=W.compare(p,b),0!==(_+=W.isEmpty(l)?0:l.length))?E._canPreview(g)?(w(g.type,p),W.setHtml(D,j.replace("{index}",d+1).replace("{files}",M)),z.addClass("file-thumb-loading"),E._initCapStatus("processing"),A.onerror=function(e){E._errorHandler(e,p)},A.onload=function(a){function t(e,t){if(W.isEmpty(e)&&(n=W.arrayBuffer2String(A.result),e=W.isSvg(n)?"image/svg+xml":W.getMimeType(r,n,g.type)),l={name:p,type:e||""},t&&"undefined"!=typeof File)try{var i=l.filename=p+"."+t;c=new File([g],i,{type:l.type}),T(c)}catch(e){}w(e,"")?((t=new FileReader).onerror=function(e){E._errorHandler(e,p)},t.onload=function(e){E.isAjaxUpload&&!E._raise("filebeforeload",[g,d,A])?(x=!0,E._resetCaption(),A.abort(),D.html(""),z.removeClass("file-thumb-loading"),E._initCapStatus("valid"),E.enable()):(E._previewFile(d,g,e,f,l),E._initFileActions(),P())},t.readAsDataURL(g)):E.isAjaxUpload&&!E._raise("filebeforeload",[g,d,A])?(x=!0,E._resetCaption(),A.abort(),D.html(""),z.removeClass("file-thumb-loading"),E._initCapStatus("valid"),E.enable()):(E._previewFile(d,g,a,f,l),E._initFileActions(),P())}var r,e,i,n,o=[],s=g.type,l={name:p,type:s};if(H.each(R,function(e,t){"object"!==e&&"other"!==e&&"function"==typeof t&&t(s,p)&&y++}),"undefined"!=typeof FileTypeParser)e=new Uint8Array(a.target.result),(new FileTypeParser).parse(e).then(function(e){t(e&&e.mime||s,e&&e.ext||"")});else{if(0===y){for(e=new Uint8Array(a.target.result),u=0;u<e.length;u++)i=e[u].toString(16),o.push(i);r=o.join("").toLowerCase().substring(0,8),s=W.getMimeType(r,"","")}t(s)}},A.onprogress=function(e){e.lengthComputable&&(e=Math.ceil(e.loaded/e.total*100),m=U.setTokens({index:d+1,files:M,percent:e,name:p}),setTimeout(function(){x||W.setHtml(D,m)},E.processDelay))},A.readAsArrayBuffer(g)):(o=E._raise("filebeforeload",[g,d,A]),E.isAjaxUpload&&o&&i.add(g),E.showPreview&&o&&(z.addClass("file-thumb-loading"),E._initCapStatus("processing"),E._previewDefault(g),E._initFileActions()),setTimeout(function(){o&&E._updateFileDetails(M),I(d+1),E._raise("fileloaded",[g,r,a,d])},10)):(m=E.msgInvalidFileExtension.setTokens({name:p,extensions:N}),Z(m,g,r,d,n))}}}}})(0),E._updateFileDetails(M)},lock:function(e){var t=this,i=t.$container;return t._resetErrors(),t.disable(),!e&&t.showCancel&&i.find(".fileinput-cancel").show(),!e&&t.showPause&&i.find(".fileinput-pause").show(),t._initCapStatus("processing"),t._raise("filelock",[t.fileManager.stack,t._getExtraData()]),t.$element},unlock:function(e){var t=this,i=t.$container;return void 0===e&&(e=!0),t.enable(),i.removeClass("is-locked"),t.showCancel&&i.find(".fileinput-cancel").hide(),t.showPause&&i.find(".fileinput-pause").hide(),e&&t._resetFileStack(),t._initCapStatus(),t._raise("fileunlock",[t.fileManager.stack,t._getExtraData()]),t.$element},resume:function(){var e=this,t=e.fileManager,i=!1,a=e.resumableManager;return t.bpsLog=[],t.bps=0,e.enableResumableUpload&&(e.paused?e._toggleResumableProgress(e.progressPauseTemplate,e.msgUploadResume):i=!0,e.paused=!1,i&&e._toggleResumableProgress(e.progressInfoTemplate,e.msgUploadBegin),setTimeout(function(){a.upload()},e.processDelay)),e.$element},paste:function(e){var t=e.clipboardData||e.originalEvent.clipboardData;return this._addFilesFromSystem(e,t,"filePaste"),this.$element},pause:function(){var e,a=this,t=a.resumableManager,i=a.ajaxRequests,r=i.length,n=t.getProgress(),o=a.fileActionSettings,s=a.taskManager.getPool(t.id);if(a.enableResumableUpload){if(s&&s.cancel(),a._raise("fileuploadpaused",[a.fileManager,t]),0<r)for(e=0;e<r;e+=1)a.paused=!0,i[e].abort();a.showPreview&&a._getThumbs().each(function(){var e=H(this),t=a._getLayoutTemplate("stats"),i=e.find(".file-upload-indicator");e.removeClass("file-uploading"),i.attr("title")===o.indicatorLoadingTitle&&(a._setThumbStatus(e,"Paused"),i=t.setTokens({pendingTime:a.msgPaused,uploadSpeed:""}),a.paused=!0,a._setProgress(n,e.find(".file-thumb-progress"),n+"%",i)),a._getThumbFile(e)||e.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")}),a._setProgress(101,a.$progress,a.msgPaused)}return a.$element},cancel:function(){var e,i=this,t=i.ajaxRequests,a=i.resumableManager,r=a?i.taskManager.getPool(a.id):void 0,n=t.length;if(i.enableResumableUpload&&r?(r.cancel().done(function(){i._setProgressCancelled()}),a.reset(),i._raise("fileuploadcancelled",[i.fileManager,a])):(i.ajaxPool&&i.ajaxPool.cancel(),i._raise("fileuploadcancelled",[i.fileManager])),i._initAjax(),0<n)for(e=0;e<n;e+=1)i.cancelling=!0,t[e].abort();return i._getThumbs().each(function(){var e=H(this),t=e.find(".file-thumb-progress");e.removeClass("file-uploading"),i._setProgress(0,t),t.hide(),i._getThumbFile(e)||(e.find(".kv-file-upload").removeClass("disabled").removeAttr("disabled"),e.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")),i.unlock()}),setTimeout(function(){i._setProgressCancelled()},i.processDelay),i.$element},clear:function(){var e,t=this;if(t._raise("fileclear"))return t.clearInput=!0,t.$btnUpload.removeAttr("disabled"),t._getThumbs().find("video,audio,img").each(function(){W.cleanMemory(H(this))}),t._clearFileInput(),t._resetUpload(),t.clearFileStack(),t.isDuplicateError=!1,t.isPersistentError=!1,t._resetErrors(!0),t._hasInitialPreview()?(t._showFileIcon(),t._resetPreview(),t._initPreviewActions(),t.$container.removeClass("file-input-new")):(t._getThumbs().each(function(){t._clearObjects(H(this))}),t.isAjaxUpload&&(t.previewCache.data={}),t.$preview.html(""),e=!t.overwriteInitial&&0<t.initialCaption.length?t.initialCaption:"",t.$caption.attr("title","").val(e),W.addCss(t.$container,"file-input-new"),t._validateDefaultPreview()),0!==t.$container.find(W.FRAMES).length||t._initCaption()||t.$captionContainer.removeClass("icon-visible"),t._hideFileIcon(),t.focusCaptionOnClear&&t.$captionContainer.focus(),t._setFileDropZoneTitle(),t._raise("filecleared"),t.$element},reset:function(){var e=this;if(e._raise("filereset"))return e.lastProgress=0,e._resetPreview(),e.$container.find(".fileinput-filename").text(""),W.addCss(e.$container,"file-input-new"),e.getFrames().length&&e.$container.removeClass("file-input-new"),e.clearFileStack(),e._setFileDropZoneTitle(),e.$element},disable:function(){var e=this,t=e.$container;return e.isDisabled=!0,e._raise("filedisabled"),e.$element.attr("disabled","disabled"),t.addClass("is-locked"),W.addCss(t.find(".btn-file"),"disabled"),t.find(".kv-fileinput-caption").addClass("file-caption-disabled"),t.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").attr("disabled",!0),e._initDragDrop(),e.$element},enable:function(){var e=this,t=e.$container;return e.isDisabled=!1,e._raise("fileenabled"),e.$element.removeAttr("disabled"),t.removeClass("is-locked"),t.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),t.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").removeAttr("disabled"),t.find(".btn-file").removeClass("disabled"),e._initDragDrop(),e.$element},upload:function(){var i,e,a=this,t=a.fileManager,r=t.count(),n=a.taskManager,o=!H.isEmptyObject(a._getExtraData());if(t.bpsLog=[],t.bps=0,a.isAjaxUpload&&!a.isDisabled&&a._isFileSelectionValid(r))if(a.lastProgress=0,a._resetUpload(),0!==r||o)if(a.cancelling=!1,a.uploadInitiated=!0,a._showProgress(),a.lock(),0===r&&o)a._setProgress(2),a._uploadExtraOnly();else{if(a.enableResumableUpload)return a.resume();if(a.uploadAsync||a.enableResumableUpload){if(r=a._getOutData(null),!a._checkBatchPreupload(r))return;a.fileBatchCompleted=!1,a.uploadCache=[],H.each(a.getFileStack(),function(e){e=a._getThumbId(e);a.uploadCache.push({id:e,content:null,config:null,tags:null,append:!0})}),a.$preview.find(".file-preview-initial").removeClass(W.SORT_CSS),a._initSortable()}if(a._setProgress(2),a.hasInitData=!1,!a.uploadAsync)return a._uploadBatch(),a.$element;i=0,e=a.ajaxPool=n.addPool(W.uniqId()),H.each(a.getFileStack(),function(t){e.addTask(t+i,function(e){a._uploadSingle(i,t,!0,e)}),i++}),e.run(a.maxAjaxThreads).done(function(){a._log("Async upload batch completed successfully."),a._raise("filebatchuploadsuccess",[t.stack,a._getExtraData()])}).fail(function(){a._log("Async upload batch completed with errors."),a._raise("filebatchuploaderror",[t.stack,a._getExtraData()])})}else a._showFileError(a.msgUploadEmpty)},destroy:function(){var e=this,t=e.$form,i=e.$container,a=e.$element,r=e.namespace;return H(document).off(r),H(window).off(r),t&&t.length&&t.off(r),e.isAjaxUpload&&e._clearFileInput(),e._cleanup(),e._initPreviewCache(),a.insertBefore(i).off(r).removeData(),i.off().remove(),a},refresh:function(e){var t=this,i=t.$element;return e="object"!=typeof e||W.isEmpty(e)?t.options:H.extend(!0,{},t.options,e),t._init(e,!0),t._listen(),i},zoom:function(e){e=this._getFrame(e);this._showModal(e)},getExif:function(e){e=this._getFrame(e);return e&&e.data("exif")||null},getFrames:function(e){e=this.$preview.find(W.FRAMES+(e=e||""));return e=this.reversePreviewOrder?H(e.get().reverse()):e},getPreview:function(){return{content:this.initialPreview,config:this.initialPreviewConfig,tags:this.initialPreviewThumbTags}}},H.fn.fileinput=function(s){if(W.hasFileAPISupport()||W.isIE(9)){var l=Array.apply(null,arguments),d=[];switch(l.shift(),this.each(function(){var e={},t={},i=("object"==typeof s&&(e=H.extend(!0,{},H.fn.fileinput.defaults,s),t=s),H(this)),a=i.data("fileinput"),r=e.theme||i.data("theme")||H.fn.fileinput.defaults.theme,n={},o={},e=e.language||i.data("language")||H.fn.fileinput.defaults.language||"en";a||(r&&(o=H.fn.fileinputThemes[r]||{}),"en"!==e&&(W.isEmpty(H.fn.fileinputLocales[e])?1<(r=e.split("-",2)).length&&!W.isEmpty(H.fn.fileinputLocales[r[0]])&&(n=H.fn.fileinputLocales[r[0]]):n=H.fn.fileinputLocales[e]),r=H.extend(!0,{},H.fn.fileinput.defaults,o,H.fn.fileinputLocales.en,n,t,i.data()),a=new c(this,r),i.data("fileinput",a)),"string"==typeof s&&d.push(a[s].apply(a,l))}),d.length){case 0:return this;case 1:return d[0];default:return d}}};var W,c,e="btn btn-sm btn-kv "+W.defaultButtonCss(),t="btn "+W.defaultButtonCss();H.fn.fileinput.defaults={language:"en",bytesToKB:1024,showCaption:!0,showBrowse:!0,showPreview:!0,showRemove:!0,showUpload:!0,showUploadStats:!0,showCancel:null,showPause:null,showClose:!0,showUploadedThumbs:!0,showConsoleLogs:!1,browseOnZoneClick:!1,autoReplace:!1,showDescriptionClose:!0,autoOrientImage:function(){var e=window.navigator.userAgent,t=!!e.match(/WebKit/i);return!(!!e.match(/iP(od|ad|hone)/i)&&t&&!e.match(/CriOS/i))},autoOrientImageInitial:!0,showExifErrorLog:!1,required:!1,rtl:!1,hideThumbnailContent:!1,encodeUrl:!0,focusCaptionOnBrowse:!0,focusCaptionOnClear:!0,generateFileId:null,previewClass:"",captionClass:"",frameClass:"krajee-default",mainClass:"",inputGroupClass:"",mainTemplate:null,fileSizeGetter:null,initialCaption:"",initialPreview:[],initialPreviewDelimiter:"*$$*",initialPreviewAsData:!1,initialPreviewFileType:"image",initialPreviewConfig:[],initialPreviewThumbTags:[],previewThumbTags:{},initialPreviewShowDelete:!0,initialPreviewDownloadUrl:"",removeFromPreviewOnError:!1,deleteUrl:"",deleteExtraData:{},overwriteInitial:!0,sanitizeZoomCache:function(e){var t=W.createDiv();return W.setHtml(t,e),t.find("input,textarea,select,datalist,form,.file-thumbnail-footer").remove(),t.html()},previewZoomButtonIcons:{prev:'<i class="bi-chevron-left"></i>',next:'<i class="bi-chevron-right"></i>',rotate:'<i class="bi-arrow-clockwise"></i>',toggleheader:'<i class="bi-arrows-expand"></i>',fullscreen:'<i class="bi-arrows-fullscreen"></i>',borderless:'<i class="bi-arrows-angle-expand"></i>',close:'<i class="bi-x-lg"></i>'},previewZoomButtonClasses:{prev:"btn btn-default btn-outline-secondary btn-navigate",next:"btn btn-default btn-outline-secondary btn-navigate",rotate:e,toggleheader:e,fullscreen:e,borderless:e,close:e},previewTemplates:{},previewContentTemplates:{},preferIconicPreview:!1,preferIconicZoomPreview:!1,alwaysPreviewFileExtensions:[],rotatableFileExtensions:["jpg","jpeg","png","gif"],allowedFileTypes:null,allowedFileExtensions:null,allowedPreviewTypes:void 0,allowedPreviewMimeTypes:null,allowedPreviewExtensions:null,disabledPreviewTypes:void 0,disabledPreviewExtensions:["msi","exe","com","zip","rar","app","vb","scr"],disabledPreviewMimeTypes:null,defaultPreviewContent:null,customLayoutTags:{},customPreviewTags:{},previewFileIcon:'<i class="bi-file-earmark-fill"></i>',previewFileIconClass:"file-other-icon",previewFileIconSettings:{},previewFileExtSettings:{},buttonLabelClass:"hidden-xs",browseIcon:'<i class="bi-folder2-open"></i> ',browseClass:"btn btn-primary",removeIcon:'<i class="bi-trash"></i>',removeClass:t,cancelIcon:'<i class="bi-slash-circle"></i>',cancelClass:t,pauseIcon:'<i class="bi-pause-fill"></i>',pauseClass:t,uploadIcon:'<i class="bi-upload"></i>',uploadClass:t,uploadUrl:null,uploadUrlThumb:null,uploadAsync:!0,uploadParamNames:{chunkCount:"chunkCount",chunkIndex:"chunkIndex",chunkSize:"chunkSize",chunkSizeStart:"chunkSizeStart",chunksUploaded:"chunksUploaded",fileBlob:"fileBlob",fileId:"fileId",fileName:"fileName",fileRelativePath:"fileRelativePath",fileSize:"fileSize",retryCount:"retryCount"},maxAjaxThreads:5,fadeDelay:800,processDelay:100,bitrateUpdateDelay:500,queueDelay:10,progressDelay:0,enableResumableUpload:!1,resumableUploadOptions:{fallback:null,testUrl:null,chunkSize:2048,maxThreads:4,maxRetries:3,showErrorLog:!0,retainErrorHistory:!1,skipErrorsAndProceed:!1},uploadExtraData:{},zoomModalHeight:485,minImageWidth:null,minImageHeight:null,maxImageWidth:null,maxImageHeight:null,resizeImage:!1,resizePreference:"width",resizeQuality:.92,resizeDefaultImageType:"image/jpeg",resizeIfSizeMoreThan:0,minFileSize:-1,maxFileSize:0,maxMultipleFileSize:0,maxFilePreviewSize:25600,minFileCount:0,maxFileCount:0,maxTotalFileCount:0,validateInitialCount:!1,msgValidationErrorClass:"text-danger",msgValidationErrorIcon:'<i class="bi-exclamation-circle-fill"></i> ',msgErrorClass:"file-error-message",progressThumbClass:"progress-bar progress-bar-striped active progress-bar-animated",progressClass:"progress-bar bg-success progress-bar-success progress-bar-striped active progress-bar-animated",progressInfoClass:"progress-bar bg-info progress-bar-info progress-bar-striped active progress-bar-animated",progressCompleteClass:"progress-bar bg-success progress-bar-success",progressPauseClass:"progress-bar bg-primary progress-bar-primary progress-bar-striped active progress-bar-animated",progressErrorClass:"progress-bar bg-danger progress-bar-danger",progressUploadThreshold:99,previewFileType:"image",elCaptionContainer:null,elCaptionText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,errorCloseButton:void 0,slugCallback:null,dropZoneEnabled:!0,dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8",preProcessUpload:null,ajaxSettings:{},ajaxDeleteSettings:{},showAjaxErrorDetails:!0,mergeAjaxCallbacks:!1,mergeAjaxDeleteCallbacks:!1,retryErrorUploads:!0,reversePreviewOrder:!1,usePdfRenderer:function(){var e=!!window.MSInputMethodContext&&!!document.documentMode;return!!navigator.userAgent.match(/(iPod|iPhone|iPad|Android)/i)||e},pdfRendererUrl:"",pdfRendererTemplate:'<iframe class="kv-preview-data file-preview-pdf" src="{renderer}?file={data}" {style}></iframe>',tabIndexConfig:{browse:500,remove:500,upload:500,cancel:null,pause:null,modal:-1}},H.fn.fileinputLocales.en={sizeUnits:["B","KB","MB","GB","TB","PB","EB","ZB","YB"],bitRateUnits:["B/s","KB/s","MB/s","GB/s","TB/s","PB/s","EB/s","ZB/s","YB/s"],fileSingle:"file",filePlural:"files",browseLabel:"Browse &hellip;",removeLabel:"Remove",removeTitle:"Clear all unprocessed files",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",pauseLabel:"Pause",pauseTitle:"Pause ongoing upload",uploadLabel:"Upload",uploadTitle:"Upload selected files",msgNo:"No",msgNoFilesSelected:"No files selected",msgCancelled:"Cancelled",msgPaused:"Paused",msgPlaceholder:"Select {files} ...",msgZoomModalHeading:"Detailed Preview",msgFileRequired:"You must select a file to upload.",msgSizeTooSmall:'File "{name}" (<b>{size}</b>) is too small and must be larger than <b>{minSize}</b>.',msgSizeTooLarge:'File "{name}" (<b>{size}</b>) exceeds maximum allowed upload size of <b>{maxSize}</b>.',msgMultipleSizeTooLarge:'Files "{name}" (<b>{size}</b>) exceeds maximum allowed upload size of <b>{maxSize}</b>.',msgFilesTooLess:"You must select at least <b>{n}</b> {files} to upload.",msgFilesTooMany:"Number of files selected for upload <b>({n})</b> exceeds maximum allowed limit of <b>{m}</b>.",msgTotalFilesTooMany:"You can upload a maximum of <b>{m}</b> files (<b>{n}</b> files detected).",msgFileNotFound:'File "{name}" not found!',msgFileSecured:'Security restrictions prevent reading the file "{name}".',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileName:'Invalid or unsupported characters in file name "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgFileTypes:{image:"image",html:"HTML",text:"text",video:"video",audio:"audio",flash:"flash",pdf:"PDF",object:"object"},msgUploadAborted:"The file upload was aborted",msgUploadThreshold:"Processing &hellip;",msgUploadBegin:"Initializing &hellip;",msgUploadEnd:"Done",msgUploadResume:"Resuming upload &hellip;",msgUploadEmpty:"No valid data available for upload.",msgUploadError:"Upload Error",msgDeleteError:"Delete Error",msgProgressError:"Error",msgValidationError:"Validation Error",msgLoading:"Loading file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} {files} selected",msgProcessing:"Processing ...",msgFoldersNotAllowed:"Drag & drop files only! {n} folder(s) dropped were skipped.",msgImageWidthSmall:'Width of image file "{name}" must be at least <b>{size} px</b> (detected <b>{dimension} px</b>).',msgImageHeightSmall:'Height of image file "{name}" must be at least <b>{size} px</b> (detected <b>{dimension} px</b>).',msgImageWidthLarge:'Width of image file "{name}" cannot exceed <b>{size} px</b> (detected <b>{dimension} px</b>).',msgImageHeightLarge:'Height of image file "{name}" cannot exceed <b>{size} px</b> (detected <b>{dimension} px</b>).',msgImageResizeError:"Could not get the image dimensions to resize.",msgImageResizeException:"Error while resizing the image.<pre>{errors}</pre>",msgAjaxError:"Something went wrong with the {operation} operation. Please try again later!",msgAjaxProgressError:"{operation} failed",msgDuplicateFile:'File "{name}" of same size "{size}" has already been selected earlier. Skipping duplicate selection.',msgResumableUploadRetriesExceeded:"Upload aborted beyond <b>{max}</b> retries for file <b>{file}</b>! Error Details: <pre>{error}</pre>",msgPendingTime:"{time} remaining",msgCalculatingTime:"calculating time remaining",ajaxOperations:{deleteThumb:"file delete",uploadThumb:"file upload",uploadBatch:"batch file upload",uploadExtra:"form data upload"},dropZoneTitle:"Drag & drop files here &hellip;",dropZoneClickTitle:"<br>(or click to select {files})",previewZoomButtonTitles:{prev:"View previous file",next:"View next file",rotate:"Rotate 90 deg. clockwise",toggleheader:"Toggle header",fullscreen:"Toggle full screen",borderless:"Toggle borderless mode",close:"Close detailed preview"}},H.fn.fileinput.Constructor=c,H(document).ready(function(){var e=H("input.file[type=file]");e.length&&e.fileinput()})});