/*
 * Decompiled with CFR 0.152.
 */
package net.tootallnate.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.tootallnate.websocket.WebSocket;
import net.tootallnate.websocket.WebSocketListener;

public abstract class WebSocketClient
implements Runnable,
WebSocketListener {
    private URI uri;
    private WebSocket conn;
    private SocketChannel client;
    private Selector selector;
    private Draft draft;
    private int number1 = 0;
    private int number2 = 0;
    private byte[] key3 = null;

    public WebSocketClient(URI uRI, Draft draft) {
        this.uri = uRI;
        this.draft = draft;
    }

    public URI getURI() {
        return this.uri;
    }

    public void connect() {
        new Thread(this).start();
    }

    public void close() throws IOException {
        this.conn.close();
    }

    public void send(String string) throws IOException {
        this.conn.send(string);
    }

    @Override
    public void run() {
        int n = this.uri.getPort();
        if (n == -1) {
            n = 80;
        }
        try {
            this.client = SocketChannel.open();
            this.client.configureBlocking(false);
            this.client.connect(new InetSocketAddress(this.uri.getHost(), n));
            this.selector = Selector.open();
            this.conn = new WebSocket(this.client, new LinkedBlockingQueue<ByteBuffer>(), this);
            this.client.register(this.selector, 8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        while (true) {
            try {
                block6: while (true) {
                    this.selector.select();
                    Set<SelectionKey> set = this.selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (selectionKey.isConnectable()) {
                            if (this.client.isConnectionPending()) {
                                this.client.finishConnect();
                            }
                            this.client.register(this.selector, 1);
                            String string = "/" + this.uri.getPath();
                            String string2 = this.uri.getHost() + (n != 80 ? ":" + n : "");
                            String string3 = null;
                            String string4 = "GET " + string + " HTTP/1.1\r\n" + "Upgrade: WebSocket\r\n" + "Connection: Upgrade\r\n" + "Host: " + string2 + "\r\n" + "Origin: " + string3 + "\r\n";
                            if (this.draft == Draft.DRAFT76) {
                                string4 = string4 + "Sec-WebSocket-Key1: " + this.generateKey() + "\r\n";
                                string4 = string4 + "Sec-WebSocket-Key2: " + this.generateKey() + "\r\n";
                                this.key3 = new byte[8];
                                new Random().nextBytes(this.key3);
                            }
                            string4 = string4 + "\r\n";
                            this.conn.socketChannel().write(ByteBuffer.wrap(string4.getBytes(WebSocket.UTF8_CHARSET)));
                            if (this.key3 != null) {
                                this.conn.socketChannel().write(ByteBuffer.wrap(this.key3));
                            }
                        }
                        if (!selectionKey.isReadable()) continue;
                        this.conn.handleRead();
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
                continue;
            }
            break;
        }
    }

    private String generateKey() {
        int n;
        int n2;
        Random random = new Random();
        long l = 0xFFFFFFFFL;
        long l2 = random.nextInt(12) + 1;
        int n3 = new Long(l / l2).intValue();
        n3 = Math.abs(n3);
        int n4 = random.nextInt(n3) + 1;
        if (this.number1 == 0) {
            this.number1 = n4;
        } else {
            this.number2 = n4;
        }
        long l3 = (long)n4 * l2;
        String string = Long.toString(l3);
        int n5 = random.nextInt(12);
        for (n2 = 0; n2 < n5; ++n2) {
            n = random.nextInt(string.length());
            n = Math.abs(n);
            char c = (char)(random.nextInt(95) + 33);
            if (c >= '0' && c <= '9') {
                c = (char)(c - 15);
            }
            string = new StringBuilder(string).insert(n, c).toString();
        }
        n2 = 0;
        while ((long)n2 < l2) {
            n = random.nextInt(string.length() - 1) + 1;
            n = Math.abs(n);
            string = new StringBuilder(string).insert(n, " ").toString();
            ++n2;
        }
        return string;
    }

    @Override
    public boolean onHandshakeRecieved(WebSocket webSocket, String string, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        if (this.draft == Draft.DRAFT76) {
            if (byArray == null) {
                return false;
            }
            byte[] byArray2 = new byte[]{(byte)(this.number1 >> 24), (byte)(this.number1 << 8 >> 24), (byte)(this.number1 << 16 >> 24), (byte)(this.number1 << 24 >> 24), (byte)(this.number2 >> 24), (byte)(this.number2 << 8 >> 24), (byte)(this.number2 << 16 >> 24), (byte)(this.number2 << 24 >> 24), this.key3[0], this.key3[1], this.key3[2], this.key3[3], this.key3[4], this.key3[5], this.key3[6], this.key3[7]};
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = messageDigest.digest(byArray2);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray3[i] == byArray[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void onMessage(WebSocket webSocket, String string) {
        this.onMessage(string);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.onOpen();
    }

    @Override
    public void onClose(WebSocket webSocket) {
        this.onClose();
    }

    @Override
    public WebSocketListener.Draft getDraft() {
        return WebSocketListener.Draft.valueOf(this.draft.name());
    }

    public abstract void onMessage(String var1);

    public abstract void onOpen();

    public abstract void onClose();

    public static enum Draft {
        DRAFT75,
        DRAFT76;

    }
}

