/*
 * Decompiled with CFR 0.152.
 */
package net.tootallnate.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import net.tootallnate.websocket.WebSocket;
import net.tootallnate.websocket.WebSocketListener;

public abstract class WebSocketServer
implements Runnable,
WebSocketListener {
    private static final String FLASH_POLICY_REQUEST = "<policy-file-request/>\u0000";
    private final CopyOnWriteArraySet<WebSocket> connections = new CopyOnWriteArraySet();
    private int port;
    private ServerSocketChannel server;
    private WebSocketListener.Draft draft;

    public WebSocketServer() {
        this(80, WebSocketListener.Draft.AUTO);
    }

    public WebSocketServer(int n, WebSocketListener.Draft draft) {
        this.draft = draft;
        this.setPort(n);
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() throws IOException {
        for (WebSocket webSocket : this.connections) {
            webSocket.close();
        }
        this.server.close();
    }

    public void sendToAll(String string) throws IOException {
        for (WebSocket webSocket : this.connections) {
            webSocket.send(string);
        }
    }

    public void sendToAllExcept(WebSocket webSocket, String string) throws IOException {
        if (webSocket == null) {
            throw new NullPointerException("'connection' cannot be null");
        }
        for (WebSocket webSocket2 : this.connections) {
            if (webSocket.equals(webSocket2)) continue;
            webSocket2.send(string);
        }
    }

    public void sendToAllExcept(Set<WebSocket> set, String string) throws IOException {
        if (set == null) {
            throw new NullPointerException("'connections' cannot be null");
        }
        for (WebSocket webSocket : this.connections) {
            if (set.contains(webSocket)) continue;
            webSocket.send(string);
        }
    }

    public WebSocket[] connections() {
        return this.connections.toArray(new WebSocket[0]);
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public WebSocketListener.Draft getDraft() {
        return this.draft;
    }

    protected BlockingQueue<ByteBuffer> newBufferQueue() {
        return new LinkedBlockingQueue<ByteBuffer>();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            this.server.socket().bind(new InetSocketAddress(this.port));
            var1_1 = Selector.open();
            this.server.register(var1_1, this.server.validOps());
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    block7: while (true) {
                        var1_1.select(100L);
                        var2_4 = var1_1.selectedKeys();
                        var3_7 = var2_4.iterator();
                        while (var3_7.hasNext()) {
                            var4_8 = var3_7.next();
                            var3_7.remove();
                            if (var4_8.isAcceptable()) {
                                var5_9 = this.server.accept();
                                var5_9.configureBlocking(false);
                                var6_10 = new WebSocket((SocketChannel)var5_9, this.newBufferQueue(), this);
                                var5_9.register(var1_1, 1, var6_10);
                            }
                            if (var4_8.isReadable()) {
                                var5_9 = (WebSocket)var4_8.attachment();
                                var5_9.handleRead();
                            }
                            if (!var4_8.isWritable() || !(var5_9 = (WebSocket)var4_8.attachment()).handleWrite()) continue;
                            var5_9.socketChannel().register(var1_1, 1, var5_9);
                        }
                        var4_8 = this.connections.iterator();
                        while (true) {
                            if (!var4_8.hasNext()) continue block7;
                            var5_9 = (WebSocket)var4_8.next();
                            if (!var5_9.hasBufferedData()) continue;
                            var5_9.socketChannel().register(var1_1, 5, var5_9);
                        }
                        break;
                    }
                }
                catch (IOException var2_5) {
                    var2_5.printStackTrace();
                }
                catch (RuntimeException var2_6) {
                    var2_6.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException var1_2) {
            var1_2.printStackTrace();
        }
        catch (NoSuchAlgorithmException var1_3) {
            var1_3.printStackTrace();
        }
        ** GOTO lbl-1000
    }

    protected String getFlashSecurityPolicy() {
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + this.getPort() + "\" /></cross-domain-policy>";
    }

    @Override
    public boolean onHandshakeRecieved(WebSocket webSocket, String string, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        String[] stringArray;
        if (FLASH_POLICY_REQUEST.equals(string)) {
            String string2 = this.getFlashSecurityPolicy() + "\u0000";
            webSocket.socketChannel().write(ByteBuffer.wrap(string2.getBytes(WebSocket.UTF8_CHARSET)));
            return false;
        }
        String[] stringArray2 = string.split("\r\n");
        boolean bl = true;
        String string3 = stringArray2[0].trim();
        String string4 = null;
        if (!string3.startsWith("GET") || !string3.endsWith("HTTP/1.1")) {
            bl = false;
        } else {
            stringArray = string3.split(" ");
            string4 = stringArray[1];
        }
        stringArray = new Properties();
        for (int i = 1; i < stringArray2.length; ++i) {
            string3 = stringArray2[i];
            int n = string3.indexOf(":");
            if (n == -1) continue;
            stringArray.setProperty(string3.substring(0, n).trim(), string3.substring(n + 1).trim());
        }
        String string5 = stringArray.getProperty("Upgrade");
        if (string5 == null || !string5.equals("WebSocket")) {
            bl = false;
        }
        if ((string5 = stringArray.getProperty("Connection")) == null || !string5.equals("Upgrade")) {
            bl = false;
        }
        String string6 = stringArray.getProperty("Sec-WebSocket-Key1");
        String string7 = stringArray.getProperty("Sec-WebSocket-Key2");
        String string8 = "";
        byte[] byArray2 = null;
        switch (this.draft) {
            case DRAFT75: {
                if (string6 == null && string7 == null && byArray == null) break;
                bl = false;
                break;
            }
            case DRAFT76: {
                if (string6 != null && string7 != null && byArray != null) break;
                bl = false;
            }
        }
        if (bl) {
            Object object;
            if (string6 != null && string7 != null && byArray != null) {
                string8 = "Sec-";
                object = this.getPart(string6);
                byte[] byArray3 = this.getPart(string7);
                byte[] byArray4 = new byte[]{(byte)object[0], (byte)object[1], (byte)object[2], (byte)object[3], byArray3[0], byArray3[1], byArray3[2], byArray3[3], byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]};
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byArray2 = messageDigest.digest(byArray4);
            }
            object = "HTTP/1.1 101 Web Socket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\n";
            object = (String)object + string8 + "WebSocket-Origin: " + stringArray.getProperty("Origin") + "\r\n";
            object = (String)object + string8 + "WebSocket-Location: ws://" + stringArray.getProperty("Host") + string4 + "\r\n";
            if (stringArray.containsKey(string8 + "WebSocket-Protocol")) {
                object = (String)object + string8 + "WebSocket-Protocol: " + stringArray.getProperty("WebSocket-Protocol") + "\r\n";
            }
            if (stringArray.containsKey("Cookie")) {
                object = (String)object + "Cookie: " + stringArray.getProperty("Cookie") + "\r\n";
            }
            object = (String)object + "\r\n";
            webSocket.socketChannel().write(ByteBuffer.wrap(((String)object).getBytes()));
            if (byArray2 != null) {
                webSocket.socketChannel().write(ByteBuffer.wrap(byArray2));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMessage(WebSocket webSocket, String string) {
        this.onClientMessage(webSocket, string);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        if (this.connections.add(webSocket)) {
            this.onClientOpen(webSocket);
        }
    }

    @Override
    public void onClose(WebSocket webSocket) {
        if (this.connections.remove(webSocket)) {
            this.onClientClose(webSocket);
        }
    }

    private byte[] getPart(String string) {
        long l = Long.parseLong(string.replaceAll("[^0-9]", ""));
        long l2 = string.split(" ").length - 1;
        long l3 = new Long(l / l2);
        byte[] byArray = new byte[]{(byte)(l3 >> 24), (byte)(l3 << 8 >> 24), (byte)(l3 << 16 >> 24), (byte)(l3 << 24 >> 24)};
        return byArray;
    }

    public abstract void onClientOpen(WebSocket var1);

    public abstract void onClientClose(WebSocket var1);

    public abstract void onClientMessage(WebSocket var1, String var2);
}

