//
// MessagePack for Java
//
// Copyright (C) 2009-2010 FURUHASHI Sadayuki
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
package org.msgpack.object;

import java.util.List;
import java.util.Arrays;
import java.io.IOException;
import org.msgpack.*;

public class ArrayType extends MessagePackObject {
	private MessagePackObject[] array;

	ArrayType(MessagePackObject[] array) {
		this.array = array;
	}

	public static ArrayType create(MessagePackObject[] array) {
		return new ArrayType(array);
	}

	@Override
	public boolean isArrayType() {
		return true;
	}

	@Override
	public MessagePackObject[] asArray() {
		return array;
	}

	@Override
	public List<MessagePackObject> asList() {
		return Arrays.asList(array);
	}

	@Override
	public void messagePack(Packer pk) throws IOException {
		pk.packArray(array.length);
		for(int i=0; i < array.length; i++) {
			array[i].messagePack(pk);
		}
	}

	@Override
	public boolean equals(Object obj) {
		if(obj.getClass() != getClass()) {
			return false;
		}
		return Arrays.equals(((ArrayType)obj).array, array);
	}

	@Override
	public int hashCode() {
		return array.hashCode();
	}

	@Override
	public Object clone() {
		MessagePackObject[] copy = new MessagePackObject[array.length];
		for(int i=0; i < array.length; i++) {
			copy[i] = (MessagePackObject)array[i].clone();
		}
		return copy;
	}
}

