## API Report File for "@angular-devkit/architect"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { BaseException } from '@angular-devkit/core';
import { json } from '@angular-devkit/core';
import { JsonObject } from '@angular-devkit/core';
import { JsonValue } from '@angular-devkit/core';
import { logging } from '@angular-devkit/core';
import { Observable } from 'rxjs';
import { ObservableInput } from 'rxjs';
import { Observer } from 'rxjs';
import { schema } from '@angular-devkit/core';

// @public (undocumented)
export class Architect {
    constructor(_host: ArchitectHost, registry?: json.schema.SchemaRegistry, additionalJobRegistry?: Registry);
    // (undocumented)
    has(name: JobName): Observable<boolean>;
    // (undocumented)
    scheduleBuilder(name: string, options: json.JsonObject, scheduleOptions?: ScheduleOptions): Promise<BuilderRun>;
    // (undocumented)
    scheduleTarget(target: Target, overrides?: json.JsonObject, scheduleOptions?: ScheduleOptions): Promise<BuilderRun>;
}

// @public
export interface Builder<OptionT extends json.JsonObject = json.JsonObject> {
    // (undocumented)
    [BuilderSymbol]: true;
    // (undocumented)
    [BuilderVersionSymbol]: string;
    // (undocumented)
    __OptionT: OptionT;
    // (undocumented)
    handler: JobHandler<json.JsonObject, BuilderInput, BuilderOutput>;
}

// @public
export interface BuilderContext {
    addTeardown(teardown: () => Promise<void> | void): void;
    builder: BuilderInfo;
    currentDirectory: string;
    getBuilderNameForTarget(target: Target): Promise<string>;
    // (undocumented)
    getProjectMetadata(projectName: string): Promise<json.JsonObject>;
    // (undocumented)
    getProjectMetadata(target: Target): Promise<json.JsonObject>;
    getTargetOptions(target: Target): Promise<json.JsonObject>;
    id: number;
    logger: logging.LoggerApi;
    reportProgress(current: number, total?: number, status?: string): void;
    reportRunning(): void;
    reportStatus(status: string): void;
    scheduleBuilder(builderName: string, options?: json.JsonObject, scheduleOptions?: ScheduleOptions_2): Promise<BuilderRun>;
    scheduleTarget(target: Target, overrides?: json.JsonObject, scheduleOptions?: ScheduleOptions_2): Promise<BuilderRun>;
    target?: Target;
    validateOptions<T extends json.JsonObject = json.JsonObject>(options: json.JsonObject, builderName: string): Promise<T>;
    workspaceRoot: string;
}

// @public
export interface BuilderHandlerFn<A> {
    (input: A, context: BuilderContext): BuilderOutputLike;
}

// @public
export type BuilderInfo = json.JsonObject & {
    builderName: string;
    description: string;
    optionSchema: json.schema.JsonSchema;
};

// @public
export type BuilderInput = json.JsonObject & Schema;

// @public (undocumented)
export type BuilderOutput = json.JsonObject & Schema_2;

// @public
export type BuilderOutputLike = ObservableInput<BuilderOutput> | BuilderOutput;

// @public (undocumented)
export type BuilderProgress = json.JsonObject & Schema_3 & TypedBuilderProgress;

// @public
export type BuilderProgressReport = BuilderProgress & {
    target?: Target;
    builder: BuilderInfo;
};

// @public (undocumented)
export enum BuilderProgressState {
    // (undocumented)
    Error = "error",
    // (undocumented)
    Running = "running",
    // (undocumented)
    Stopped = "stopped",
    // (undocumented)
    Waiting = "waiting"
}

// @public (undocumented)
export type BuilderRegistry = Registry<json.JsonObject, BuilderInput, BuilderOutput>;

// @public
export interface BuilderRun {
    id: number;
    info: BuilderInfo;
    lastOutput: Promise<BuilderOutput>;
    output: Observable<BuilderOutput>;
    progress: Observable<BuilderProgressReport>;
    result: Promise<BuilderOutput>;
    stop(): Promise<void>;
}

// @public (undocumented)
class ChannelAlreadyExistException extends BaseException {
    constructor(name: string);
}

// @public (undocumented)
export function createBuilder<OptT = json.JsonObject, OutT extends BuilderOutput = BuilderOutput>(fn: BuilderHandlerFn<OptT>): Builder<OptT & json.JsonObject>;

// @public
function createDispatcher<A extends JsonValue, I extends JsonValue, O extends JsonValue>(options?: Partial<Readwrite<JobDescription>>): JobDispatcher<A, I, O>;

// @public
function createJobFactory<A extends JsonValue, I extends JsonValue, O extends JsonValue>(loader: () => Promise<JobHandler<A, I, O>>, options?: Partial<JobDescription>): JobHandler<A, I, O>;

// @public
function createJobHandler<A extends JsonValue, I extends JsonValue, O extends JsonValue>(fn: SimpleJobHandlerFn<A, I, O>, options?: Partial<JobDescription>): JobHandler<A, I, O>;

// @public
function createLoggerJob<A extends JsonValue, I extends JsonValue, O extends JsonValue>(job: JobHandler<A, I, O>, logger: logging.LoggerApi): JobHandler<A, I, O>;

// @public
class FallbackRegistry<MinimumArgumentValueT extends JsonValue = JsonValue, MinimumInputValueT extends JsonValue = JsonValue, MinimumOutputValueT extends JsonValue = JsonValue> implements Registry<MinimumArgumentValueT, MinimumInputValueT, MinimumOutputValueT> {
    constructor(_fallbacks?: Registry<MinimumArgumentValueT, MinimumInputValueT, MinimumOutputValueT>[]);
    // (undocumented)
    addFallback(registry: Registry): void;
    // (undocumented)
    protected _fallbacks: Registry<MinimumArgumentValueT, MinimumInputValueT, MinimumOutputValueT>[];
    // (undocumented)
    get<A extends MinimumArgumentValueT = MinimumArgumentValueT, I extends MinimumInputValueT = MinimumInputValueT, O extends MinimumOutputValueT = MinimumOutputValueT>(name: JobName): Observable<JobHandler<A, I, O> | null>;
}

// @public (undocumented)
export function fromAsyncIterable<T>(iterable: AsyncIterable<T>): Observable<T>;

// @public (undocumented)
export function isBuilderOutput(obj: any): obj is BuilderOutput;

// @public (undocumented)
function isJobHandler<A extends JsonValue, I extends JsonValue, O extends JsonValue>(value: unknown): value is JobHandler<A, I, O>;

// @public
interface Job<ArgumentT extends JsonValue = JsonValue, InputT extends JsonValue = JsonValue, OutputT extends JsonValue = JsonValue> {
    readonly argument: ArgumentT;
    readonly description: Observable<JobDescription>;
    getChannel<T extends JsonValue>(name: string, schema?: schema.JsonSchema): Observable<T>;
    readonly inboundBus: Observer<JobInboundMessage<InputT>>;
    readonly input: Observer<InputT>;
    readonly outboundBus: Observable<JobOutboundMessage<OutputT>>;
    readonly output: Observable<OutputT>;
    ping(): Observable<never>;
    readonly state: JobState;
    stop(): void;
}

// @public (undocumented)
class JobArgumentSchemaValidationError extends schema.SchemaValidationException {
    constructor(errors?: schema.SchemaValidatorError[]);
}

// @public
interface JobDescription extends JsonObject {
    // (undocumented)
    readonly argument: DeepReadonly<schema.JsonSchema>;
    // (undocumented)
    readonly input: DeepReadonly<schema.JsonSchema>;
    // (undocumented)
    readonly name: JobName;
    // (undocumented)
    readonly output: DeepReadonly<schema.JsonSchema>;
}

// @public
interface JobDispatcher<A extends JsonValue, I extends JsonValue, O extends JsonValue> extends JobHandler<A, I, O> {
    addConditionalJob(predicate: (args: A) => boolean, name: string): void;
    setDefaultJob(name: JobName | null | JobHandler<JsonValue, JsonValue, JsonValue>): void;
}

// @public (undocumented)
class JobDoesNotExistException extends BaseException {
    constructor(name: JobName);
}

// @public
interface JobHandler<ArgT extends JsonValue, InputT extends JsonValue, OutputT extends JsonValue> {
    // (undocumented)
    (argument: ArgT, context: JobHandlerContext<ArgT, InputT, OutputT>): Observable<JobOutboundMessage<OutputT>>;
    // (undocumented)
    jobDescription: Partial<JobDescription>;
}

// @public
interface JobHandlerContext<MinimumArgumentValueT extends JsonValue = JsonValue, MinimumInputValueT extends JsonValue = JsonValue, MinimumOutputValueT extends JsonValue = JsonValue> {
    // (undocumented)
    readonly dependencies: Job<JsonValue, JsonValue, JsonValue>[];
    // (undocumented)
    readonly description: JobDescription;
    // (undocumented)
    readonly inboundBus: Observable<JobInboundMessage<MinimumInputValueT>>;
    // (undocumented)
    readonly scheduler: Scheduler<JsonValue, JsonValue, JsonValue>;
}

// @public (undocumented)
type JobInboundMessage<InputT extends JsonValue> = JobInboundMessagePing | JobInboundMessageStop | JobInboundMessageInput<InputT>;

// @public
interface JobInboundMessageBase extends JsonObject {
    readonly kind: JobInboundMessageKind;
}

// @public
interface JobInboundMessageInput<InputT extends JsonValue> extends JobInboundMessageBase {
    // (undocumented)
    readonly kind: JobInboundMessageKind.Input;
    readonly value: InputT;
}

// @public
enum JobInboundMessageKind {
    // (undocumented)
    Input = "in",
    // (undocumented)
    Ping = "ip",
    // (undocumented)
    Stop = "is"
}

// @public
interface JobInboundMessagePing extends JobInboundMessageBase {
    readonly id: number;
    // (undocumented)
    readonly kind: JobInboundMessageKind.Ping;
}

// @public (undocumented)
class JobInboundMessageSchemaValidationError extends schema.SchemaValidationException {
    constructor(errors?: schema.SchemaValidatorError[]);
}

// @public
interface JobInboundMessageStop extends JobInboundMessageBase {
    // (undocumented)
    readonly kind: JobInboundMessageKind.Stop;
}

// @public
type JobName = string;

// @public (undocumented)
class JobNameAlreadyRegisteredException extends BaseException {
    constructor(name: JobName);
}

// @public
type JobOutboundMessage<OutputT extends JsonValue> = JobOutboundMessageOnReady | JobOutboundMessageStart | JobOutboundMessageOutput<OutputT> | JobOutboundMessageChannelCreate | JobOutboundMessageChannelMessage | JobOutboundMessageChannelError | JobOutboundMessageChannelComplete | JobOutboundMessageEnd | JobOutboundMessagePong;

// @public
interface JobOutboundMessageBase {
    readonly description: JobDescription;
    readonly kind: JobOutboundMessageKind;
}

// @public
interface JobOutboundMessageChannelBase extends JobOutboundMessageBase {
    readonly name: string;
}

// @public
interface JobOutboundMessageChannelComplete extends JobOutboundMessageChannelBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.ChannelComplete;
}

// @public
interface JobOutboundMessageChannelCreate extends JobOutboundMessageChannelBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.ChannelCreate;
}

// @public
interface JobOutboundMessageChannelError extends JobOutboundMessageChannelBase {
    readonly error: JsonValue;
    // (undocumented)
    readonly kind: JobOutboundMessageKind.ChannelError;
}

// @public
interface JobOutboundMessageChannelMessage extends JobOutboundMessageChannelBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.ChannelMessage;
    readonly message: JsonValue;
}

// @public
interface JobOutboundMessageEnd extends JobOutboundMessageBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.End;
}

// @public
enum JobOutboundMessageKind {
    // (undocumented)
    ChannelComplete = "cc",
    // (undocumented)
    ChannelCreate = "cn",
    // (undocumented)
    ChannelError = "ce",
    // (undocumented)
    ChannelMessage = "cm",
    // (undocumented)
    End = "e",
    // (undocumented)
    OnReady = "c",
    // (undocumented)
    Output = "o",
    // (undocumented)
    Pong = "p",
    // (undocumented)
    Start = "s"
}

// @public
interface JobOutboundMessageOnReady extends JobOutboundMessageBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.OnReady;
}

// @public
interface JobOutboundMessageOutput<OutputT extends JsonValue> extends JobOutboundMessageBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.Output;
    readonly value: OutputT;
}

// @public
interface JobOutboundMessagePong extends JobOutboundMessageBase {
    readonly id: number;
    // (undocumented)
    readonly kind: JobOutboundMessageKind.Pong;
}

// @public
interface JobOutboundMessageStart extends JobOutboundMessageBase {
    // (undocumented)
    readonly kind: JobOutboundMessageKind.Start;
}

// @public (undocumented)
class JobOutputSchemaValidationError extends schema.SchemaValidationException {
    constructor(errors?: schema.SchemaValidatorError[]);
}

declare namespace jobs {
    export {
        strategy,
        isJobHandler,
        JobName,
        JobHandler,
        JobHandlerContext,
        JobDescription,
        JobInboundMessageKind,
        JobInboundMessageBase,
        JobInboundMessagePing,
        JobInboundMessageStop,
        JobInboundMessageInput,
        JobInboundMessage,
        JobOutboundMessageKind,
        JobOutboundMessageBase,
        JobOutboundMessageOnReady,
        JobOutboundMessageStart,
        JobOutboundMessageOutput,
        JobOutboundMessageChannelBase,
        JobOutboundMessageChannelMessage,
        JobOutboundMessageChannelError,
        JobOutboundMessageChannelCreate,
        JobOutboundMessageChannelComplete,
        JobOutboundMessageEnd,
        JobOutboundMessagePong,
        JobOutboundMessage,
        JobState,
        Job,
        ScheduleJobOptions,
        Registry,
        Scheduler,
        createJobHandler,
        createJobFactory,
        createLoggerJob,
        ChannelAlreadyExistException,
        SimpleJobHandlerContext,
        SimpleJobHandlerFn,
        JobNameAlreadyRegisteredException,
        JobDoesNotExistException,
        createDispatcher,
        JobDispatcher,
        FallbackRegistry,
        RegisterJobOptions,
        SimpleJobRegistry,
        JobArgumentSchemaValidationError,
        JobInboundMessageSchemaValidationError,
        JobOutputSchemaValidationError,
        SimpleScheduler
    }
}
export { jobs }

// @public
enum JobState {
    Ended = "ended",
    Errored = "errored",
    Queued = "queued",
    Ready = "ready",
    Started = "started"
}

// @public (undocumented)
type JobStrategy<A extends JsonValue = JsonValue, I extends JsonValue = JsonValue, O extends JsonValue = JsonValue> = (handler: JobHandler<A, I, O>, options?: Partial<Readonly<JobDescription>>) => JobHandler<A, I, O>;

// @public
function memoize<A extends JsonValue = JsonValue, I extends JsonValue = JsonValue, O extends JsonValue = JsonValue>(replayMessages?: boolean): JobStrategy<A, I, O>;

// @public
interface RegisterJobOptions extends Partial<JobDescription> {
}

// @public (undocumented)
interface Registry<MinimumArgumentValueT extends JsonValue = JsonValue, MinimumInputValueT extends JsonValue = JsonValue, MinimumOutputValueT extends JsonValue = JsonValue> {
    get<A extends MinimumArgumentValueT, I extends MinimumInputValueT, O extends MinimumOutputValueT>(name: JobName): Observable<JobHandler<A, I, O> | null>;
}

// @public
function reuse<A extends JsonValue = JsonValue, I extends JsonValue = JsonValue, O extends JsonValue = JsonValue>(replayMessages?: boolean): JobStrategy<A, I, O>;

// @public
interface ScheduleJobOptions {
    dependencies?: Job | Job[];
}

// @public (undocumented)
export interface ScheduleOptions {
    // (undocumented)
    logger?: logging.Logger;
}

// @public
interface Scheduler<MinimumArgumentValueT extends JsonValue = JsonValue, MinimumInputValueT extends JsonValue = JsonValue, MinimumOutputValueT extends JsonValue = JsonValue> {
    getDescription(name: JobName): Observable<JobDescription | null>;
    has(name: JobName): Observable<boolean>;
    pause(): () => void;
    schedule<A extends MinimumArgumentValueT, I extends MinimumInputValueT, O extends MinimumOutputValueT>(name: JobName, argument: A, options?: ScheduleJobOptions): Job<A, I, O>;
}

// @public
export function scheduleTargetAndForget(context: BuilderContext, target: Target, overrides?: json.JsonObject, scheduleOptions?: ScheduleOptions_2): Observable<BuilderOutput>;

// @public
function serialize<A extends JsonValue = JsonValue, I extends JsonValue = JsonValue, O extends JsonValue = JsonValue>(): JobStrategy<A, I, O>;

// @public
interface SimpleJobHandlerContext<A extends JsonValue, I extends JsonValue, O extends JsonValue> extends JobHandlerContext<A, I, O> {
    // (undocumented)
    addTeardown(teardown: () => Promise<void> | void): void;
    // (undocumented)
    createChannel: (name: string) => Observer<JsonValue>;
    // (undocumented)
    input: Observable<I>;
}

// @public
type SimpleJobHandlerFn<A extends JsonValue, I extends JsonValue, O extends JsonValue> = (input: A, context: SimpleJobHandlerContext<A, I, O>) => O | Promise<O> | Observable<O>;

// @public
class SimpleJobRegistry<MinimumArgumentValueT extends JsonValue = JsonValue, MinimumInputValueT extends JsonValue = JsonValue, MinimumOutputValueT extends JsonValue = JsonValue> implements Registry<MinimumArgumentValueT, MinimumInputValueT, MinimumOutputValueT> {
    // (undocumented)
    get<A extends MinimumArgumentValueT = MinimumArgumentValueT, I extends MinimumInputValueT = MinimumInputValueT, O extends MinimumOutputValueT = MinimumOutputValueT>(name: JobName): Observable<JobHandler<A, I, O> | null>;
    getJobNames(): JobName[];
    register<A extends MinimumArgumentValueT, I extends MinimumInputValueT, O extends MinimumOutputValueT>(name: JobName, handler: JobHandler<A, I, O>, options?: RegisterJobOptions): void;
    register<ArgumentT extends JsonValue, InputT extends JsonValue, OutputT extends JsonValue>(handler: JobHandler<ArgumentT, InputT, OutputT>, options?: RegisterJobOptions & {
        name: string;
    }): void;
    // (undocumented)
    protected _register<ArgumentT extends JsonValue, InputT extends JsonValue, OutputT extends JsonValue>(name: JobName, handler: JobHandler<ArgumentT, InputT, OutputT>, options: RegisterJobOptions): void;
}

// @public
class SimpleScheduler<MinimumArgumentT extends JsonValue = JsonValue, MinimumInputT extends JsonValue = JsonValue, MinimumOutputT extends JsonValue = JsonValue> implements Scheduler<MinimumArgumentT, MinimumInputT, MinimumOutputT> {
    constructor(_jobRegistry: Registry<MinimumArgumentT, MinimumInputT, MinimumOutputT>, _schemaRegistry?: schema.SchemaRegistry);
    getDescription(name: JobName): Observable<JobDescription | null>;
    has(name: JobName): Observable<boolean>;
    // (undocumented)
    protected _jobRegistry: Registry<MinimumArgumentT, MinimumInputT, MinimumOutputT>;
    pause(): () => void;
    schedule<A extends MinimumArgumentT, I extends MinimumInputT, O extends MinimumOutputT>(name: JobName, argument: A, options?: ScheduleJobOptions): Job<A, I, O>;
    // (undocumented)
    protected _scheduleJob<A extends MinimumArgumentT, I extends MinimumInputT, O extends MinimumOutputT>(name: JobName, argument: A, options: ScheduleJobOptions, waitable: Observable<never>): Job<A, I, O>;
    // (undocumented)
    protected _schemaRegistry: schema.SchemaRegistry;
}

declare namespace strategy {
    export {
        serialize,
        reuse,
        memoize,
        JobStrategy
    }
}

// @public (undocumented)
export type Target = json.JsonObject & Target_2;

// @public
export function targetFromTargetString(specifier: string, abbreviatedProjectName?: string, abbreviatedTargetName?: string): Target;

// @public
export function targetStringFromTarget({ project, target, configuration }: Target): string;

// @public
export type TypedBuilderProgress = {
    state: BuilderProgressState.Stopped;
} | {
    state: BuilderProgressState.Error;
    error: json.JsonValue;
} | {
    state: BuilderProgressState.Waiting;
    status?: string;
} | {
    state: BuilderProgressState.Running;
    status?: string;
    current: number;
    total?: number;
};

// (No @packageDocumentation comment for this package)

```
