"""Filtering functions"""

def convolve(r, c=None):
    """
    :param ulab.array a:
    :param ulab.array v:

    Returns the discrete, linear convolution of two one-dimensional sequences.
    The result is always an array of float.  Only the ``full`` mode is supported,
    and the ``mode`` named parameter of numpy is not accepted. Note that all other
    modes can be had by slicing a ``full`` result.

    Convolution filters can implement high pass, low pass, band pass, etc.,
    filtering operations.  Convolution filters are typically constructed ahead
    of time.  This can be done using desktop python with scipy, or on web pages
    such as https://fiiir.com/

    Convolution is most time-efficient when both inputs are of float type."""
    ...

def sosfilt(sos : ulab.array, x : ulab.array, *, xi : Optional[ulab.array] = None) -> Union[ulab.array, Tuple[ulab.array, ulab.array]]:
    """
    :param ulab.array sos: Array of second-order filter coefficients, must have shape (n_sections, 6). Each row corresponds to a second-order section, with the first three columns providing the numerator coefficients and the last three providing the denominator coefficients.
    :param ulab.array x: The data to be filtered
    :param ulab.array zi: Optional initial conditions for the filter

    :return: If ``xi`` is not specified, the filter result alone is returned.  If ``xi`` is specified, the return value is a 2-tuple of the filter result and the final filter conditions.

    Filter data along one dimension using cascaded second-order sections.

    Filter a data sequence, x, using a digital IIR filter defined by sos.

    The filter function is implemented as a series of second-order filters with direct-form II transposed structure. It is designed to minimize numerical precision errors for high-order filters.

    Filter coefficients can be generated by using scipy's filter generators such as ``signal.ellip(..., output='sos')``."""
    ...
