# Contributing
Please note that this project is released with a
[Contributor Code of Conduct](https://github.com/adafruit/circuitpython/blob/main/CODE_OF_CONDUCT.md).
By participating in this project you agree to abide by its terms. Participation
covers any forum used to converse about CircuitPython including unofficial and official spaces. Failure to do
so will result in corrective actions such as time out or ban from the project.

## Licensing
By contributing to this repository you are certifying that you have all necessary
permissions to license the code under an MIT License. You still retain the
copyright but are granting many permissions under the MIT License.

If you have an employment contract with your employer please make sure that they
don't automatically own your work product. Make sure to get any necessary approvals
before contributing. Another term for this contribution off-hours is moonlighting.

## Ways to contribute
As CircuitPython grows, there are more and more ways to contribute. Here are some ideas:

* Build a project with CircuitPython and share how to do it online.
* Test the latest libraries and CircuitPython versions with your projects and file issues for any bugs you find.
* Contribute Python code to CircuitPython libraries that support new devices or features of an existing device.
* Contribute C code to CircuitPython which fixes an open issue or adds a new feature.

## Getting started with C
CircuitPython developer Dan Halbert (@dhalbert) has written up build instructions using native build
tools [here](https://learn.adafruit.com/building-circuitpython).

For SAMD21 debugging workflow tips check out [this learn guide](https://learn.adafruit.com/debugging-the-samd21-with-gdb) from Scott (@tannewt).

## Developer contacts
Scott Shawcroft ([@tannewt](https://github.com/tannewt)) is the lead developer of CircuitPython
and is sponsored by [Adafruit Industries LLC](https://adafruit.com). Scott is usually available
during US West Coast working hours. Dan Halbert ([@dhalbert](https://github.com/dhalbert)) and
Kattni Rembor ([@kattni](https://github.com/kattni)) are also sponsored by [Adafruit Industries
 LLC](https://adafruit.com) and are usually available during US East Coast daytime hours including
some weekends.

They are all reachable on [Discord](https://adafru.it/discord), GitHub issues and the [Adafruit
support forum](https://forums.adafruit.com/viewforum.php?f=60).

## Code guidelines
We aim to keep our code and commit style compatible with MicroPython upstream.
Please review their
[code conventions](https://github.com/micropython/micropython/blob/master/CODECONVENTIONS.md) to do so.
Familiarity with their [design philosophy](https://github.com/micropython/micropython/wiki/ContributorGuidelines)
is also useful though not always applicable to CircuitPython.

Furthermore, CircuitPython has a
[design guide](https://circuitpython.readthedocs.io/en/latest/docs/design_guide.html)
that covers a variety of different topics. Please read it as well.
