#!/usr/bin/env bats

load test_helpers

. $(dirname $BATS_TEST_DIRNAME)/lib/commands/install.sh
. $(dirname $BATS_TEST_DIRNAME)/lib/commands/list.sh

setup() {
  setup_asdf_dir
  install_dummy_plugin
}

teardown() {
  clean_asdf_dir
}

@test "list_command should list plugins with installed versions" {
  run install_command dummy 1.0
  run install_command dummy 1.1
  run list_command
  [ "$(echo -e "dummy\n  1.0\n  1.1")" == "$output" ]
  [ "$status" -eq 0 ]
}

@test "list_command should continue listing even when no version is installed for any of the plugins" {
  run install_mock_plugin "dummy"
  run install_mock_plugin "mummy"
  run install_mock_plugin "tummy"
  run install_command dummy 1.0
  run install_command tummy 2.0
  run list_command
  [ "$(echo -e "dummy\n  1.0\nmummy\nNo versions installed\ntummy\n  2.0")" == "$output" ]
  [ "$status" -eq 0 ]
}

@test "list_command with plugin should list installed versions" {
  run install_command dummy 1.0
  run install_command dummy 1.1
  run list_command dummy
  [ "$(echo -e "  1.0\n  1.1")" == "$output" ]
  [ "$status" -eq 0 ]
}
